MODEL	equ	0
	include lmacros.h
	assume	ds:dataseg
	public	intds

; setvec - set interrupt vector
; called from C as follows
; setvec(vec,csval,ipval)
; char vec;		/* Interrupt number */
; unsigned short csval;	/* CS register for vector */
; unsigned short ipval;	/* IP for vector */

	procdef	setvec,<<vec,byte>,<csval,word>,<ipval,word>>
	mov	cs:intds,ds	; save data segment pointer
	mov	ah,25h
	mov	al,vec
	mov	dx,ipval
	push	ds		; save
	mov	cx,csval
	push	cx
	pop	ds		; ds == csval
	int	21h
	pop	ds		; restore
	pret
	pend	setvec
intds	dw	0	; save loc for ds (must be in code segment)


; getvec - return current interrupt vector
; called from C as
; long		/* Returns CS in high word, IP in low word */
; getvec(vecnum)
; char vecnum;	/* Interrupt number */

	procdef	getvec,<<vecnum,byte>>
	mov	ah,35h
	mov	al,vecnum
	push	es	; save, since DOS uses it for a return value
	int	21h
	mov	dx,es	; CS value into DX (C high word)
	mov	ax,bx	; IP value into AX (C low word)
	pop	es	; restore es
	pret
	pend	getvec

; asy0vec - asynch channel 0 interrupt handler
	public	asyint_,asy0vec_
asy0vec_ proc	far
	push	ds		; save on user stack
	mov	ds,cs:intds	; establish interrupt data segment

	mov	ds:sssave,ss	; stash user stack context
	mov	ds:spsave,sp

	mov	ss,cs:intds	; set up interrupt stack
	lea	sp,intstk+512

	push	ax		; save user regs on interrupt stack
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	push	es
	mov	es,cs:intds	; set up es reg, so di can be used!!

	mov	ax,0		; arg for service routine
	push	ax
	call	asyint_
	pop	ax

doret:	mov	al,20h		; 8259 end-of-interrupt command
	out	20h,al
	pop	es
	pop	di
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	ss,sssave
	mov	sp,spsave	; restore original stack context
	pop	ds
	iret
asy0vec_	endp

; asy1vec - asynch channel 1 interrupt handler
	public	asyint_,asy1vec_
asy1vec_	proc	far
	push	ds		; save on user stack
	mov	ds,cs:intds	; establish interrupt data segment

	mov	ds:sssave,ss	; stash user stack context
	mov	ds:spsave,sp

	mov	ss,cs:intds	; set up interrupt stack
	lea	sp,intstk+512

	push	ax		; save user regs on interrupt stack
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	push	es
	mov	es,cs:intds	; set up es reg, so di can be used!!

	mov	ax,1		; arg for service routine
	push	ax
	call	asyint_
	pop	ax
	jmp	doret
asy1vec_	endp

; ec0vec - Ethernet interrupt handler
	public	ecint_,ec0vec_
ec0vec_ proc	far
	push	ds		; save on user stack
	mov	ds,cs:intds	; establish interrupt data segment

	mov	ds:sssave,ss	; stash user stack context
	mov	ds:spsave,sp

	mov	ss,cs:intds	; set up interrupt stack
	lea	sp,intstk+512

	push	ax		; save user regs on interrupt stack
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	push	es
	mov	es,cs:intds	; set up es reg, so di can be used!!

	mov	ax,0		; arg for service routine
	push	ax
	call	ecint_
	pop	ax
	jmp	doret
ec0vec_	endp

; pc0vec - PC-100 card #0 interrupt handler
	public	pcint_,pc0vec_
pc0vec_	proc	far
	push	ds		; save on user stack
	mov	ds,cs:intds	; establish interrupt data segment

	mov	ds:sssave,ss	; stash user stack context
	mov	ds:spsave,sp

	mov	ss,cs:intds	; set up interrupt stack
	lea	sp,intstk+512

	push	ax		; save user regs on interrupt stack
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	push	es
	mov	es,cs:intds	; set up es reg, so di can be used!!

	mov	ax,0		; arg for service routine
	push	ax
	call	pcint_
	pop	ax
	jmp	doret
pc0vec_	endp

; clksec - return current second value
	procdef	clksec
	mov	ah,2ch
	int	21h
	mov	al,dh
	mov	ah,0
	pret
	pend	clksec

; kbraw - raw, nonblocking read from console
; If character is ready, return it; if not, return -1

	procdef	kbraw
	mov	ah,06h	; Direct Console I/O
	mov	dl,0ffh	; Read from keyboard
	int	21h	; Call DOS
	jz	nochar	; zero flag set -> no character ready
	mov	ah,0	; valid char is 0-255
	pret
nochar:
	mov	ax,-1	; no char, return -1
	pret
	pend	kbraw

	procdef	getcs
	mov	ax,cs
	pret
	pend	getcs

	procdef	getds
	mov	ax,ds
	pret
	pend	getds

; disable - disable interrupts and return previous state: 0 = disabled,
;           1 = enabled

	procdef	disable
	pushf			; save state on stack
	cli			; interrupts off
	pop	ax		; original flags -> ax
	and	ax,200h		; 1<<9 is IF bit
	jnz	ion		; nonzero -> interrupts were on
	pret
ion:	mov	ax,1
	pret
	pend	disable

; restore - restore interrupt state: 0 = off, nonzero = on

	procdef	restore,<<istate,byte>>
	test	istate,0ffh
	jz	ioff
	sti
ioff:	pret
	pend	restore

; fast buffer I/O routines -- used by 3-COM Ethernet controller

; outbuf - put a buffer to an output port
	procdef outbuf,<<oport,word>,<obuf,word>,<ocnt,word>>
	pushf
	push	si
	mov	dx,oport
	mov	cx,ocnt
	mov	si,obuf
	cld

xb:	lodsb		; do { al = *si++;
	out	dx,al	; out(dx,al);
	loop	xb	; } while(--cx != 0);

	pop	si
	popf
	pret
	pend	outbuf

; inbuf - get a buffer from an input port
	procdef inbuf,<<iport,word>,<ibuf,word>,<icnt,word>>
	pushf
	push	di
	mov	dx,iport
	mov	cx,icnt
	mov	di,ibuf
	cld

rb:	in	al,dx	; do { al = in(dx);
	stosb		; *di++ = al;
	loop	rb	; } while(--cx != 0);

	pop	di
	popf
	pret
	pend	inbuf

; Halt until an interrupt occurs, then return
	procdef eihalt
	sti	; make sure interrupts are enabled
	hlt
	pret
	pend	eihalt

; Relinquish processor so other doubledos task can run
	procdef	giveup
	mov	al,2		; 110 ms
	mov	ah,0eeh
	int	21h
	pret
	pend	giveup

	finish
dataseg	segment	para public 'data'
	bss	sssave:word,2
	bss	spsave:word,2
	bss	intstk:byte,512
dataseg	ends
	end
