/* Interface driver for the PACCOMM PC-100 board for the IBM PC */
/* UNFINISHED, DOESN'T WORK YET */
#ifdef	TRACE
#include <stdio.h>
#endif

#include "machdep.h"
#include "mbuf.h"
#include "iface.h"
#include "pc100.h"
#include "ax25.h"

struct pc100 pc100[NPC];
int pc0vec();
int (*pchandle[])() = { pc0vec };
struct hdlc hdlc[2*NPC];
int16 npc;

/* Branch table for interrupt handler */
int htxint(), hexint(), hrxint(), hspint();
static int (*svec[])() = {
	htxint, hexint, hrxint, hspint
};

/* Master interrupt handler for the PC-100 card. All interrupts come
 * here first, then are switched out to the appropriate routine.
 */
pcint(dev)
int16 dev;
{
	register char iv;
	register int16 pcbase;
	struct hdlc *hp;
	
	pc100[dev].ints++;
	pcbase = pc100[dev].addr;

	/* Read interrupt vector, including status, from channel B */
	iv = read_sio(pcbase+CHANB,R2);

	hp = &hdlc[2 * dev + ((iv & 0x80)? 0 : 1)];

	/* Now switch to appropriate routine */
	(*svec[(iv>>1) & 0x3])(hp);

	/* Reset interrupt pending state (register A only) */
	write_sio(pcbase+CHANA,R0,RET_INT);
}
/* HDLC Special Receive Condition interrupt
 * The most common event that triggers this interrupt is the
 * end of a frame; it can also be caused by a receiver overflow.
 */
static
hspint(hp)
register struct hdlc *hp;
{
	register char c;

	hp->spints++;
	c = read_sio(hp->base,R1);	/* Fetch latched bits */

	if((c & (END_FR|CRC_ERR)) == END_FR && hp->rcvbuf != NULLBUF
		&& hp->rcvbuf->cnt > 1){
		/* End of valid frame */
		hp->rcvbuf->cnt--;	/* Toss 1st crc byte */
		enqueue(&hp->rcvq,hp->rcvbuf);
		hp->rcvbuf = NULLBUF;
		hp->rcvcnt++;
	} else {
		/* An overflow or CRC error occurred; restart receiver */
		hp->crcerr++;
		if(hp->rcvbuf != NULLBUF){
			hp->rcp = hp->rcvbuf->data;
			hp->rcvbuf->cnt = 0;
		}
	}
	write_sio(hp->base,R0,ERR_RES);
}
/* HDLC SIO External/Status interrupts
 * The only one of direct interest is a receiver abort; the other
 * usual cause is a change in the modem control leads, so kick the
 * transmit interrupt routine.
 */
static
hexint(hp)
register struct hdlc *hp;
{
	hp->exints++;
	hp->status = read_sio(hp->base,R0);	/* Fetch status */
	if((hp->status & BRK_ABRT) && hp->rcvbuf != NULLBUF){
		hp->aborts++;
		/* Restart receiver */
		hp->rcp = hp->rcvbuf->data;
		hp->rcvbuf->cnt = 0;
	}
	write_sio(hp->base,R0,RES_EXT_INT);
	write_sio(hp->base,R0,RET_INT);
	/* Kick the transmit interrupt routine for a possible modem change */
	htxint(hp);
}
/* HDLC receiver interrupt handler. Allocates buffers off the freelist,
 * fills them with receive data, and puts them on the receive queue.
 */
static
hrxint(hp)
register struct hdlc *hp;
{
	register struct mbuf *bp;
	register int16 base;

	hp->rxints++;
	base = hp->base;
	/* Allocate a receive buffer if not already present */
	if((bp = hp->rcvbuf) == NULLBUF){
		bp = hp->rcvbuf = alloc_mbuf(hp->bufsiz);
		if(bp == NULLBUF){
			/* No memory, abort receiver */
			hp->nomem++;
			write_sio(base,R3,ENT_HM|RxENABLE|RxCRC_ENAB|Rx8);
			(void) inportb(base+DATA);
			return;
		}
		hp->rcp = hp->rcvbuf->data;
	}
	while(read_sio(base,R0) & Rx_CH_AV){
		if(bp->cnt++ >= hp->bufsiz){
			/* Too large; abort the receiver, toss buffer */
			hp->toobig++;
			write_sio(base,R3,ENT_HM|RxENABLE|RxCRC_ENAB|Rx8);
			(void) inportb(base+DATA);
			free_p(bp);
			hp->rcvbuf = NULLBUF;
			break;
		}
		/* Normal save */
		*hp->rcp++ = inportb(base+DATA);
	}
}
int ctswait;
/* HDLC transmit interrupt service routine
 *
 * The state variable tstate, along with some static pointers,
 * represents the state of the transmit "process".
 */
static
htxint(hp)
register struct hdlc *hp;
{
	register int16 base;
	char i_state,c;

	i_state = disable();
	hp->txints++;
	base = hp->base;
	while(read_sio(base,R0) & Tx_BUF_EMP){
		switch(hp->tstate){
		/* First here for efficiency */
		case ACTIVE:		/* Sending frame */
			if(pullup(&hp->sndbuf,&c,1) == 1){
				outportb(base+DATA,c);
			} else {
				/* Do this after sending the last byte */
				write_sio(base,R0,RES_Tx_P);
				if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF){
					switch(hp->mode){
					case CSMA:
						/* Begin transmitter shutdown */
						hp->tstate = FLUSH;
						break;
					case FULLDUP:
						hp->tstate = IDLE;
						break;
					}
				}
			}
			continue;
		case IDLE:
			/* Transmitter idle. Find a frame for transmission */
			if((hp->sndbuf = dequeue(&hp->sndq)) == NULLBUF)
				goto ret;

		case DEFER:	/* note fall-thru */
			if(hp->mode == CSMA && (hp->status & DCD)){
				hp->tstate = DEFER;
				goto ret;
			}
			rts(base,ON);	/* Transmitter on */
		case KEYUP:	/* note fall-thru */
			if((hp->status & CTS) == 0){
				ctswait++;
				hp->tstate = KEYUP;
				goto ret;
			}
			write_sio(base,R0,RES_Tx_CRC);
			pullup(&hp->sndbuf,&c,1);
			outportb(hp->base+DATA,c);
			hp->tstate = ACTIVE;
			write_sio(base,R0,RES_EOM_L);
			continue;
		case FLUSH:	/* Sending flush character */
			outportb(hp->base+DATA,0);
			hp->tstate = FIN2;
			continue;
		case FIN2:
			write_sio(base,R0,SEND_ABORT);
			hp->tstate = IDLE;
			rts(base,OFF);
			write_sio(base,R0,RES_Tx_P);
			continue;
		}
	}
ret:	restore(i_state);
}

/* Write SIO register */
static
write_sio(base,reg,val)
register int16 base;
char reg,val;
{
	char i_state;

	i_state = disable();
	/* Select register; note that point high is also written */
	if(reg != R0)
		outportb(base+CTL,NULLCODE|reg);
	outportb(base+CTL,val);
	restore(i_state);
}
/* Read SIO register */
static
char
read_sio(base,reg)
register int16 base;
char reg;
{
	char c,i_state;

	i_state = disable();
	/* Select register; note that point high is also written */
	if(reg != R0)
		outportb(base+CTL,NULLCODE|reg);
	c = inportb(base+CTL);
	restore(i_state);
	return c;
}
/* Set request-to-send on modem */
static
rts(base,x)
int16 base;
int x;
{
	char cmd;

	if(x)
		cmd = TxCRC_ENAB | RTS | TxENAB | Tx8 | DTR;
	else
		cmd = TxCRC_ENAB | TxENAB | Tx8 | DTR;
	write_sio(base,R5,cmd);
}
/* (re)Initialize HDLC controller parameters */
static
hdlcparam(hp)
register struct hdlc *hp;
{
	int16 tc;
	char i_state;
	register int16 base;

	/* Initialize 8530 channel for SDLC operation */
	base = hp->base;
	i_state = disable();

	switch(base & 2){
	case 2:
		write_sio(base,R9,CHRA);	/* Reset channel A */
		break;
	case 0:
		write_sio(base,R9,CHRB);	/* Reset channel B */
		break;
	}
	/* Wait/DMA disable, Int on all Rx chars + spec condition,
	 * parity NOT spec condition, TxINT enable, Ext Int enable
	 */
	write_sio(base,R1,INT_ALL_Rx | TxINT_ENAB | EXT_INT_ENAB);

	/* Dummy interrupt vector, will be modified by interrupt type
	 * (This probably isn't necessary)
	 */
	write_sio(base,R2,0);

	/* 8 bit RX chars, auto enables off, no hunt mode, RxCRC enable,
	 * no address search, no inhibit sync chars, enable RX
	 */
	write_sio(base,R3,Rx8|RxCRC_ENAB|RxENABLE);

	/* X1 clock, SDLC mode, Sync modes enable, parity disable
	 * (Note: the DPLL does a by-32 clock division, so it's not necessary
	 * to divide here).
	 */
	write_sio(base,R4,X1CLK | SDLC | SYNC_ENAB);

	/* DTR On, 8 bit TX chars, no break, TX enable, SDLC CRC,
	 * RTS off, TxCRC enable
	 */
	write_sio(base,R5,DTR|Tx8|TxENAB|TxCRC_ENAB);

	/* SDLC flag */
	write_sio(base,R7,FLAG);

	/* No reset, status low, master int enable, enable lower chain,
	 * no vector, vector includes status
	 */
	write_sio(base,R9,MIE|NV|VIS);
	/* CRC preset 1, NRZI encoding, no active on poll, flag idle,
	 * flag on underrun, no loop mode, 8 bit sync
	 */
	write_sio(base,R10,CRCPS|NRZI);

	/* Some channel-specific clock stuff here.  There is only one crystal,
	 * and it is connected to RTxCB (channel B). The TRxCB output is
	 * connected to the RTxCA input pin (channel A).
	 */
	switch(base & 2){	/* Kludgey way to tell which channel this is */
	case 2:
		/* Channel A: RTxC NO xtal, receive clock = DPLL output,
		 * transmit clock = DPLL output, TRxC = output, TRxCout = Xtal
		 */
		write_sio(base,R11,RCDPLL|TCDPLL|TRxCOI|TRxCXT);
		break;
	case 0:
		/* Channel B: RTxC XTAL, receive clock = DPLL output,
		 * transmit clock = DPLL output, TRxC = output, TRxCout = Xtal
		 * (TRxCB is cross-connected to RxTCA)
		 */
		write_sio(base,R11,RTxCX|RCDPLL|TCDPLL|TRxCOI|TRxCXT);
		break;
	}
	/* Compute and load baud rate generator time constant
	 * DPLL needs x32 clock
	 * XTAL is defined in pc100.h to be the crystal clock / (2 * 32)
	 */
	tc = XTAL/(hp->speed) - 2;
	write_sio(base,R12,tc & 0xff);
	write_sio(base,R13,(tc >> 8) & 0xff);

	write_sio(base,R14,SNRZI);	/* Set NRZI mode */
	write_sio(base,R14,SSBR);	/* Set DPLL source = BR generator */
	write_sio(base,R14,SEARCH);	/* Enter search mode */
	/* Set baud rate gen source = RTxC, enable baud rate gen */
	write_sio(base,R14,BRENABL);

	/* Break/abort IE, TX EOM IE, CTS IE, no SYNC/HUNT IE, DCD IE,
	 * no Zero Count IE
	 */
	write_sio(base,R15,BRKIE|TxUIE|CTSIE|DCDIE);

	restore(i_state);
	if(hp->mode == FULLDUP){
		rts(base,ON);
	} else if(hp->tstate == IDLE){
		rts(base,OFF);
	}
	return 0;
}
/* Attach a PC-100 interface to the system
 * argv[0]: hardware type, must be "pc100"
 * argv[1]: I/O address, e.g., "0x380"
 * argv[2]: vector, e.g., "2"
 * argv[3]: mode, must be:
 *	    "ax25" (AX.25 UI frame format)
 * argv[4]: interface label, e.g., "pc0"
 * argv[5]: receiver packet buffer size in bytes
 * argv[6]: maximum transmission unit, bytes
 * argv[7]: interface speed, e.g, "9600"
 */
pc_attach(argc,argv)
int argc;
char *argv[];
{
	register struct interface *if_pca,*if_pcb;
	extern struct interface *ifaces;
	struct hdlc *hp;
	int dev;
	char *malloc();
	int pc_init();
	int dopc();
	int pc_stop();
	int ax_send();
	int pc_output();
	long getvec();
	unsigned short getcs();	/* Returns current CS */

	if(npc >= NPC){
		printf("Too many pc100 controllers\r\n");
		return -1;
	}
	dev = npc++;

	/* Initialize hardware-level control structure */
	pc100[dev].addr = htoi(argv[1]);
	pc100[dev].vec = htoi(argv[2]);
	/* Initialize modems */
	outportb(pc100[dev].addr + MODEM_CTL,0x22);

	/* Save original interrupt vector */
	pc100[dev].oldvec = getvec(8+pc100[dev].vec);
	/* Set new interrupt vector */
	setvec(8+pc100[dev].vec,getcs(),(unsigned)pchandle[dev]);

	/* Create interface structures and fill in details */
	if_pca = (struct interface *)malloc(sizeof(struct interface));
	if_pcb = (struct interface *)malloc(sizeof(struct interface));

	if_pca->name = malloc((unsigned)strlen(argv[4])+1);
	strcpy(if_pca->name,argv[4]);
	if_pcb->name = malloc((unsigned)strlen(argv[4])+1);
	strcpy(if_pcb->name,argv[4]);
	if_pcb->name[strlen(argv[4]) - 1]++;	/* kludge */
	if_pcb->mtu = if_pca->mtu = atoi(argv[6]);
	if_pca->dev = 2*dev;
	if_pcb->dev = 2*dev + 1;
	if_pcb->recv = if_pca->recv = dopc;
	if_pcb->stop = if_pca->stop = pc_stop;
	if_pcb->output = if_pca->output = pc_output;

	if(strcmp(argv[3],"ax25") == 0){
		if_pcb->send = if_pca->send = ax_send;
		if_pcb->flags = if_pca->flags = IF_BROADCAST;
	}
	else {
		printf("Mode %s unknown for interface %s\r\n",
			argv[3],argv[4]);
		free((char *)if_pca);
		free((char *)if_pcb);
		return -1;
	}
	if_pca->next = if_pcb;
	if_pcb->next = ifaces;
	ifaces = if_pca;

	hp = &hdlc[2*dev+1];
	hp->speed = (unsigned)atoi(argv[7]);
	hp->base = pc100[dev].addr + CHANB;
	hp->bufsiz = atoi(argv[5]);
	hdlcparam(hp);

	hp = &hdlc[2*dev];
	hp->speed = (unsigned)atoi(argv[7]);
	hp->base = pc100[dev].addr + CHANA;
	hp->bufsiz = atoi(argv[5]);
	hdlcparam(hp);

	/* Clear mask (enable interrupt) in 8259 interrupt controller */
	clrbit(INTMASK,(char)(1<<pc100[dev].vec));

	return 0;
}
dopc(interface)
struct interface *interface;
{
	struct hdlc *hp;
	struct mbuf *bp;

	hp = &hdlc[interface->dev];
	while((bp = dequeue(&hp->rcvq)) != NULLBUF){
		hp->rcvcnt--;
		ax_recv(interface,bp);
	}	
}
pc_stop(iface)
struct interface *iface;
{
	int16 dev;

	dev = iface->dev;
	if(dev & 1)
		return;
	dev >>= 1;	/* Convert back into PC100 number */
	/* Set 8259 interrupt mask (turn off interrupts) */
	setbit(INTMASK,(char)(1<<pc100[dev].vec));

	/* Restore original interrupt vector */
	setvec(8+pc100[dev].vec,(unsigned)(pc100[dev].oldvec >> 16),
		(unsigned)(pc100[dev].oldvec & 0xffff));

	/* Force hardware reset */
	write_sio(pc100[dev].addr + CHANA,R9,FHWRES);
}
/* Send AX.25 frame on PC-100 interface */
pc_output(interface,dest,src,pid,bp)
struct interface *interface;
struct addr *dest;	/* Destination AX.25 address (7 bytes, shifted) */
struct addr *src;	/* Source AX.25 address (7 bytes, shifted) */
char pid;		/* Protocol ID */
struct mbuf *bp;	/* Data field (follows PID) */
{
	char kickflag;
	extern int16 trace;
	struct hdlc *hp;
	struct mbuf *ax_encode();

	hp = &hdlc[interface->dev];
	if((bp = ax_encode(dest,src,pid,bp)) == NULLBUF)
		return;
#ifdef	TRACE
	if(trace){
		printf("%s sent:\r\n",interface->name);
		if((trace & 0xf) > 1)
			ax25_dump(bp);
		if(trace & 0x10)
			hexdump(bp);
		fflush(stdout);
	}
#endif
	kickflag = (hp->sndq == NULL);
	enqueue(&hp->sndq,bp);
	if(kickflag)
		htxint(&hdlc[interface->dev]);
}
