/* Main network program - provides both client and server functions */
#define	NSESSIONS	10	/* Maximum interactive client sessions */
#define HOSTNAMELEN 32		/* changed from 16 by Bdale 860812 */

#ifdef UNIX
# define STARTUP "START"
#endif

#ifndef	STARTUP
#define	STARTUP	"/autoexec.net"	/* File to read startup commands from */
#endif

#include <stdio.h>
#include "machdep.h"
#include "mbuf.h"
#include "netuser.h"
#include "timer.h"
#include "icmp.h"
#include "iface.h"
#include "ip.h"
#include "tcp.h"
#include "ftp.h"
#include "telnet.h"
#include "session.h"
#include "cmdparse.h"
#include "pc.h"

extern struct interface *ifaces;
struct session sessions[NSESSIONS];
struct session *current;

int mode;
FILE *logfp;
int16 trace;

char hostname[HOSTNAMELEN];	
int32 aton();
int16 lport = 1001;
char prompt[] = "net> ";
char nospace[] = "No space!!\r\n";	/* Generic malloc fail message */
static char notval[] = "Not a valid TCB\r\n";

#ifndef	MSDOS			/* PC uses F-10 key always */
static char escape = 0x1d;	/* default escape character is ^] */
#endif

/* Command lookup and branch table */
int go(),cmdmode(),doipaddr(),dotelnet(),doexit(),doclose(),dohostname(),
	doreset(),dotcpstat(),dotrace(),doescape(),dospeed(),dohelp(),
	dowindow(),doroute(),doecho(),
	dolog(),doipstat(),doicmpstat(),doetherstat(),doarp(),
	dosession(),doftp(),dosmtp(),domss(),dostart(),dostop(),doattach(),
	domycall(), dosmtptick(),doudpstat();

# ifndef unix
int memstat();
# endif

static struct cmds cmds[] = {
	"",		go,		/* must be first */
	"arp",		doarp,
	"attach",	doattach,
	"close",	doclose,
	"echo",		doecho,
#ifndef	MSDOS
	"escape",	doescape,
#endif
#ifdef	ETHER
	"etherstat",	doetherstat,
#endif
	"exit",		doexit,
	"ftp",		doftp,
	"help",		dohelp,
	"hostname",	dohostname,
	"log",		dolog,
	"icmpstat",	doicmpstat,
	"ipaddr",	doipaddr,
	"ipstat",	doipstat,
	"mail",		dosmtp,
	"smtp",		dosmtptick,	/* allow forcing client for testing */
# ifndef unix
	"memstat",	memstat,
# endif
	"mss",		domss,
#ifdef	AX25
	"mycall",	domycall,
#endif
	"reset",	doreset,
	"route",	doroute,
	"session",	dosession,
	"speed",	dospeed,
#ifdef	SERVERS
	"start",	dostart,
	"stop",		dostop,
#endif
	"tcpstat",	dotcpstat,
	"telnet",	dotelnet,
	"trace",	dotrace,
	"udpstat",	doudpstat,
	"window",	dowindow,
	"?",		dohelp,
	NULLCHAR,	NULLFP
};

/* "route" subcommands */
int doadd(),dodrop();
static struct cmds rtcmds[] = {
	"add",		doadd,
	"drop",		dodrop,
	NULLCHAR,	NULLFP,
};

#ifdef	SERVERS
/* "start" and "stop" subcommands */
int ftp_start(),smtp_start(),discard_start(),echo_start(),telnet_start();
static struct cmds startcmds[] = {
	"discard",	discard_start,
	"echo",		echo_start,
	"ftp",		ftp_start,
	"smtp",		smtp_start,
	"telnet",	telnet_start,
	NULLCHAR,	NULLFP,
};
int ftp_stop(),smtp_stop(),echo_stop(),discard_stop(),telnet_stop();
static struct cmds stopcmds[] = {
	"discard",	discard_stop,
	"echo",		echo_stop,
	"ftp",		ftp_stop,
	"smtp",		smtp_stop,
	"telnet",	telnet_stop,
	NULLCHAR,	NULLFP,
};
#endif

main(argc,argv)
int argc;
char *argv[];
{
	static char inbuf[BUFSIZ];	/* keep it off the stack */
	int16 clkval;
	int c;
	char *ttybuf,*fgets();
	int16 cnt;
	int ttydriv();
	int cmdparse();
	FILE *fp;
	struct interface *ifp;

	ioinit();
	if((fp = fopen(STARTUP,"r")) != NULLFILE){
		while(fgets(inbuf,BUFSIZ,fp) != NULLCHAR){
			cmdparse(cmds,inbuf);
		}
		fclose(fp);
	}		
	cmdmode();
	clkval = clksec();
#ifdef	notdef
	smtpclinit();			/* arm SMTP background client timer */
#endif

	/* Main commutator loop */
	for(;;){
		/* Process any keyboard input */
		while((c = kbread()) != -1){
#ifdef	MSDOS
			/* c == -2 means the command escape key (F10) */
			if(c == -2){
				if(mode != CMD_MODE){
					printf("\r\n");
					cmdmode();
				}
				continue;
			}
#endif
			if((cnt = ttydriv(c,&ttybuf)) == 0)
				continue;
			switch(mode){
			case CMD_MODE:
				if(cmdparse(cmds,ttybuf) == -1)
					printf("eh?\r\n");
				fflush(stdout);
				break;
			case CONV_MODE:
#ifndef	MSDOS
				if(ttybuf[0] == escape && escape != 0){
					printf("\r\n");
					cmdmode();
				} else
#endif MSDOS
					if(current->parse != NULLFP)
						(*current->parse)(ttybuf,cnt);

				break;
			}
			if(mode == CMD_MODE){
				printf(prompt);
				fflush(stdout);
			}
		}
		/* Service the interfaces */
		for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next){
			if(ifp->recv != NULLFP)
				(*ifp->recv)(ifp);
		}

		/* Service the clock if it has ticked */
		if(clkval != clksec()){
			clkval = clksec();
			tick();
			(void)iss();
		}


#ifdef	MSDOS
		/* Tell DoubleDos to let the other task run for awhile.
		 * If DoubleDos isn't active, this is a no-op
		 */
		giveup();
#else
		/* Wait until interrupt, then do it all over again */
		eihalt();
#endif
	}
}

/* Enter command mode */
int
cmdmode()
{
	if(mode != CMD_MODE){
		mode = CMD_MODE;
		cooked();
		printf(prompt);
		fflush(stdout);
	}
	return 0;
}
/* Select and display sessions */
static
dosession(argc,argv)
int argc;
char *argv[];
{
	unsigned i;
	struct session *s;
	extern char *tcpstates[];
	char *psocket();

	if(argc < 2){
		printf(" #  Type    Remote socket          TCB  State\r\n");
		for(s=sessions;s < & sessions[NSESSIONS];s++){
			switch(s->type){
			case TELNET:
				printf("%c%-3d%Telnet  %-23s%4x %-s\r\n",
					(current == s)? '*':' ',
					s - sessions,
					psocket(&s->cb.telnet->tcb->conn.remote),
					(int)s->cb.telnet->tcb,
					tcpstates[s->cb.telnet->tcb->state]);
				break;
			case FTP:
				printf("%c%-3d%FTP     %-23s%4x %-s\r\n",
					(current == s)? '*':' ',
					s - sessions,
					psocket(&s->cb.ftp->control->conn.remote),
					(int)s->cb.ftp->control,
					tcpstates[s->cb.ftp->control->state]);
				break;
			}
		}
		return 0;
	}
	i = atoi(argv[1]);
	if(i > NSESSIONS){
		printf("Invalid session: %d\r\n",i);
		return 1;
	}
	if(sessions[i].type == FREE){
		printf("Inactive session: %d\r\n",i);
		return 1;
	}
	current = &sessions[i];
	go();
	return 0;
}
/* Enter conversational mode with current session */
int
go()
{
	void rcv_char(),r_ctl();

	if(current == NULLSESSION || current->type == FREE)
		return 0;
	mode = CONV_MODE;
	switch(current->type){
	case TELNET:
		if(current->cb.telnet->remote[TN_ECHO])
			raw();	/* Re-establish raw mode if it was set */
		rcv_char(current->cb.telnet->tcb,0); /* Get any pending input */
		break;
	case FTP:
		r_ctl(current->cb.ftp->control,0);
		break;
	}
	return 0;
}
static
doipaddr(argc,argv)
int argc;
char *argv[];
{
	char *inet_ntoa();
	struct interface *ifp;

	if(argc < 2){
		printf("%s\r\n",inet_ntoa(ip_addr));
		return 0;
	}
	rt_drop(ip_addr);		/* Remove old */
	ip_addr = aton(argv[1]);
	for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
		if(strcmp(ifp->name,"local") == 0)
			break;
	if(ifp != NULLIF)
		rt_add(ip_addr,0L,0,ifp);	/* Route our packets to ourself */
	return 0;
}
static
doexit(argc,argv)
int argc;
char *argv[];
{
	iostop();
	exit(0);
}
static
doclose(argc,argv)
int argc;
char *argv[];
{
	if(current == NULLSESSION){
		printf("No current session\r\n");
		return 0;
	}
	switch(current->type){
	case TELNET:
		close_tcp(current->cb.telnet->tcb);
		break;
	case FTP:
		close_tcp(current->cb.ftp->control);
		break;
	}
	return 0;
}
static
doreset(argc,argv)
int argc;
char *argv[];
{
	long htol();
	struct tcb *tcb;

	if(argc < 2){
		if(current == NULLSESSION){
			printf("No current session\r\n");
			return 1;
		}
		switch(current->type){
		case TELNET:
			tcb = current->cb.telnet->tcb;
			break;
		case FTP:
			tcb = current->cb.ftp->control;
			break;
		}
	} else
		tcb = (struct tcb *)htol(argv[1]);
	if(!tcpval(tcb)){
		printf(notval);
		return 1;
	}
	close_self(tcb,RESET);
	return 0;
}
static
int
dotcpstat(argc,argv)
int argc;
char *argv[];
{
	long htol();
	register struct tcb *tcb;

	if(argc < 2){
		tcpstat();
	} else {
		tcb = (struct tcb *)htol(argv[1]);
		if(tcpval(tcb))
			state_tcp(tcb);
		else
			printf(notval);
	}
	return 0;
}
static
int
dotrace(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2)
		printf("trace level 0x%x\r\n",trace);
	else
		trace = htoi(argv[1]);
	return 0;
}
static
dohostname(argc,argv)
int argc;
char *argv[];
{
	char *strncpy();

	if(argc < 2)
		printf("%s\r\n",hostname);
	else 
		strncpy(hostname,argv[1],HOSTNAMELEN);
	return 0;
}
static
int
dolog(argc,argv)
int argc;
char *argv[];
{
	char *strncpy();

	static char logname[15];
	if(argc < 2){
		if(logfp)
			printf("Logging to %s\r\n",logname);
		else
			printf("Logging off\r\n");
		return 0;
	}
	if(logfp){
		fclose(logfp);
		logfp = NULL;
	}
	if(strcmp(argv[1],"stop") != 0){
		strncpy(logname,argv[1],15);
		logfp = fopen(logname,"a+");
	}
	return 0;
}
#ifndef	MSDOS
static
int
doescape(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2)
		printf("0x%x\r\n",escape);
	else 
		escape = *argv[1];
	return 0;
}
#endif	MSDOS
static
int
dohelp(argc,argv)
int argc;
char *argv[];
{
	register struct cmds *cmdp;

	printf("Main commands:\r\n");
	for(cmdp = cmds;cmdp->name != NULL;cmdp++)
		printf("%s\r\n",cmdp->name);
	return 0;
}
static
int
domss(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2)
		printf("%d\r\n",tcp_mss);
	else
		tcp_mss = atoi(argv[1]);
	return 0;
}
static
int
dowindow(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2)
		printf("%d\r\n",tcp_window);
	else
		tcp_window = atoi(argv[1]);
	return 0;
}
struct session *
newsession()
{
	register int i;

	for(i=0;i<NSESSIONS;i++)
		if(sessions[i].type == FREE)
			return &sessions[i];
	return NULLSESSION;
}
freesession(s)
struct session *s;
{
	if(s != NULLSESSION)
		s->type = FREE;
}
/* Display and/or manipulate routing table */
int
doroute(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2){
		dumproute();
		return 0;
	}
	return subcmd(rtcmds,argc,argv);
}
/* Add an entry to the routing table
 * E.g., "add 1.2.3.4 ax0 5.6.7.8 3"
 */
int
doadd(argc,argv)
int argc;
char *argv[];
{
	struct interface *ifp;
	long dest,gateway;
	int metric;

	if(argc < 3){
		printf("Usage: add <dest> <interface> [gateway] [metric]\r\n");
		return 0;
	}
	if(strcmp(argv[1],"default") == 0)
		dest = 0;
	else
		dest = aton(argv[1]);

	for(ifp=ifaces;ifp != NULLIF;ifp = ifp->next){
		if(strcmp(argv[2],ifp->name) == 0)
			break;
	}
	if(ifp == NULL){
		printf("Interface \"%s\" unknown\r\n",argv[2]);
		return 1;
	}
	if(argc > 3)
		gateway = aton(argv[3]);
	else
		gateway = 0;
	if(argc > 4)
		metric = atoi(argv[4]);
	else
		metric = 0;

	rt_add(dest,gateway,metric,ifp);
	return 0;
}
/* Drop an entry from the routing table
 * E.g., "drop 1.2.3.4"
 */
int
dodrop(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2)
		printf("Usage: drop <dest>\r\n");
	else
		rt_drop(aton(argv[1]));
	return 0;
}
dostart(argc,argv)
int argc;
char *argv[];
{
	return subcmd(startcmds,argc,argv);
}
dostop(argc,argv)
int argc;
char *argv[];
{
	return subcmd(stopcmds,argc,argv);
}
doecho(argc,argv)
int argc;
char *argv[];
{
	extern int refuse_echo;

	if(argc < 2){
		if(refuse_echo)
			printf("Refuse\r\n");
		else
			printf("Accept\r\n");
	} else {
		if(strcmp(argv[1],"refuse") == 0)
			refuse_echo = 1;
		else if(strcmp(argv[1],"accept") == 0)
			refuse_echo = 0;
		else
			return -1;
	}
	return 0;
}
