#define	EC_MAX	1	/* Only one controller supported */

/* Find base address of specified device */
#define	IE(dev)	(ec_dev[dev].addr)

/* Format of an Ethernet header */
struct ether {
	char dest[6];
	char source[6];
	int16 type;
};
/* Ethernet broadcast address */
extern char ether_bdcst[];

/* Ethernet type fields */
#define	IP_TYPE		0x800	/* Type field for IP */
#define	ARP_TYPE	0x806	/* Type field for ARP */

#define	HDR		sizeof(struct ether)	/* Size of Ethernet header */
struct estats {
	long ints;		/* Interrupts */
	unsigned spur;		/* Spurious interrupts */
	unsigned shorts;	/* Short packets */
	unsigned dribble;	/* Packets with extra bits */
	unsigned fcs;		/* Packets with CRC errors */
	unsigned over;		/* Overflow errors */
	long any;		/* Good packets received */
	unsigned stale;		/* Stale status on interrupt */
	unsigned badsize;	/* Packets longer than legal length */
	long out;		/* Total output packets */
	unsigned timeout;	/* Transmitter timeouts */
	unsigned badtype;	/* Packets with unknown type fields */
	unsigned drop;		/* Dropped because RX queue too long */
	unsigned nomem;		/* Dropped because buffer malloc failed */
};
struct ec {
	char addr[6];		/* Ethernet address */
	unsigned base;		/* Base I/O address */
	unsigned vec;		/* Interrupt vector */
	struct mbuf *rcvq;	/* Queue of incoming packets */
	unsigned rcvcnt;	/* Number of packets on queue */
	unsigned rcvmax;	/* Maximum length of rcvq */
	struct estats estats;	/* Controller statistics */
};
extern struct ec ec[];

	
