/* Parse command line, set up command arguments Unix-style, and call function.
 * Note: argument is modified (delimiters are overwritten with nulls)
 */
#include "cmdparse.h"
int
cmdparse(cmds,line)
struct cmds cmds[];
register char *line;
{
	struct cmds *cmdp;
	char *argv[NARG],*cp,*index();
	int argc,qflag;

	/* Remove cr/lf */
	if((cp = index(line,'\r')) != NULLCHAR)
		*cp = '\0';
	if((cp = index(line,'\n')) != NULLCHAR)
		*cp = '\0';	/* shouldn't be necessary */

	for(argc = 0;argc < NARG;argc++)
		argv[argc] = NULLCHAR;

	for(argc = 0;argc < NARG;){
		qflag = 0;
		/* Skip leading white space */
		while(*line == ' ' || *line == '\t')
			line++;
		if(*line == '\0')
			break;
		/* Check for quoted token */
		if(*line == '"'){
			line++;	/* Suppress quote */
			qflag = 1;
		}
		argv[argc++] = line;	/* Beginning of token */
		/* Find terminating delimiter */
		if(qflag){
			/* Find quote, it must be present */
			if((line = index(line,'"')) == NULLCHAR){
				return -1;
			}
		} else {
			/* Find space or tab. If not present,
			 * then we've already found the last
			 * token.
			 */
			if((cp = index(line,' ')) == NULLCHAR
			 && (cp = index(line,'\t')) == NULLCHAR){
				break;
			}
			*cp++ = '\0';
			line = cp;
		}
	}
	/* Lines beginning with "#" are comments */
	if(argv[0] == NULLCHAR || argv[0][0] == '#')
		return 0;
	/* Look up command in table; prefix matches are OK */
	for(cmdp = cmds;cmdp->name != NULLCHAR;cmdp++){
		if(strncmp(argv[0],cmdp->name,strlen(argv[0])) == 0)
			break;
	}
	if(cmdp->name == NULLCHAR)
		return -1;
	else
		return (*cmdp->func)(argc,argv);
}

/* Call a subcommand based on the first token in an already-parsed line */
int
subcmd(tab,argc,argv)
struct cmds tab[];
int argc;
char *argv[];
{
	register struct cmds *cmdp;

	/* Strip off first token and pass rest of line to subcommand */
	argc--;
	argv++;
	for(cmdp = tab;cmdp->name != NULLCHAR;cmdp++){
		if(strncmp(argv[0],cmdp->name,strlen(argv[0])) == 0){
			return (*cmdp->func)(argc,argv);
		}
	}
	return -1;
}
