/*
**	stuff here that was in pc.c, but is (more or less) machine independant
*/

# include "machdep.h"
# include "cmdparse.h"

extern struct interface if_lo;

/* Interface list; initialized at compile time to contain
 * just the local interface
 */
struct interface *ifaces = &if_lo;

# ifdef MSDOS
int ec_attach(),asy_attach(),pc_attach();
# endif

# ifdef unix
int ec_attach(), asy_attach();
# endif

struct cmds attab[] = {
# ifdef MSDOS
    "3c500",	ec_attach,
    "asy",	asy_attach,
    "pc100",	pc_attach,
# endif MSDOS
# ifdef unix
    "ether",	ec_attach,
    "tty",	asy_attach,
# endif unix
    NULLCHAR,	NULLFP,
};

extern int nasy;		/* number of asych devices configured */

/* Attach an interface
 * Syntax: attach <type> <I/O addr> <vector> <mode> <label> <bufsize> [<speed>]
 */
doattach(argc,argv)
int argc;
char *argv[];
{
    if(argc < 6){
	printf("Usage: attach <type> <I/O adr> <vec> <mode> <lbl> [<spd>]\r\n");
		return -1;
	}
	return subcmd(attab,argc,argv);
}

int
dospeed(argc,argv)
int argc;
char *argv[];
{
	int i;

	if(argc < 3){
		for(i=0;i < nasy; i++){
			printf("%d: %d bps\r\n",i, asy_getspeed(i) );
		}
		return 0;
	}
	i = atoi(argv[1]);
	if(i >= nasy){
		printf("Line %d out of range\r\n",i);
		return 0;
	}
	asy_setspeed(i,atoi(argv[2]));
	return 0;
}

/* Convert hex-ascii to integer */
int
htoi(s)
register char *s;
{
    register int i = 0;
    register char c;

    while((c = *s++) != '\0'){
	if( c == 'x' )
	    if( i == 0 )
		continue;		/* allow 0x notation */
	    else
		break;
	if('0' <= c && c < '9')
	    i = (i << 4) + (c - '0');
	else if('a' <= c && c <= 'f')
	    i = (i << 4) + (c - 'a' + 10);
	else if('A' <= c && c <= 'F')
	    i = (i << 4) + (c - 'A' + 10);
	else
	    break;
    }
    return i;
}
