#include <stdio.h>
/* memory allocation routines
 *
 * Adapted from Aztec user-supplied code by William C. Colley III; MUST
 * be used in place of original, *BUGGY* Aztec code!
 *
 * Routines realloc() and calloc() were added; only minor format changes
 * made elsewhere.
 */

#ifndef	NULL
#define	NULL	(void *)0
#endif

#define	NULLCHAR	(char *)NULL
union header {
	struct {
		union header *ptr;
		unsigned size;
	} s;
	long l;
};

typedef union header HEADER;
#define	NULLHDR	(HEADER *)NULL
static HEADER base, *allocp = NULLHDR;
static unsigned memfail;

/* Allocate block of 'nb' bytes */
char *
malloc(nb)
unsigned nb;
{
	HEADER *morecore();
	register HEADER *p, *q;
	register unsigned nu;
	char i_state;

	i_state = disable();
	nu = ((nb + 3) >> 2) + 1;
	if ((q = allocp) == NULLHDR){
		base.s.ptr = allocp = q = &base;
		base.s.size = 1;
	}
	for (p = q->s.ptr; ; q = p, p = p->s.ptr){
		if (p->s.size >= nu){
			if (p->s.size == nu){
				q->s.ptr = p->s.ptr;
			} else {
				p->s.size -= nu;
				p += p->s.size;
				p->s.size = nu;
			}
			allocp = q;
			p->s.ptr = p;	/* for auditing */
			restore(i_state);
			return (char *)(p + 1);
		}
		if (p == allocp && (p = morecore(nu)) == NULLHDR){
			memfail++;
			restore(i_state);
			return NULLCHAR;
		}
	}
}

/* Get more memory from the system and put it on the heap */
HEADER *
morecore(nu)
unsigned nu;
{
	char *sbrk();
	register char *cp;
	register HEADER *up;

	if ((int)(cp = sbrk(nu << 2)) == -1)
		return NULLHDR;
	up = (HEADER *)cp;
	up->s.size = nu;
	up->s.ptr = up;	/* satisfy audit */
	free((char *)(up + 1));
	return allocp;
}
/* Grab as much memory as possible from the system and put it on the heap */
unsigned
grabcore()
{
	char *sbrk(),*cp;
	register HEADER *up;
	register unsigned int size;

	/* Initialize the heap pointers */
	if (allocp == NULLHDR){
		base.s.ptr = allocp = &base;
		base.s.size = 1;
	}
	/* Find out where the break is */
	cp = sbrk(0);
	/* Now try to push it as high as possible */
	for(size=256;;size += 256){
		if(brk(cp + size) != 0)
			break;
	}
	up = (HEADER *)cp;
	up->s.size = size / sizeof(HEADER);
	up->s.ptr = up;	/* satisfy audit */
	free((char *)(up + 1));
	return size;
}

/* Put memory block back on heap */
free(blk)
char *blk;
{
	register HEADER *p, *q;
	char i_state;

	i_state = disable();
	p = (HEADER *)blk - 1;
	/* Audit check */
	if(p->s.ptr != p){
		printf("PANIC: freeing garbage (0x%x)\r\n",blk);
		restore(i_state);
#ifdef	Z80
		printf("SP = 0x%x\r\n",getsp());
		for(;;) ;
#else
		iostop();
		exit(1);
#endif
	}
	for(q = allocp; !(p > q && p < q->s.ptr); q = q->s.ptr){
		if (q >= q ->s.ptr && (p > q || p < q->s.ptr))
			break;
	}
	if(p + p->s.size == q->s.ptr){
		p->s.size += q->s.ptr->s.size;
		p->s.ptr = q->s.ptr->s.ptr;
	} else
		p->s.ptr = q->s.ptr;
	if(q + q->s.size == p){
		q->s.size += p->s.size;
		q->s.ptr = p->s.ptr;
	}
	else q->s.ptr = p;
	allocp = q;
	restore(i_state);
}

/* Move existing block to new area */
char *
realloc(area,size)
char *area;
unsigned size;
{
	unsigned osize;
	HEADER *hp;
	char *cp;
	char i_state;

	hp = ((HEADER *)area) - 1;
	osize = (hp->s.size -1) << 2;

	/* Make sure nobody else comes in and takes it */
	i_state = disable();
	free(area);
	if((cp = malloc(size)) != NULLCHAR && cp != area)
		movmem((char *)area,(char *)cp,size>osize? osize : size);
	restore(i_state);
	return cp;
}
/* Allocate block of cleared memory */
char *
calloc(nelem,size)
unsigned nelem;	/* Number of elements */
unsigned size;	/* Size of each element */
{
	register unsigned i;
	register char *cp;

	i = nelem * size;
	if((cp = malloc(i)) != NULLCHAR)
		setmem(cp,i,0);
	return cp;
}
/* Print free list map */
memstat()
{
	HEADER *p;

	printf("malloc fails %u\r\n",memfail);
	p = &base;
	do {
		printf("0x%x %u",(unsigned)p,p->s.size * sizeof(HEADER));
		if(p == allocp)
			printf(" <-- allocp\r\n");
		else
			printf("\r\n");
		p = p->s.ptr;
	} while(p != &base);
	fflush(stdout);
}
