
#include <stdio.h>
#include <minix/font.h>

struct sbc_font fontbuf;
char tmpbuf[1024];

main()
{
    memset(&fontbuf, 0, SBC_STRUCT_SIZE);
    read_bdf();
    if (write(1, &fontbuf, SBC_STRUCT_SIZE) < 0) {
	fprintf(stderr, "write error\n");
	exit(1);
    }
}

read_bdf()
{
    char buf[200];
    unsigned char bit[16];
    int code, a1,a2,i,n;
    int ch_high, ch_width;
    short *ip;
    long csum;

    memset(tmpbuf, 0, 1024);
    while(gets(buf) != EOF) {
	if (strncmp(buf, "FONTBOUNDINGBOX ", 16) == 0) {
		sscanf(buf+16,"%d %d %d %d", &ch_width, &ch_high, &a1, &a2);
		continue;
	}
	if (strncmp(buf, "STARTCHAR ", 10) == 0) {
		sscanf(buf+10,"%04x",&code);
		continue;
	}
	if (strcmp(buf, "BITMAP") == 0) {
		n = 0;
		while (gets(buf) != EOF) {
		    if (strcmp(buf, "ENDCHAR") == 0) break;
		    if (n < 16) sscanf(buf, "%02x", &bit[n++]);
		}
		a1 = (16 - n) / 2;
		memcpy(&fontbuf.patern[code * SBC_FONT_SIZE]+a1, bit, n);
		continue;
	}
	if (strncmp(buf, "COMMENT ", 8) == 0) {
		if (strlen(tmpbuf) < FH_MEMO_SIZE) {
		    strcat(tmpbuf,buf+8);
		    strcat(tmpbuf,"\n");
		}
		continue;
	}
	if (strncmp(buf, "COPYRIGHT", 9) == 0) {
		strcat(fontbuf.head.memo, buf);
		strcat(fontbuf.head.memo, "\n");
		continue;
	}
	if (strcmp(buf, "ENDFONT") == 0) break;
    } /* while */
    strncat(fontbuf.head.memo, tmpbuf, FH_MEMO_SIZE - strlen(fontbuf.head.memo));
    fontbuf.head.fnt_size = SBC_FONT_SIZE;
    fontbuf.head.fnt_high = SBC_FONT_HIGH;
    fontbuf.head.fnt_width = SBC_FONT_WIDTH;
    fontbuf.head.top_code = 0;
    fontbuf.head.end_code = 255;
    csum = 0L;
    ip = (short *)&fontbuf;
    for(i=0; i < ((FONT_HEAD_SIZE - 4)/2); i++, ip++) csum += (long)*ip;
    fontbuf.head.sum = csum;
}
