
STACKSIZE	= 8192

DISK_BIOS	= 0x13
VIDEO_BIOS	= 0x10
KEY_BIOS	= 0x16

#include <minix/config.h>

#ifdef ASLD
.globl begtext, begdata, begbss, endtext, enddata, endbss  | asld needs these
#else
entry	crtso
#endif

.extern		_main
.extern		_setparam
.extern		_load_font

.define		_exit
.define		_putc
.define		_getc
.define		_p_memsize
.define		_dmaoverrun
.define		_HD_read
.define		_hdparam
.define		_emxfer
.define		_rom_font_base
.define		_cpu
.define		_keybd_id


		.text

begtext:
crtso:
start:	mov	dx,bx		| bootblok puts # sectors/track in bx
	xor	ax,ax
	mov	bx,#_edata	| prepare to clear bss
	mov	cx,#_end
	sub	cx,bx
	sar	cx,*1
st.1:	mov	(bx),ax		| clear bss
	add	bx,#2
	loop	st.1
	mov	sp,#kerstack+STACKSIZE
	push	dx
	movb	al,dh
	push	ax		| boot drive
	movb	al,dl
	push	ax		| boot partition
	call	_setparam
	pop	ax
	pop	ax		| drop args
	pop	dx

#ifdef QUIET
	orb	dh,dh
	jz	menu
	cmp	_errors,#0
	jnz	menu
	movb	ah,*2
	int	KEY_BIOS
	mov	bx,#_boot_parameters
	mov	bx,6(bx)		| boot_parameters.bp_scancode
	andb	al,*3
	jnz	menu
	push	bx
	call	_load_font		| load char font
	pop	bx
	or	ax,ax
	jnz	jmp_ker
#endif

menu:	call	_main
	mov	bx,ax		| put scan code for '=' in bx
jmp_ker:
	xor	ax,ax
	mov	es,ax
	seg	es
	testb	0x043f,*0x0F
	jz	L001
	mov	dx,#0x3F2
	movb	al,*0x0C
	out
L001:
#if DBCS_CONSOLE
	mov	bp,#_sys_font	| font table parameters
#endif
	sub	ax,ax		| ax == 0 to show new boot (was scan code)
	mov	si,#_boot_parameters	| pointer to boot parameters in di:si
	mov	di,ds
	mov	cx,#10		| sizeof structure in cx
				| next 'cli' and setting up segs is redundant
				| and the segments are wrong for sep I&D
	cli
	mov	dx,#0x60
	mov	ds,dx
	mov	es,dx
	mov	ss,dx
	jmpi	0,0x60		| jmp to kernel

_exit:	mov	sp,#kerstack+STACKSIZE
	jmp	menu

_putc:	push	bp
	mov	bp,sp
	movb	al,4(bp)	| al contains char to be printed
	mov	bx,#1
	movb	ah,*14
	int	VIDEO_BIOS
#ifdef DEBUG
pause:		movb	ah,*2
		int	KEY_BIOS
		andb	al,*3
		jnz	pause
#endif
	pop	bp
	ret

_getc:
	xorb	ah,ah
	int	KEY_BIOS
#if (LANGUAGE == JAPANESE)
	cmpb	al,#0x5f
	jnz	getc9
	push	ax
	movb	ah,*2
	int	KEY_BIOS
	pop	bx
	xchg	ax,bx
	andb	bl,*3
	jz	getc9
	mov	ax,#0x8c3d
getc9:
#endif
	ret

.define		_getch
_getch:		xorb	ah,ah
		int	KEY_BIOS
		ret

_cpu:		push	sp
		pop	ax
		cmp	ax,sp
		jz	i80x86
		mov	ax,#88
		ret

i80x86:		mov	ax,#286
		ret

#ifdef DEBUG
pause:		movb	ah,*2
		int	KEY_BIOS
		andb	al,*3
		jnz	pause
#endif
		pop	bx
		ret

_p_memsize:	push	sp			| get extended memory size
		pop	ax
		cmp	ax,sp
		jz	getpmsiz
		xor	ax,ax
		ret
getpmsiz:	movb	ah,*0x88
		int	0x15
		ret

_dmaoverrun:	push	bp			| check DMA overrun
		mov	bp,sp
		mov	ax,ds
		movb	cl,*4
		shl	ax,cl
		add	ax,4(bp)
		add	ax,#1024 - 1
		mov	ax,#0
		jnc	dma_ok
		inc	ax
dma_ok:		pop	bp
		ret

|	HD_read(int drive, char *buff, long offset);
_HD_read:	push	bp
		mov	bp,sp
		push	di
		push	si
		mov	di,#0x80
hd_read1:	mov	ax, 8(bp)	| offset Low
		mov	dx,10(bp)	| offset Hi
		div	cyl_size
		movb	ch,al		| cylinder number
		shr	ax,*1
		shr	ax,*1
		andb	al,*0xC0
		movb	cl,al		| cylinder-H
		mov	ax,dx
		xor	dx,dx
		div	trk_size
		movb	dh,al		| head address
		incb	dl		| sector start from 1
		orb	cl,dl		| cylinder + sector
		movb	dl,4(bp)	| drive
		mov	bx,_diskbuf	| buffer address
		mov	ax,#0x0202	| read 1 block
		int	DISK_BIOS
		jc	hd_retry
		mov	si,_diskbuf
		mov	di,6(bp)
		cmp	si,di
		jz	rd_hd9
		mov	cx,#512
		cld
		rep
		movw
rd_hd9:		xor	ax,ax
		pop	si
		pop	di
		pop	bp
		ret

hd_retry:	shr	di,*1
		jc	hdrderr
		movb	dl,4(bp)
		xor	ax,ax		| reset HDC
		int	DISK_BIOS
		j	hd_read1
		movb	al,ah
		xorb	ah,ah
hdrderr:	pop	si
		pop	di
		pop	bp
		ret

_hdparam:	push	bp
		mov	bp,sp
		movb	dl,4(bp)
		orb	dl,*0x80
		movb	ah,*8			| get drive parameter
		int	DISK_BIOS
		jc	hdperr
		incb	dh			| heads
		andb	cl,*0x3F
		movb	trk_size,cl		| sectors / track
		xchg	ax,cx
		mulb	dh
		mov	cyl_size,ax		| sectors / cylinder
hdperr:		pop	bp
		ret

fd_param:	mov	trk_size,*15
		mov	cyl_size,*30
		pop	bp
		ret

|
|  emxfer(char *src_buf, long ext_mem)
|
_emxfer:	push	bp
		mov	bp,sp
		push	es
		push	si
		mov	dx,ds
		mov	ax,4(bp)		| buffer address
		call	phys_addr
		mov	src_low,ax
		movb	src_hi,dl		| source address 24 bits
		mov	ax,6(bp)
		mov	tgt_low,ax
		mov	ax,8(bp)
		movb	tgt_hi,al		| target address
		mov	cx,#512			| transfer word count
		push	ds
		pop	es
		mov	si,#gdt
		movb	ah,*0x87		| move block function
		int	0x15
		orb	ah,ah
		jnz	err_ret			| error code in AH
		xor	ax,ax
err_ret:	pop	si
		pop	es
		pop	bp
		ret

_rom_font_base:	push	bp
		push	es
		mov	ax,#0x1130
		mov	bx,#0x0602		| get 8*16 ank font table
		int	VIDEO_BIOS
		mov	dx,es
		mov	ax,bp
		call	phys_addr
		pop	es
		pop	bp
		ret

phys_addr:	mov	bx,dx
		xor	dx,dx
		mov	cx,#4
s_shift:	shl	bx,*1
		rcl	dx,*1
		loop	s_shift
		add	ax,bx
		adc	dx,#0
		ret

_keybd_id:	movb	ah,*0x0a
		xor	bx,bx
		int	KEY_BIOS
		mov	ax,bx
		ret

csv:
	pop	bx
	push	bp
	mov	bp,sp
	push	di
	push	si
	sub	sp,ax
	jmp	(bx)

cret:
	lea	sp,*-4(bp)
	pop	si
	pop	di
	pop	bp
	ret

|==========================
|	data segment
|==========================
		.data
.extern		_boot_parameters
.extern		_diskbuf
.extern		_sys_font
.define		_errors

begdata:
_BootParamSize: .word	0
_errors:	.word	0
trk_size:	.word	0
cyl_size:	.word	0

|	Global Descriptor Table
gdt:
| #0	Dummy descriptor
		.word 0, 0, 0, 0
| #1	descriptor for GDT itself
		.word 0, 0, 0, 0
| #2	source descriptor
srcsz:		.word 1024		| segment length (limit)
src_low:	.word 0			| bits 15-0 of physical address
src_hi:		.byte 0			| bits 23-16 of physical address
		.byte 0x93		| access rights byte
		.word 0			| reserved
| #3	target descriptor
tgtsz:		.word 1024		| segment length (limit)
tgt_low:	.word 0			| bits 15-0 of physical address
tgt_hi:		.byte 0			| bits 23-16 of physical address
		.byte 0x93		| access rights byte
		.word 0			| reserved
| #4	BIOS CS descriptor
		.word 0, 0, 0, 0
| #5	stack segment descriptor
		.word 0, 0, 0, 0

|==========================
|	bss segment
|==========================
		.bss
.extern		_edata
.extern		_end

begbss:
kerstack:	.zerow STACKSIZE/2	| kernel stack
