
ROOTDEV		=	# This must be your Minix root file system
OPTION		=	# ex. -DOADG_KEY

#if CROSS386
IMAGE		=/tmp/minix.sys
#else
IMAGE		=/system/minix.sys
#endif

#if ACK
CFLAGS		=-D_POSIX_SOURCE -D_MINIX
LD		=asld
LDFLAGS		=
LIBS		=/usr/lib/libc.a
#define		O	s
START		=/usr/lib/head.O
END		=/usr/lib/end.O
MODE		=
TOOLSCC		=cc
CPP		=/usr/lib/cpp -DASLD -P
#else

#define		O	o
#if SELF386
#undef i386
TOOLSCC		=cc -3
CPP		=/usr/lib/cpp -traditional -DINTEL_32BITS -P
#else
TOOLSCC		=cc -0
CPP		=/usr/lib/cpp -DINTEL_32BITS -P
#endif
CFLAGS		=-D_POSIX_SOURCE -D_MINIX -DINTEL_32BITS
LD		=ld
LDFLAGS		=-i
LIBFLAGS	=-lc
LIBS		=/usr/local/lib/i386/libc.a
START		=/usr/local/lib/i386/head.O
END		=
MODE		=-3
#endif

I = /usr/include/minix
A = $(I)/config.h $(I)/const.h $(I)/type.h $(I)/boot.h $(I)/font.h makefile


all:	Edit_me_please!! and comment out me :-)
  # Thanks a lot.
  # You must edit this file to select your own Minix root partition.
  # Please check or modify first line, then comment out or delete above line
  # to compile.

all:	init build bootblok menu mxinstall mxboot

init:	init.c $(START) $(LIBS) $(END) makefile
	cc -c $(MODE) $(CFLAGS) -o init.O init.c
	$(LD) $(MODE) $(LDFLAGS) -o init  $(START) init.O $(LIBS) $(END)
	@echo init done.

build:	build.c makefile
	$(TOOLSCC) $(CFLAGS) -i -o build build.c
	@echo build done.

mxinstall: mxinstall.c
	$(TOOLSCC) $(CFLAGS) -o mxinstall mxinstall.c
	@echo mxinstall done.

#if ACK
bootblok: bootblok.x
	$(CPP) bootblok.x > bootblok.s
	asld  bootblok.s 
	dd if=a.out of=bootblok bs=16w skip=1 count=16 2>/dev/null
	@rm a.out
	@echo 'done.'

mxboot:	mxboot.x
	$(CPP) mxboot.x > mxboot.s
	asld  mxboot.s
	dd if=a.out of=mxboot bs=16w skip=1 count=32 2>/dev/null
	@rm a.out
	mxinstall $(ROOTDEV) mxboot

menu:	menu.s menu1.s option.s
	asld -o menu menu1.s menu.s option.s /usr/lib/libc.a /usr/lib/end.s
	@echo "done."
menu.s:	menu.c $(A) ../fs/const.h ../fs/type.h
	cc -c $(CFLAGS) $(OPTION) menu.c
menu1.s: menu1.x $(A)
	$(CPP) -DQUIET menu1.x > menu1.s
option.s: option.c $(A) $(OPTION) fsparam.h
	cc -c $(CFLAGS) $(MENU_OPT) option.c

assistIPL: assistIPL.x
	$(CPP) assistIPL.x > assistIPL.s
	asld assistIPL.s
	dd if=a.out of=assistIPL bs=16w skip=1 count=16 2>/dev/null
	@rm a.out
	@echo "assistIPL done."

FDassist: assistIPL.x
	$(CPP) -DFDTEST assistIPL.x > FDassist.s
	asld FDassist.s
	dd if=a.out of=FDassist bs=16w skip=1 count=16 2>/dev/null
	@rm a.out
	@echo "FDassist done."

#else
bootblok: bootblok.x
	$(CPP) bootblok.x > bootblok.s
	as -0 -a -o bootblok.O bootblok.s
	ld -0 -s -o a.out bootblok.O
	dd if=a.out of=bootblok bs=16w skip=1 count=16 2>/dev/null
	@rm a.out

menu:	menu1.O menu.O option.O
	ld -0 -s -o menu menu1.O menu.O option.O -lc
	@echo "menu done."
menu.O:	menu.c $(A) ../fs/const.h ../fs/type.h
	cc -0 -c $(CFLAGS) $(OPTION) menu.c
menu1.O: menu1.x $(A)
	$(CPP) -DQUIET $(OPTION) menu1.x > menu1.s
	as -0 -a -o menu1.O menu1.s
option.O: option.c $(A) fsparam.h
	cc -0 -c $(CFLAGS) $(OPTION) option.c

mxboot: mxboot.x
	$(CPP) mxboot.x > mxboot.s
	as -0 -a -o mxboot.O mxboot.s
	ld -0 -s -o a.out mxboot.O
	dd if=a.out of=mxboot bs=16w skip=1 count=32 2>/dev/null
	mxinstall $(ROOTDEV) mxboot
	@rm a.out

assistIPL: assistIPL.x
	$(CPP) assistIPL.x > assistIPL.s
	as -0 -a -o assistIPL.O assistIPL.s
	ld -0 -s -o a.out assistIPL.O
	dd if=a.out of=assistIPL bs=16w skip=1 count=16 2>/dev/null
	@echo "assistIPL done."

FDassist: assistIPL.x
	$(CPP) -DFDTEST assistIPL.x > FDassist.s
	as -0 -a -o FDassist.O FDassist.s
	ld -0 -s -o a.out FDassist.O
	dd if=a.out of=FDassist bs=16w skip=1 count=16 2>/dev/null
	@echo "FDassist done."
#endif

 # 'make image'  combines the bootblock, kernel, memory manager, file 
 # system, init and menu into a single file, called image. Each of these pieces
 # appears in the image file just as the original does on the disk, except that
 # the header at the front is removed,and each piece is padded out to an
 # integral multiple of 16 bytes.  Build also prints a message telling how big
 # the various pieces (except menu) are.
 #
 # 'make net' does the same thing, only with the networking code from the
 # amoeba directory included
 #
image:	build bootblok ../kernel/kernel ../fs/fs ../mm/mm init menu
	build bootblok ../kernel/kernel ../mm/mm ../fs/fs init menu $(IMAGE)
	@sync

srcs   = makefile.cpp bootblok.x fsparam.h menu1.x menu.c option.c \
	 build.c init.c mxboot.x assistIPL.x mxinstall.c fdisk.c \
	 build.cdif fdisk.cdif bi.c

clean:
	rm -f *.[os] *.bak *~

Z:
	tar cvfz /tmp/tools.Z $(srcs)

lzh:
	lharc a /tmp/tools $(srcs)
