
OPTION		=		# nothing :-)
#if ACK
CFLAGS		=-O $(OPTION)
LDFLAGS		=-i -s
LD		=asld
LIBS		=/usr/lib/libc.a
#define 	O	s
START		=/usr/lib/head.O
END		=/usr/lib/end.O
#else

#define 	O	o
#if SELF386
#undef i386
#endif
CFLAGS		=-3 -DINTEL_32BITS $(OPTION)
LD		=ld
LDFLAGS		=-3 -i
LIBS		=/usr/local/lib/i386/libc.a
START		=/usr/local/lib/i386/head.O
END		=
#endif

a		=fs.h $h/config.h $h/const.h $h/type.h \
		 $s/types.h $i/limits.h $i/errno.h \
		 const.h type.h proto.h glo.h makefile
h		=/usr/include/minix
i		=/usr/include
s		=/usr/include/sys


obj =	main.O open.O read.O write.O pipe.O device.O \
	path.O mount.O link.O super.O inode.O cache.O filedes.O \
	stadir.O protect.O time.O misc.O utility.O table.O \
	putc.O

#if ACK
fs: $(START) $(obj) $(LIBS) $(END)
	$(LD) $(LDFLAGS) -o fs \
	$(START) \
	$(obj) \
	$(LIBS) $(END) >symbol.out
	ast -X fs
	@rm symbol.out
	
#else
fs: $(START) $(obj) $(LIBS)
	$(LD) $(LDFLAGS) -o fs \
	$(START) \
	$(obj) \
	$(LIBS)

#endif

tar:
	tar cvfz /tmp/fs.Z makefile.cpp *.[hc]

lzh:
	lharc a /tmp/fs makefile.cpp *.[hc]

clean:
	rm -f $(obj) *.bak *~ fs symbol.out

cache.O:	$a
cache.O:	$h/com.h
cache.O:	$h/boot.h
cache.O:	buf.h
cache.O:	file.h
cache.O:	fproc.h
cache.O:	inode.h
cache.O:	super.h

device.O:	$a
device.O:	$h/com.h
device.O:	dev.h
device.O:	file.h
device.O:	fproc.h
device.O:	inode.h
device.O:	param.h

filedes.O:	$a
filedes.O:	file.h
filedes.O:	fproc.h
filedes.O:	inode.h

inode.O:	$a
inode.O:	$s/stat.h
inode.O:	$h/boot.h
inode.O:	buf.h
inode.O:	file.h
inode.O:	fproc.h
inode.O:	inode.h
inode.O:	super.h

link.O:		$a
link.O:		$s/stat.h
link.O:		buf.h
link.O:		file.h
link.O:		fproc.h
link.O:		inode.h
link.O:		param.h

main.O:		$a
main.O:		$h/callnr.h
main.O:		$h/com.h
main.O:		$h/boot.h
main.O:		buf.h
main.O:		file.h
main.O:		fproc.h
main.O:		inode.h
main.O:		param.h
main.O:		super.h

misc.O:		$a
misc.O:		$i/fcntl.h
misc.O:		$h/callnr.h
misc.O:		$h/com.h
misc.O:		$h/boot.h
misc.O:		buf.h
misc.O:		file.h
misc.O:		fproc.h
misc.O:		inode.h
misc.O:		param.h
misc.O:		super.h

mount.O:	$a
mount.O:	$s/stat.h
mount.O:	buf.h
mount.O:	file.h
mount.O:	fproc.h
mount.O:	inode.h
mount.O:	param.h
mount.O:	super.h

open.O:		$a
open.O:		$i/fcntl.h
open.O:		$h/callnr.h
open.O:		buf.h
open.O:		file.h
open.O:		fproc.h
open.O:		inode.h
open.O:		param.h

path.O:		$a
path.O:		buf.h
path.O:		file.h
path.O:		fproc.h
path.O:		inode.h
path.O:		super.h

pipe.O:		$a
pipe.O:		$i/fcntl.h
pipe.O:		$i/signal.h
pipe.O:		$h/callnr.h
pipe.O:		$h/com.h
pipe.O:		dev.h
pipe.O:		file.h
pipe.O:		fproc.h
pipe.O:		inode.h
pipe.O:		param.h

protect.O:	$a
protect.O:	buf.h
protect.O:	file.h
protect.O:	fproc.h
protect.O:	inode.h
protect.O:	param.h
protect.O:	super.h

putc.O:		$a
putc.O:		$h/com.h

read.O:		$a
read.O:		$i/fcntl.h
read.O:		$h/com.h
read.O:		buf.h
read.O:		file.h
read.O:		fproc.h
read.O:		inode.h
read.O:		param.h
read.O:		super.h

stadir.O:	$a
stadir.O:	$s/stat.h
stadir.O:	file.h
stadir.O:	fproc.h
stadir.O:	inode.h
stadir.O:	param.h

super.O:	$a
super.O:	$h/boot.h
super.O:	buf.h
super.O:	inode.h
super.O:	super.h

table.O:	$a
table.O:	$s/stat.h
table.O:	$h/callnr.h
table.O:	$h/com.h
table.O:	buf.h
table.O:	dev.h
table.O:	file.h
table.O:	fproc.h
table.O:	inode.h
table.O:	super.h

time.O:		$a
time.O:		$h/callnr.h
time.O:		$h/com.h
time.O:		file.h
time.O:		fproc.h
time.O:		inode.h
time.O:		param.h

utility.O:	$a
utility.O:	$h/com.h
utility.O:	$h/boot.h
utility.O:	buf.h
utility.O:	file.h
utility.O:	fproc.h
utility.O:	inode.h
utility.O:	param.h
utility.O:	super.h

write.O:	$a
write.O:	buf.h
write.O:	file.h
write.O:	fproc.h
write.O:	inode.h
write.O:	super.h
