/* pcio.c */

#include "const.h"
#include "type.h"
#include "keyboard.h"
#include "chars.h"

PUBLIC void kbdclose()
{
  /* turn off BIOS CTRL-ALT-LEFT_SHIFT since we stole the key release codes */
  pokeb( BIOS_DATA_SEG, KB_FLAG, peekb( BIOS_DATA_SEG, KB_FLAG ) &
                                 ~(LEFT_SHIFT | LEFT_CTRL | LEFT_ALT) );
}

/*
  Input char from keyboard, return EOF if none.
  Interrupts must be off when this is called.
  The complexity and machine-dependency of kbdin compared with ttyin
  is most annoying.
*/

PUBLIC char_pt kbdin()
{
  char_pt ch;
  static struct echar_s ech;
  u8_pt old_i_mask;

  /* Clear any unacknowledged interrupt. Unfortunate effect on int handlers? */
  oportb( I_COMMAND_PORT, I_EOI );

  /* put interrupt controller in polling mode */
  old_i_mask = inportb( I_MASK_PORT );
  oportb( I_COMMAND_PORT, I_OCW3 | I_POLL );

  /* allow keyboard poll (only) */
  oportb( I_MASK_PORT, ~I_KBD );

  /* prepare for no data */
  ch = EOF;

  /* do the poll (this simultaneously disables further polling */
  if ( inportb( I_COMMAND_PORT ) & I_DATA_READY )
  {
    /* got a key, process it as for the interrupt routines */
    parsecode( scan_keyboard(), &ech );

    /*
      Reenable interrupt controller (what a pain).
      This is not done by keyboard() which relies on a centralized reenable.
    */
    oportb( I_COMMAND_PORT, I_EOI );

    /* do some conversions to make it look like a PC BIOS key */
    if ( ech.area != RKEY )
    {
      if ( (ch = ech.ch) == ASCII_DEL && ech.shift & (LEFT_CTRL | RIGHT_CTRL)
           && ech.shift & (LEFT_ALT | RIGHT_ALT) )
        reboot();
      if ( ech.area == FKEY && ch <= 'J' )
        ch = (ch + (59 - 'A')) << 8;
      else if ( ech.area == CKEY || ech.area == NKEY )
        switch( ch )
        {
        case '2': ch = DOWNARROW; break;
        case '1': ch = END; break;
        case '7': ch = HOME; break;
	case '0': ch = INS; break;
        case '4':
          ch = LEFTARROW;
          if ( ech.shift & (LEFT_CTRL | RIGHT_CTRL) )
            ch = CLEFTARROW;
          break;
        case '6':
          ch = RIGHTARROW;
          if ( ech.shift & (LEFT_CTRL | RIGHT_CTRL) )
            ch = CRIGHTARROW;
          break;
        case '8': ch = UPARROW; break;
        }
    }
  }
  /* restore mask */
  oportb( I_MASK_PORT, old_i_mask );

  return ch;
}

/* ARGSUSED */
PUBLIC void kbdioctl( command )
int command;
{
}

PUBLIC void kbdopen()
{
  /* stop keyboard hanging when keyboard interrupt is traced */
  scan_keyboard();
}

/* ARGSUSED */
PUBLIC void kbdout( c )
int c;
{
}
