/* chars.h */

/* extended character codes for special PC keys */

#define CLEFTARROW 0x7300
#define CPGUP 0x8400
#define CRIGHTARROW 0x7400
#define HOME 0x4700
#define DEL 0x5300
#define DOWNARROW 0x5000
#define CPGDN 0x7600
#define END 0x4f00
#define F1 0x3b00
#define F2 0x3c00
#define F3 0x3d00
#define F4 0x3e00
#define F5 0x3f00
#define F6 0x4000
#define F7 0x4100
#define F8 0x4200
#define F9 0x4300
#define F10 0x4400
#define INS 0x5200
#define LEFTARROW 0x4b00
#define PGDN 0x5100
#define PGUP 0x4900
#define RIGHTARROW 0x4d00
#define UPARROW 0x4800

#define ETOA( c ) (((unsigned) ((c) - FIRST_EXTENDED_CHAR) >> 8) + 0x80)
#define FIRST_EXTENDED_CHAR 0x3b00

/* general editing keys */

#define ASCII_DEL 127
#define BACKSPACE1 8
#define DEL1 7              /* ^G */
#define DEL2 ASCII_DEL
#define DOWN1 24            /* ^X */
#define DOWN2 DOWNARROW
#define END1 18             /* ^R */
#define END2 END
#define ESCAPE 27
#define INS1 22             /* ^V */
#define INS2 INS
#define LEFT1 19            /* ^S */
#define LEFT2 LEFTARROW
#define RIGHT1 4            /* ^D */
#define RIGHT2 RIGHTARROW
#define START1 23           /* ^W */
#define START2 HOME
#define UP1 5               /* ^E */
#define UP2 UPARROW
#define WORDLEFT1 1         /* ^A */
#define WORDLEFT2 CLEFTARROW
#define WORDRIGHT1 6        /* ^F */
#define WORDRIGHT2 CRIGHTARROW
