/*
			Minix Second Stage Boot Loader

In this program, all the elements of the Minix system are loaded into memory
from binary files on a filesystem.  All parts of the system are loaded
like any other Minix process, with Text, Data and Stack areas and command
options on a "command line" (which is actually in a binary format).

*/
#include <minix/const.h>
#include <minix/type.h>
#include <fs/const.h>
#include <fs/type.h>
#include <fs/inode.h>
#include <fs/super.h>
#include <stdio.h>
#include <errno.h>
#include <a.out.h>
#include "type.h"

/*#define FLOPPY	/* define for fd(0) rather than hd(0,2) */
/*#undef printf		/* defined in fs/const.h as 'printk' */
#undef getchar		/* don't want the macros */
#undef putchar
#undef putc
#undef getc

extern int sizes[], kds, ksp;
int error = 0;
int segment = 0x60;
int filenum = 0;

/*#define DEBUG*/

AOUT load(file)
char *file;
{	INODE inode;
	AOUT aout;
	long t, d, b, s;	/* sizes of Text, Data, BSS and Stack segs */

/*	printf("**********************************************************\n");*/
	printf("%s\n",file);
#ifdef DEBUG
	printf("Segment = 0x%x\n", segment);
	fgetc();
#endif
	if((inode = open_file(file)) == NULL) {
		error = 1;
		perror("boot");
	}
	aout = load_file(inode, segment);
#ifdef DEBUG
	dump_exec(aout);
#endif
	if(aout->a_flags & A_SEP) {
		t = aout->a_text;
		d = aout->a_data;
	} else {
		t = 0;
		d = aout->a_data + aout->a_text;
	}
	b = aout->a_bss;
	s = aout->a_total - d - b;

#ifdef DEBUG
	printf("t=%ld d=%ld b=%ld s=%ld\n", t, d, b, s);
#endif
	/* write Text, (Data+BSS+STACK) segment info on top of header
	 * relocation info (that won't be used on 80x86 machines)
	 */
	aout->a_trsize = t;
	aout->a_drsize = d + b;	/* data segment (not including stack) */
	aout->a_tbase = (long) segment;
	aout->a_dbase = (long) (segment + clicks(t));
#ifdef DEBUG
	printf("trsize=0x%x tbase=0x%x drsize=0x%x dbase=0x%x total=0x%x\n",
		(int) aout->a_trsize, (int) aout->a_tbase,
		(int) aout->a_drsize, (int) aout->a_dbase, aout->a_total);
#endif

	zero_mem(segment + clicks(t + d), 0, (int) b);

	segment += clicks(t + d + b + s);
/*	sizes[filenum * 2] = clicks(t);
	sizes[filenum * 2 +1] = clicks(d + b + s);	*/
	filenum++;

	return(aout);
}

main()
{	AOUT aout[10];
	char eq = '\0';
	int i, stack[5];

	aout[0] = load("/etc/kernel");
	aout[1] = load("/etc/mm");
	aout[2] = load("/etc/fs");
	aout[3] = load("/etc/init");

#ifdef DEBUG
	printf("System Loaded, Initializing...\n");
	fgetc();
#endif

	stack[0] = aout[0]->a_dbase + aout[0]->a_total;
	mmstack(aout[1],stack+1);
	fsstack(aout[2],stack+2);
	ksp = kstack(aout, stack);

/*	for(i = 0;i < 8;i++)
		printf("sizes[%d] = %d %x\n", i, sizes[i], sizes[i]);*/

/*	printf("Segment = 0x%x\n", segment);*/

	kds = 0x60 + ((aout[0]->a_flags & A_SEP) ? clicks(aout[0]->a_text) : 0);
	printf("Kernel CS=0x%x DS=0x%x SP=0x%x\n", aout[0]->a_text, kds, ksp);

	if(error) {
		printf("\n\n\nError occured durring system load!!\n");
		printf("          REBOOT NOW!\n");
		fgetc();
	} else {
		printf("\n\nStrike '=' to execute system:");
		while((eq=fgetc()) != '=');
		return(eq);
	}
}
