| When the PC is powered on, it reads the first block from the floppy
| disk into address 0x7C00 and jumps to it.  This boot block must contain
| the boot program in this file.  The boot program first copies itself to
| address 192K - 512 (to get itself out of the way).  Then it loads the 
| operating system from the boot diskette into memory, and then jumps to fsck.
| Loading is not trivial because the PC is unable to read a track into
| memory across a 64K boundary, so the positioning of everything is critical.
| The number of sectors to load is contained at address 504 of this block.
| The value is put there by the build program after it has discovered how
| big the operating system is.  When the bootblok program is finished loading,
| it jumps indirectly to the program (fsck) which address is given by the
| last two words in the boot block. 
|
| Summary of the words patched into the boot block by build:
|
| Word at  19: # total sectors on the disk
| Word at  24: # sectors per track
| Word at  26: # heads on drive
| Word at 504: # sectors to load
| Word at 506: # DS value for fsck
| Word at 508: # PC value for fsck
| Word at 510: # CS value for fsck
|
| This version of the boot block must be assembled without separate I & D
| space.  
|    
| After modifications do a ls -l bootblok, the size must be less than 504!
|
| Jan 6 1990: Modified to get the disk parameters from the boot sector of
|             the disk (put on the disk by the format program) to avoid
|	      having to try to figure out what kind of disk is in the 
|	      drive. Corresponding modifications needed in build.c
|	      Peter Van Epp



        LOADSEG = 0x0060         | here the boot block will start loading
        BIOSSEG = 0x07C0         | here the boot block itself is loaded
        BOOTSEG = 0x2FE0         | here it will copy itself (192K-512b)
        DSKBASE = 120            | 120 = 4 * 0x1E = ptr to disk parameters

final    = 504
fsck_ds  = 506
fsck_pc  = 508
fsck_cs  = 510


.globl begtext, begdata, begbss, endtext, enddata, endbss  | asld needs these
.text
begtext:
.data
begdata:
.bss
begbss:
.text

| copy bootblock to bootseg
        mov     ax,#BIOSSEG
        mov     ds,ax
        xor     si,si           | ds:si - original block
        mov     ax,#BOOTSEG
        mov     es,ax
        xor     di,di           | es:di - new block
        mov     cx,#256         | #  words to move
	jmp	move		| branch around the size parameters

| The 9 bytes at offset 0x13 in the boot sector are reserved for values
| filled in by build using the values for the disk parameters that were
| set when the disk was formatted by DOS (or a Minix format program!). 
| Since DOS puts the values at the special locations used here, build does
| the same (even though it makes the code messy) so that build doesn't have
| to figure out if this is a DOS formatted disk, or an old Minix disk, it
| just copies the values for the 9 bytes from the boot sector of the disk
| and patches them into the bootblok image at the same place that DOS puts
| them. At present, the number of heads is assumed to be 2 since single sided
| disks are not supported. The value is here to allow support to be added 
| later easily (if someone needs it!).

size:
	.word 	0		| total disk size (filled in by build)

	.word	0		| pad bytes past unused DOS parameters
	.byte	0

tracksiz:
	.word	0		| sectors/track (filled in by build)
heads:
	.word	0		| number of heads (filled in by build)

|	the boot code starts again here!

move:	rep
	movw			| copy loop
	
| start boot procedure
	jmpi	start, BOOTSEG	| set cs to BOOTSEG

start:
	mov     dx,cs
        mov     ds,dx           | set ds to cs
        xor     ax,ax
        mov     es,ax           | set es to 0
        mov     ss,dx           | set ss to cs i.e., stack in high core
        mov     sp,#1536        | initialize sp to high core

| print greeting
	mov	ax,#2		| reset video
	int	0x10

        mov     ax,#0x0200	| BIOS call in put cursor in ul corner
        xor     bx,bx
        xor     dx,dx
        int     0x10
        mov     bx,#greet
        call    print

| Initialize disk parameters by reading what format said the disk was when
| it was formatted. If the size of the disk is 0 (the initial value above)
| complain about an old version of build being used to make the disk,
| otherwise set up the number of sectors per track value, select a paramter
| set and reset the disk controller via Bios before continuing with the boot.

	cmp	size,#0		| if the total disk size is 0 then complain
	mov	bx,#buildmsg	| set the error message in case of error
	je	error
				
	mov	ax,size		| get the total number of sectors to select
	mov	cx,#fd144m	| set up for a 1.44m 3.5 inch drive
	cmp	ax,#fd144s	| if it is then branch to set the parameters
	je	reset

	mov	cx,#fd12m	| if not, set up for 1.2M 5.25 inch drive
	cmp	ax,#fd12s	| if it is then branch to set the parameters
	je	reset

	mov	cx,#fd720k	| if not, set up for a 720k 3.5 inch drive
	cmp	ax,#fd720s	| if it is then branch to set the parameters
	je	reset

	mov	cx,#fd360k	| if not set up for a 360k 5.25 inch drive
	cmp	ax,#fd360s	| if it is then branch to set the parameters
	mov	bx,#bad_drive	| the the bad drive message in case of error
	jne	error		| if not report that this drive is not supported!

reset:

	xor	ax,ax		| set ES to segment 0 to address 00078 which
	mov	es,ax		| is Int 0x1E where DOS expects the disk
	seg	es		| parameters pointed to above to be. Put
	mov	DSKBASE,cx	| our data segment and the offset of the 
	mov	ax,ds		| disk parameter table determined above into
	seg	es		| the correct locations then reset the disk
	mov	DSKBASE+2,ax	| drive via a call to DOS before proceeding
				
	xor	ax,ax		| to load Minix in.
	int	0x13
	
| Load the operating system from diskette.
load:
	call	setreg		| set up ah, cx, dx
	mov	bx,disksec	| bx = number of next sector to read
	add	bx,#2		| diskette sector 1 goes at 1536 ("sector" 3)
	shl	bx,#1		| multiply sector number by 32
	shl	bx,#1		| ditto
	shl	bx,#1		| ditto
	shl	bx,#1		| ditto
	shl	bx,#1		| ditto
	mov	es,bx		| core address is es:bx (with bx = 0)
	xor	bx,bx		| see above
	add	disksec,ax	| ax tells how many sectors to read
	movb	ah,#2		| opcode for read
	int	0x13		| call the BIOS for a read
        mov     bx,#fderr	| set up the error message in case of error
	jb	error		| jump on diskette error
	mov	ax,disksec	| see if we are done loading
	cmp	ax,final	| ditto
	jb	load		| jump if there is more to load

| Loading done.  Finish up.
        mov     dx,#0x03F2      | kill the motor
        mov     ax,#0x000C
        out
        cli
	mov	bx,tracksiz	| fsck expects # sectors/track in bx
        mov     ax,fsck_ds      | set segment registers
        mov     ds,ax           | when sep I&D DS != CS
        mov     es,ax           | otherwise they are the same.
        mov     ss,ax           | words 504 - 510 are patched by build

	seg cs
	jmpi	@fsck_pc	| jmp to fsck

| Given the number of the next disk block to read, disksec, compute the
| cylinder, sector, head, and number of sectors to read as follows:
| ah = # sectors to read;  cl = sector #;  ch = cyl;  dh = head; dl = 0
setreg:	
	mov	si,tracksiz	| 9 (PC) or 15 (AT) sectors per track
	mov 	ax,disksec	| ax = next sector to read
	xor	dx,dx		| dx:ax = 32-bit dividend
	div	si		| divide sector # by track size
	mov	cx,ax		| cx = track #; dx = sector (0-origin)
	mov	bx,dx		| bx = sector number (0-origin)
	mov	ax,disksec	| ax = next sector to read
	add	ax,si		| ax = last sector to read + 1
	dec	ax		| ax = last sector to read
	xor	dx,dx		| dx:ax = 32-bit dividend
	div	tracksiz	| divide last sector by track size
	cmpb	al,cl		| is starting track = ending track
	je	set1		| jump if whole read on 1 cylinder
	sub	si,dx		| compute lower sector count
	dec	si		| si = # sectors to read

| Check to see if this read crosses a 64K boundary (128 sectors).
| Such calls must be avoided.  The BIOS gets them wrong.
set1:	mov	ax,disksec	| ax = next sector to read
	add	ax,#2		| disk sector 1 goes in core sector 3
	mov	dx,ax		| dx = next sector to read
	add	dx,si		| dx = one sector beyond end of read
	dec	dx		| dx = last sector to read
	shl	ax,#1		| ah = which 64K bank does read start at
	shl	dx,#1		| dh = which 64K bank foes read end in
	cmpb	ah,dh		| ah != dh means read crosses 64K boundary
	je	set2		| jump if no boundary crossed
	shrb	dl,#1		| dl = excess beyond 64K boundary
	xorb	dh,dh		| dx = excess beyond 64K boundary
	sub	si,dx		| adjust si
	dec	si		| si = number of sectors to read

set2:	mov	ax,si		| ax = number of sectors to read
	xor	dx,dx		| dh = head, dl = drive
	movb	dh,cl		| dh = track
	andb	dh,#0x01	| dh = head
	movb	ch,cl		| ch = track to read
	shrb	ch,#1		| ch = cylinder
	movb	cl,bl		| cl = sector number (0-origin)
	incb	cl		| cl = sector number (1-origin)
	xorb	dl,dl		| dl = drive number (0)
	ret			| return values in ax, cx, dx


|-------------------------------+
|    error & print routines     |
|-------------------------------+

| 	print the error message pointed to by BX then reboot!	

error:
        push    ax
        call    print           | print msg
	xor	cx,cx
err1:	mul	0		| delay
	loop	err1
	int	0x19


print:                          | print string (bx)
        movb	al,(bx)	        | al contains char to be printed
        testb   al,al           | null char?
        jne     prt1            | no
        ret                     | else return
prt1:   movb    ah,#14          | 14 = print char
        inc     bx              | increment string pointer
        push    bx              | save bx
        movb    bl,#1           | foreground color
	xorb	bh,bh		| page 0
        int     0x10            | call BIOS VIDEO_IO
        pop     bx              | restore bx
        jmp     print           | next character

|	data area

disksec:.word 1



|---------------- Floppy disk parameter tables -------------------------

| 1.44 meg 3.5 inch floppy parameters (PS/2 machines) 

fd144s = 2880	| number of sectors on 1.44m disk
	
fd144m:	.byte	0xA1, 0x02, 0x25, 2, 18, 0x1B, 0xFF, 0x6C, 0xF6, 0x0F, 4

| 1.2 meg 5.25 inch floppy parameters (AT high density)

fd12s  = 2400	| number of sectors on a 1.2m disk

fd12m:	.byte	0xDF, 0x02, 0x25, 2, 15, 0x1B, 0xFF, 0x54, 0xF6, 0x01, 8 
 
| 720k 3.5 inch floppy parameters (PS/2's ?)

fd720s = 1440	| number of sectors on disk

fd720k:	.byte	0xDF, 0x02, 0x25, 2, 9, 0x2A, 0xFF, 0x50, 0xF6, 0x0F, 2 

| 360k 5.25 inch floppy parameters (PC XT etc.)

fd360s = 720	| number of sectors on a 360k disk

fd360k:	.byte	0xDF, 0x02, 0x25, 2,  9, 0x2A, 0xFF, 0x50, 0xF6, 0x01, 3 

|-------------------- End of floppy parameter tables -----------------------

buildmsg:
	.asciz "Disk size 0\r\n" 

bad_drive:
	.asciz "Bad drive type\r\n"

fderr:	.asciz "Read error.\r\n"

greet:	.asciz "\rBooting MINIX 1.5.0.  Copyright 1990 Prentice-Hall, Inc.\r\n"

| Don't forget that words 500 - 510 are filled in by build.  The regular
| code had better not get that far.
.text
endtext:
.data
enddata:
.bss
endbss:
