#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>


/* Man - find, nroff & display online manuals
 *
 * Written by Warren Toomey. Dec, 1989.
 * You may freely copy or give away this source as
 * long as this notice remains intact.
 *
 */

/* Things to do:
	if stdout != tty, don't page (I think?)
*/

#define EPAGE "PAGER="		/* Pager environment variable name */
#define EMAN  "MANPATH="	/* Man path environment variable name */

#define PAGER   "/usr/local/bin/less"	/* Default pager */
#define MANPATH "/usr/man"		/* Default man directory */
#define WHATIS  "whatis"		/* Whatis file */
#define NROFF   "nroff -man"		/* Nroff for manuals */


int fgetarg(stream,cbuf)		/* Get next arg from file into cbuf, */
 FILE *stream;				/* returning the character that      */
 char *cbuf;				/* terminated it. Cbuf returns NULL  */
 {					/* if no arg. EOF is returned if no  */
  int ch;				/* args left in file.                */
  int i;

  i=0; cbuf[i]=NULL;

  while (((ch=fgetc(stream))==' ') || (ch=='\t') || (ch=='\n'))
    if (ch=='\n') return(ch);				/* Bypass leading */
							/* whitespace     */
  if (feof(stream)) return(EOF);
  
  cbuf[i++]=ch;

  while (((ch=fgetc(stream))!=' ') && (ch!='\t') && (ch!='\n'))
    cbuf[i++]=ch;					/* Get the argument */

  cbuf[i]=NULL;
  return(ch);
 }



char *getenval(envp,var)	/* Return the variable value from envp */
 char *envp[],*var;
 {
  int i;
  char *value;

  for (i=0;envp[i]!=NULL;i++)
   if (!strncmp(envp[i],var,strlen(var)))
    { value = envp[i] + strlen(var);
      return(value);
    }
  return(NULL);
 }



int fsize(path,siz)		/* Return the size of a file in bytes */
 char *path;			/* or an error if cannot stat it */
 int *siz;
 {
  struct stat buf;
  int i=0;


  if (i=stat(path,&buf)) return(i);

  *siz= buf.st_size;
  return(0);
 }


cutstring(s1,ary)		/* Cut string of fields into separate */
 char *s1, *ary[];		/* fields. Separator is space, tab or : */
 {
  int i=0;

  ary[0]=s1;			/* Set first field */
  while (*s1)
   {
    if ((*s1==' ') || (*s1=='\t') || (*s1==':'))
     {
      *s1=NULL;
      ary[++i]= s1+1;
     }
   s1++;
  }
 }


char msearch(mp,title)		/* Find the section of the manual where */
 char *mp, *title;		/* the requested title is in */
 {
  char whatis[100], word[100], ch=1;
  int size;
  FILE *zin;

  sprintf(whatis,"%s/%s",mp,WHATIS);		/* find `whatis' */

  if (fsize(whatis,&size)!=0) return('0');	/* Use size to search */
						/* linearly or binarily */
  if ((zin=fopen(whatis,"r"))==NULL) return('0');

  while (ch!=EOF)				/* search for title */
   {
    ch=fgetarg(zin,word);

    if (!strcmp(word,title))
      {
	while ((ch=fgetc(zin)!='('));		/* Find the digit */
	ch=fgetc(zin);
	fclose(zin);
	return(ch);
       }				/* else skip rest of line */
    else while ((ch!=EOF) && (ch!='\n'))
           ch=fgetarg(zin,word);
   }
  return('0');
 }



usage()
 {
  fprintf(stderr,"Usage: man [section] title\n");
  exit(0);
 }



main(argc,argv,envp)
 int argc;
 char *argv[], *envp[];
 {
  int i,size;
  char *pager, *manpath, sect, usersect;
  char *mandir[100];
  char cmd[200];

  if ((argc<2) || (argc>3)) usage();

  usersect='0';
  if (argc==3)
    { usersect=argv[1][0];			/* Get any section */
      if ((usersect<'1') || (usersect>'8'))
	usage();
    }

  pager=getenval(envp,EPAGE);		/* Set up pager path */
  if (pager==NULL) pager= PAGER;

  manpath=getenval(envp,EMAN);		/* Set up manual path */
  if (manpath==NULL) manpath= MANPATH;

  cutstring(manpath,mandir);		/* Split man path */

  for (i=0;mandir[i]!=NULL;i++)		/* For every manual directory */
   {						/* find an entry */
    sect=msearch(mandir[i],argv[argc-1]);	/* If one exists */
    if ((sect!='0') && ((usersect=='0') || (usersect==sect)))
      {
	sprintf(cmd,"%s/cat%c/%s.%c",		/* Check cat entry */
		mandir[i],sect,argv[argc-1],sect);

	if (fsize(cmd,&size))			/* If none, nroff */
          {					/* a new one */
	   fprintf(stderr,"Reformatting page. Please wait...\n");
	   sprintf(cmd,"%s %s/man%c/%s.%c | %s",NROFF, mandir[i],
		sect,argv[argc-1],sect,pager);

	   system(cmd);
	   exit(0);
	  }
        else					/* just page the cat file */
          {
	   sprintf(cmd,"%s %s/cat%c/%s.%c",pager, mandir[i],
		sect,argv[argc-1],sect);

	   system(cmd);
	   exit(0);
	  }
      }
   }
  printf("No manual on %s\n",argv[argc-1]);
  exit(1);
 }
