/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                  var.c                                    **
**    This file contains functions relevant to variables, including array    ** 
**    handling, variable setting and getting, and toggle of hashing width    **
**                       maximum history and universes.                      **
**                                                                           **
******************************************************************************/

#include "header.h"

struct vlist
{
  bool exported;
  char *var;				/* use malloc to alloc actual space */
  char *val;				/* for variables so they can be big!*/
  struct vlist *next;
};

struct vlist *top;

char *vget(vname)
  char *vname;
{
  struct vlist *ptr;
  int lex;

/* The variables are stored in alphabetical order in the linked list enabling
   the function to exit as soon as possible. However if the searched for var-
   iable is lexicographically greater than all the variables in the list then
   we still need the return(UNDEF) line at the bottom of the vget function. */

  for (ptr=top;ptr;ptr=ptr->next)
    if ((lex=strcmp(vname,ptr->var))==0)
      return(ptr->val);
    else if (lex<0)
	   return((char *)UNDEF);
  return((char *)UNDEF);
}

char *vwget(vname,wnum)
  char *vname;
  int wnum;
{
  extern bool getword();
  int i,pos;
  char *word,*vval;

  if((word = (char *)malloc((unsigned)MAXWL)) == (char *)NULL)
  {
      perror("vwget: malloc");
      return(NULL);
  }
  pos=0;
  vval=vget(vname);
  for (i=0;i<=wnum;i++)
    if (getword(vval,&pos,word,TRUE)==TRUE)
      continue;
    else break;
  return(word);	/* caller frees mem alloc'ed for word */
  		/* found only one instance in meta.c  */
}

bool export(vname,opt)
  char *vname,*opt;
{
  struct vlist *ptr;
  int lex;

  if (vname)
  {
    for (ptr=top;ptr;ptr=ptr->next)
      if ((lex=strcmp(vname,ptr->var))==0)
      {
	if (*opt=='-') ptr->exported=FALSE;
	else ptr->exported=TRUE;
	return(TRUE);
      }
      else if (lex<0)
	     return(FALSE);
      return(FALSE);
  }
  else
  {
    write(1,"Exported variables:\n",20);
    for (ptr=top;ptr;ptr=ptr->next)
      if (ptr->exported==TRUE)
      {
	write(1,"  ",2);
	write(1,ptr->var,strlen(ptr->var));
	write(1,"\n",1);
      }
    return(TRUE);
  }
}

void makenvpath()
{
  extern char **environ;
  char env[VARVL],*c;
  int i,len;

  if (vget("PATH")!=(char *)UNDEF)
  {
    strcpy(env,"PATH");
    strcat(env,"=");
    for (len=5,c=vget("PATH");*c;c++,len++)
      if (*c==' ') env[len]=':';
      else
	if (*c=='~')
	{
	  c+=2;			/* get rid of # and ' ' */
	  len--;
	}
	else env[len]= *c;
    env[len]=EOS;
    for (i=0;environ[i];i++)
      if (!strncmp(environ[i],"PATH=",5))
      {
	environ[i]=(char *) realloc (environ[i],(unsigned)(strlen(env)+1));
	if (environ[i]==NULL)
	{
	  perror("realloc");
	  exit(1);
	}
	break;
      }
    if (!environ[i])			/* if we didn't find an existing one */
    {
      environ[i]=(char *) malloc ((unsigned)(strlen(env)+1));
      if (environ[i]==NULL)
      {
	perror("malloc1");
	exit(1);
      }
      environ[i+1]=0;
    }
    strcpy(environ[i],env);
  }
  else
  {
    write(2,"No such variable : PATH\n",24);
    write(2,"Help - not a user accessible function, can't have this error!\n",62);
    exit(1);
  }
}

void makenventry(vname)
  char *vname;
{
  extern char **environ;
  char env[VARVL];
  int i,len;

  if (vget(vname)!=(char *)UNDEF)
  {
    strcpy(env,vname);
    strcat(env,"=");
    len=strlen(env);
    strcat(env,vget(vname));
    for (i=0;environ[i];i++)
    {
      if (!strncmp(environ[i],env,len))
      {
	environ[i]=(char *) realloc (environ[i],(unsigned)(strlen(env)+1));
	if (environ[i]==NULL)
	{
	  fprintf(stderr,"vname %s env %s i %d\n",vname,env,i);
	  perror("realloc in makenventry");
	  environ[i]="NULL";		/* to keep everyone happy later on */
	  return;
	}
	break;
      }
    }
    if (!environ[i])			/* if we didn't find an existing one */
    {
      environ[i]=(char *) malloc ((unsigned)(strlen(env)+1));
      if (environ[i]==NULL)
      {
	perror("malloc2");
	environ[i]="NULL";
	return;
      }
      environ[i+1]=0;
    }
    strcpy(environ[i],env);
  }
  else
  {
    fprintf(stderr,"No such variable : %s\n",vname);
    write(2,"Help - not a user accessible function, can't have this error!\n",62);
    exit(1);
  }
}

	/* take each exported var and create environment from it */
void makenv()
{
  struct vlist *ptr;

/* need to have separate function for making path when builtins included. Also
   put in the colons for the environment variable and take out builtin bit. */

  for (ptr=top;ptr;ptr=ptr->next)
  {
    if (!strcmp(ptr->var,"PATH"))
    {
      if (ptr->exported==TRUE) makenvpath();
    }
    else
      if (ptr->exported==TRUE) makenventry(ptr->var);
  }
}

void vset(vname,vval)
  char *vname,*vval;
{
  extern void terminal(),setmask();
#ifdef HASH
  extern bool hashed;
  extern void hashpath();
#endif
  extern char beep[];
  extern int disable_auto,maxhist,wid,hits,misses,beeplength,nohistdup;
  struct vlist *ptr,*old,*new;
  int i,lex=(-1);

#ifdef DEBUG
fprintf(stderr,"vset\n");
#endif
/* search from top of list until we get to a point that is equal to or greater
   than the searched for variable name. i is 0 if vname less than all of them.
   lex is set to -1 initially in case the loop is never executed  */

  for (i=0,old=ptr=top;ptr;i++,old=ptr,ptr=ptr->next)
    if ((lex=strcmp(vname,ptr->var))==0)
      break;
    else if (lex<0)
	   break;

#ifdef DEBUG
fprintf(stderr,"lex %d i %d\n",lex,i);
#endif
  if (lex<0)		/* value doesn't exist, make new variable and insert */
    if (i)		/* normal insertion between old and ptr */
    {
      new=(struct vlist *) malloc ((unsigned)(sizeof(struct vlist)));
      if (new==NULL)
      {
	perror("vset: malloc1");
	return;
      }
      old->next=new;
      new->next=ptr;
      new->var=(char *) malloc ((unsigned)(strlen(vname)+1));
      if (new->var==NULL)
      {
	perror("vset: malloc2");
	return;
      }
      strcpy(new->var,vname);
      new->val=(char *) malloc ((unsigned)(strlen(vval)+1));
      if (new->val==NULL)
      {
	perror("vset: malloc3");
	return;
      }
      strcpy(new->val,vval);
      new->exported=FALSE;
    }
    else		/* insertion before top, old=ptr=top still. */
    {
      old=(struct vlist *) malloc ((unsigned)(sizeof(struct vlist)));
      if (old==NULL)
      {
	perror("vset: malloc4");
	return;
      }
      old->next=top;
      old->var=(char *) malloc ((unsigned)(strlen(vname)+1));
      if (old->var==NULL)
      {
	perror("vset: malloc5");
	return;
      }
      strcpy(old->var,vname);
      old->val=(char *) malloc ((unsigned)(strlen(vval)+1));
      if (old->val==NULL)
      {
	perror("vset: malloc6");
	return;
      }
      strcpy(old->val,vval);
      old->exported=FALSE;
      top=old;		/* and finally assign new top */
    }
  else
    if (lex==0)		/* variable already exists, just change value */
    {
#ifdef DEBUG
fprintf(stderr,"old val %s new val %s.\n",ptr->val,vval);
#endif
      ptr->val=(char *) realloc (ptr->val,(unsigned)(strlen(vval)+1));
      if (ptr->val==NULL)
      {
	perror("vset: malloc7");
	return;
      }
      strcpy(ptr->val,vval);
    }
    else		/* value doesn't exist, make new variable and append */
    {
      new=(struct vlist *) malloc ((unsigned)(sizeof(struct vlist)));
      if (new==NULL)
      {
	perror("vset: malloc8");
	return;
      }
      new->next=0;
      old->next=new;
      new->var=(char *) malloc ((unsigned)(strlen(vname)+1));
      if (new->var==NULL)
      {
	perror("vset: malloc9");
	return;
      }
      strcpy(new->var,vname);
      new->val=(char *) malloc ((unsigned)(strlen(vval)+1));
      if (new->val==NULL)
      {
	perror("vset: malloc10");
	return;
      }
      strcpy(new->val,vval);
    }

/* if we're setting the PATH variable then automatically rehash. The environment
   change will be done when a command is executed */
#ifdef HASH
  if (!strcmp("PATH",vname) && !disable_auto)
  {
    if (hashed==TRUE) hashpath();
    return;
  }
#endif
/* if we're setting the UNIV variable then we need to change universes (pyramid
   only, though) */
#ifdef UNIVERSE
  if (!strcmp("UNIV",vname))
  {
    if (!strcmp(vval,"att")) setuniverse(1);
    else if (!strcmp(vval,"ucb")) setuniverse(2);
	 else write(2,"No such universe\n",17);
    return;
  }
#endif
/* if we're setting the HASH variable then turn hashing on */
#ifdef HASH
  if (!strcmp("HASH",vname) && !disable_auto)
  {
    hashed=TRUE;
    hits=misses=0;		/* reset hashstats */
    hashpath();
    return;
  }
#endif
/* if setting the wid variable then change screen width variable for cle */
  if (!strcmp("wid",vname))
  {
    wid=atoi(vval)-1;
    return;
  }
/* if we're setting the history variable, set number of commands remembered */
  if (!strcmp("history",vname))
  {
    maxhist=atoi(vval);
    return;
  }
/* if we're setting the beep variable, set the beep string */
  if (!strcmp("beep",vname))
  {
    strncpy(beep,vval,20);
    beeplength=strlen(beep);
    return;
  }
  if (!strcmp("TERM",vname) && !disable_auto)
  {
    makenventry("TERM");
    terminal();
    return;
  }
  if (!strcmp("TERMCAP",vname) && !disable_auto)
  {
    makenventry("TERMCAP");
    terminal();
    return;
  }
  if (!strcmp("umask",vname))
  {
    setmask(vval);
    return;
  }
  if (!strcmp("nohistdup",vname))
  {
    nohistdup=1;
    return;
  }
}

void vadd(vname,vval)
  char *vname,*vval;
{
  char *newval;
  int l;

#ifdef DEBUG
fprintf(stderr,"vadd\n");
#endif
/* Unfortunately we have to vget the variable 3 times to change it. */
  if (vget(vname)!=(char *)UNDEF)
  {
    l=strlen(vget(vname));
    newval=(char *) malloc ((unsigned)(l+strlen(vval)+1));
    if (newval==NULL)
    {
      perror("vadd: malloc");
      return;
    }
    sprintf(newval,"%s%s",vget(vname),vval);
    vset(vname,newval);
    free(newval);
  }
  else fprintf(stderr,"No such variable : %s\n",vname);
}

void vdel(vname)
  char *vname;
{
  struct vlist *ptr,*old;
  int i,lex;

  for (i=0,old=ptr=top;ptr;i++,old=ptr,ptr=ptr->next)
    if ((lex=strcmp(vname,ptr->var))==0)
      if (i)			/* deleting some one in the middle to end */
      {
	free(ptr->var);
	free(ptr->val);
	old->next=ptr->next;
	free(ptr);
	return;
      }
      else
      {
	top=top->next;
	free(ptr->var);
	free(ptr->val);
	free(ptr);
	return;
      }
    else if (lex<0)
	   break;
  fprintf(stderr,"No such variable : %s\n",vname);
}

void venvdel(vname)
  char *vname;
{
  extern char **environ;
  int i,len;

  len=strlen(vname);
  for (i=0;environ[i];i++)
    if (!strncmp(vname,environ[i],len) && environ[i][len]=='=')
    {
      free(environ[i]);
      for (;environ[i+1];i++) environ[i]=environ[i+1];
      environ[i]=EOS;			/* end with null */
      return;
    }
  fprintf(stderr,"No such environment variable: %s\n",vname);
}

void vprint()
{
  extern void mprint();
  struct vlist *ptr;

  for (ptr=top;ptr;ptr=ptr->next)
  {
    write(1,ptr->var,strlen(ptr->var));
    write(1,"=",1);
    mprint(ptr->val,0);
  }
}

void venvprint()
{
  extern char **environ;
  int i;

  for (i=0;environ[i];i++)
  {
    write(1,environ[i],strlen(environ[i]));
    write(1,"\n",1);
  }
}

void copyenv(newenv,envp)
  char *newenv[],*envp[];
{
  int i;

  for (i=0;envp[i];i++)
  {
    newenv[i]=(char *) malloc ((unsigned)(strlen(envp[i])+1));
    if (newenv[i]==NULL)
    {
      perror("copyenv: malloc");
      return;
    }
    (void) strcpy(newenv[i],envp[i]);
  }
  newenv[i]=0;
}

void loadenv()
{
  extern char **environ;
#ifdef HASH
  extern int tildehashisin();
#endif
  char c,name[VARNL],path[VARVL];
  int i,j,k;

/* need separate interpretation of PATH as it is read in, so that colons are
   changed to spaces for ease of editing (skip,delete words) and builtin path
   entry is inserted in the right place. Read in at position 1 by default.*/

  for (i=0;environ[i];i++)
  {
    for (j=0;environ[i][j]!='=' && j<VARNL;j++)  /* get environ var name */
      name[j]=environ[i][j];
    name[j]=EOS;
    if (!strcmp(name,"PATH"))
    {
      path[0]='~';path[1]='#';path[2]=' ';
      for (k=3,j++;environ[i][j] && k<VARVL;j++,k++)
      {
	c=environ[i][j];
	if (c==':') path[k]=' ';
        else path[k]=c;
      }
      vset("PATH",path);
    }
    else
      vset(name,&environ[i][j+1]);
    if (export(name,"")==FALSE)
    {
      fprintf(stderr,"Looney in loadenv\n");
      exit(1);
    }
  }
	/* Minix's login doesn't set up a default PATH, so we must */	
#ifdef MINIX
  if (path[0]!='~')
  { strcpy(path,"~# /bin /usr/bin");
    vset("PATH",path);
    makenvpath();
  }
#endif
}
