/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                   parse.c                                 **
**      This file contains the functions to do the parsing of the line.      **
**       Last module to execute before execution of program.                 **
**                                                                           **
******************************************************************************/

#include "header.h"
extern char termcapbuf[],bs[],nd[],cl[],cd[],up[],yankbuf[];
extern FILE *zin,*zout,*fopen();
extern int lenprompt,curr_hist,wid;

#ifdef __STDC__
bool getword(char *line, int *pos, char *word, bool allow_slash_or_bracket)
#else
bool getword(line,pos,word,allow_sl_br_dot)
  char *line,*word;
  int *pos;
  bool allow_sl_br_dot;
/* if true then / [ and . are not word delimiters */
#endif
{
  int inword=0,l=1,i=0;

  word[0]=EOS;
  while(l)
    switch(line[*pos])
    {
      case EOS:
	word[i]=EOS;
	l=0;
	break;
      case '[': case '/':case '.':
	if (allow_sl_br_dot==TRUE)
	{
	  inword=1;
	  word[i++]=line[(*pos)++];
	  break;
	}
	else inword=1;		/* we want it to end the word if it's [ or / */
      case ' ':case '\t':case '<':case '>':case '|':case '"':
      case ';':case '=':case '&':case '\'':case '$':case '`':
	if (inword)
	{
  	  word[i]=EOS;
	  l=0;
	}
	else (*pos)++;
	break;
      default:
	inword=1;
	word[i++]=line[(*pos)++];
    }
  if (word[0]==EOS) return(FALSE);
  return(TRUE);
}

#ifdef __STDC__
SYM_T retsym(char *line, char *word, int *pos, bool allow_colon)
#else
SYM_T retsym(line,word,pos,allow_colon)
  char *line,*word;
  int *pos;
  bool allow_colon;
#endif
{
  /*extern char *vget(),*vwget();*/
  char c;
  int charcount=0;
  enum {NEUTRAL,OUTTO,PIP,AMP,QUOTE1,QUOTE2,INWORD,PLUS} state=NEUTRAL;
  bool from_INWORD=FALSE;

  while(1)
  {
    c=line[(*pos)++];
    switch(state)
    {
      case NEUTRAL:
	switch(c)
	{
	  case EOS : return(ENDLN);
 	  case ' ' :
 	  case '\t': break;
	  case '<' : return(RDRIN);
	  case '>' : state=OUTTO;
		     break;
	  case '+' : state=PLUS;
		     break;
	  case '|' : state=PIP;
		     break;
	  case ';' : return(SEMI);
	  case '&' : state=AMP;
		     break;
	  case '=' : return(EQ);
	  case '"' : state=QUOTE1;
		     break;
	  case '\'': state=QUOTE2;
		     break;
	  case '\\': c=line[(*pos)++];
		     word[charcount++]=c;
		     state=INWORD;
		     break;
	  default  : state=INWORD;
		     word[charcount++]=c;
		     break;
	}
	break;
      case OUTTO:
	if (c=='>') return(APPND);
	if (c=='&') return(RDRERR);
	(*pos)--;				/* same as ungetc */
	return(RDROUT);			/* if not at eoln */
      case PLUS:
	if (c=='=')
	  if (from_INWORD==TRUE)
	  {
	    (*pos)-=2;		/* put back the += for next time */
	    word[charcount]=EOS;
	    return(WORD);
	  }
	  else return(ADD);		/* found a += on it's own */
	(*pos)--;				/* same as ungetc */
	word[charcount++]='+';		/* add the plus to word */
	state=INWORD;
	from_INWORD=FALSE;
	break;
      case QUOTE1:
	switch(c)
	{
	  case EOS : write(2,"Unmatched quote \".\n",19);
		     return(ERRER);
	  case '"' : word[charcount]=EOS;
		     state=INWORD;
		     break;
	  case '\\': c=line[(*pos)++];
		     if (c=='`' || c=='$')
		       word[charcount++]=c;
		     else
		     {
		       word[charcount++]='\\';
		       (*pos)--;	/* no real need, just to catch EOS */
		     }
		     break;
	  default  : word[charcount++]=c;
		     break;
	}
	break;
      case QUOTE2:
	switch(c)
	{
	  case EOS : write(2,"Unmatched quote '.\n",19);
		     return(ERRER);
	  case '\'': word[charcount]=0;
		     state=INWORD;
		     break;
	  case '\\': c=line[(*pos)++];
		     if (c=='!')
		       word[charcount++]=c;
		     else
		     {
		       word[charcount++]='\\';
		       (*pos)--;	/* no real need, just to catch EOS */
		     }
		     break;
	  default  : word[charcount++]=c;
		     break;
	}
	break;
      case INWORD:
	switch(c)
	{
	  case ';': case '&': case '\t': case ' ': case '|':
	  case '>': case '<': case '=' : case EOS:
	    (*pos)--;			/* same as ungetc */
	    word[charcount]=EOS;
	    return(WORD);
	  case '+':
	    state=PLUS;
	    from_INWORD=TRUE;
	    break;
	  case ':':
	    if (allow_colon==TRUE)
	    {
	      word[charcount++]=c;
	      break;
	    }
	    else
	    {
	      word[charcount]=EOS;
	      return(WORD);		/* note _no_ 'ungetc' this time */
	    }
	  case '"': if (allow_colon==TRUE)
		    {
		      state=QUOTE1;
		      break;
		    }
		    else
		    {
		      word[charcount]=EOS;
		      (*pos)--;
		      return(WORD);
		    }
	  case '\'': if (allow_colon==TRUE)
		    {
		      state=QUOTE2;
		      break;
		    }
		    else
		    {
		      word[charcount]=EOS;
		      (*pos)--;
		      return(WORD);
		    }
	  case '\\':c=line[(*pos)++];
		    word[charcount++]=c;
		    break;
	  default : word[charcount++]=c;
		    break;
	}
	break;
      case PIP :
	if (c=='|') return(DBLPIPE);
	(*pos)--;
	return(PIPE);
      case AMP :
	if (c=='&') return(DBLAMP);
	(*pos)--;	/* ungetc */
	return(BCKGND);
      default:
	write(2,"Help! Looney with a stick in retsym!!\n",38);
	exit(1);
    }
  }
}

bool getpipeline(line,pos,pipeline,sts)
  char *line,*pipeline;
  int *pos;
  bool sts;
{
  extern int strip();
  int i,stop,quote;
  char c;

#ifdef DEBUG
fprintf(stderr,"In getpipeline with sts %d pos %d line %s<\n",sts,*pos,line);
#endif
  if (sts==TRUE)	/* due to && or || fail, skip to semicolon */
    while (line[*pos]!=EOS && line[*pos]!=';') (*pos)++;
  i=stop=quote=0;
  while((c=line[*pos])!=EOS && !stop)
  {
    switch(c)
    {
      case '"' :if (quote==1) quote=0;
		else if (!quote) quote=1;
		pipeline[i++]=c;
		(*pos)++;
		break;
      case '\'':if (quote==2) quote=0;
		else if (!quote) quote=2;
		pipeline[i++]=c;
		(*pos)++;
		break;
      case '`': if (quote==3) quote=0;
		else if (!quote) quote=3;
		pipeline[i++]=c;
		(*pos)++;
		break;
      case '\\':pipeline[i++]=c;
		(*pos)++;
		pipeline[i++]=line[*pos];
		(*pos)++;
		break;
/* This is the one and only place I am going to use the goto statement. It is
just far too inelegant to do it any other way */
      case '|': pipeline[i++]=c;
		(*pos)++;
		if (line[(*pos)+1]!=EOS && line[(*pos)+1]=='|')
		  goto epl;
		break;	/* if just | continue since it isn't a pipeline terminator on its own */
      case '&': if (line[(*pos)+1]!=EOS && line[(*pos)+1]=='&')
		{
		  pipeline[i++]=c;
		  (*pos)++;
		}
/* Yes, it's supposed to run on, no break; */
      case ';': epl:
		pipeline[i++]=c;
		(*pos)++;
		if (quote) break;
		stop=1;
		break;
      case '>': pipeline[i++]=c;
		(*pos)++;
		if (line[*pos]=='&')
		{	/* rescues us from >& terminating the pipeline */
		  pipeline[i++]='&';
		  (*pos)++;
		}
		break;
      default:  pipeline[i++]=c;
		(*pos)++;
    }
  }
#ifdef DEBUG
  fprintf(stderr,"i %d pos %d\n",i,*pos);
#endif
  if (i==0) return(FALSE);
  pipeline[i]=EOS;
  (void) strip(pipeline);
  if (pipeline[0]==EOS) return(FALSE);
  return(TRUE);
}

#ifdef __STDC__
SYM_T intercom(char *line, int *pos, int *wpid, int *outpfd, bool pipedin, int fromfile) 
#else
SYM_T intercom(line,pos,wpid,outpfd,pipedin,fromfile)
  char *line;
  int *pos,*wpid,*outpfd;	/* pointers so we can change the value */
  bool pipedin;
  int fromfile;
#endif
{
  char word[MAXWL],				/* max word length */
      ifile[MAXFNL],ofile[MAXFNL],efile[MAXFNL],	/* max filename length */
       *argv[MAXARG];				/* max no of args */
  int argc=0,infd=0,outfd=1,errfd=2,i,pfd[2],pid;
  SYM_T sym,term;
  bool appnd=FALSE,bb,pp;
  void vset(),vadd();

#ifdef DEBUG
fprintf(stderr,"intercom: line %s pos %d\n",line,*pos);
#endif
  pfd[0]=0;pfd[1]=0;
  while(1)
    switch(sym=retsym(line,word,pos,TRUE))
    {
      case RDRIN : if (pipedin==TRUE)
		   {
		     write(2,"Cannot use '<'. Input source is ambiguous\n",41);
		     return(ERRER);
		   }
		   if (argc==0)
		   {
		     write(2,"No command to direct input to.\n",31);
		     return(ERRER);
		   }
		   if (retsym(line,ifile,pos,TRUE)!=WORD)
		   {
		     write(2,"Invalid input file name\n",24);
		     return(ERRER);		/* this may change */
		   }
		   infd=(-2);		/* value of -2 indicates from file */
		   break;
      case RDROUT:
      case APPND : if (argc==0)
		   {
		     write(2,"No command to redirect output from.\n",36);
		     return(ERRER);
		   }
		   if (retsym(line,ofile,pos,TRUE)!=WORD)
		   {
		     write(2,"Invalid output file name.\n",26);
		     return(ERRER);		/* this may change */
		   }
		   outfd=(-2);	/* value of -2 indicates from file */
		   if (sym==APPND) appnd=TRUE;
		   else appnd=FALSE;
		   break;
      case RDRERR: if (argc==0)
		   {
		     write(2,"No command to redirect error from.\n",35);
		     return(ERRER);
		   }
		   if (retsym(line,efile,pos,TRUE)!=WORD)
		   {
#ifdef DEBUG
fprintf(stderr,"efile %s<\n",efile);
#endif
		     write(2,"Invalid error file name.\n",25);
		     return(ERRER);
		   }
		   errfd=(-2);	/* value of -2 indicates from file */
		   break;
      case WORD  : if (argc>=MAXARG)
		   {
		     write(2,"Too many arguments.\n",20);
		     return(ERRER);
		   }
		   if ((argv[argc]=(char *) malloc
			((unsigned)(strlen(word)+1)))==NULL)
		   {
		     write(2,"Cannot allocate any memory for arguments.\n",42);
		     return(ERRER);
		   }
#ifdef DEBUG
fprintf(stderr,"intercom adding word >%s<\n",word);
#endif
		   strcpy(argv[argc++],word);
		   break;
      case ENDLN :
      case PIPE  :
      case SEMI  :
      case DBLPIPE:
      case DBLAMP:
      case BCKGND: if (argc==0) return(ENDLN);	/* catch null lines */
		   argv[argc]=NULL;		/* last arg is nil pointer */
		   if (sym==PIPE)
		   {
		     if (outfd!=1)
		     {
		       write(2,"Cannot use '|'. Output destination ambiguous\n",45);
		       return(ERRER);
		     }
		     term=intercom(line,pos,wpid,&outfd,TRUE,fromfile);
		     if (term==ERRER) return(ERRER);
		   }
		   else term=sym;
		   if (pipedin==TRUE)	/* if input is piped, make the pipe */
		   {
		     if (pipe(pfd)==-1)
		     {
		       write(2,"Cannot make pipe.\n",18);
		       perror("pipe");
		       return(ERRER);
		     }
		     infd=pfd[0];
		     *outpfd=pfd[1];
		   }
		   if (sym==PIPE) pp=TRUE; else pp=FALSE;
		   if (term==BCKGND) bb=TRUE; else bb=FALSE;
		   pid=execute(argc,argv,infd,outfd,errfd,ifile,ofile,efile,appnd,bb,pp,fromfile);
#ifdef DEBUG
fprintf(stderr,"returned from execute\n");
#endif
		   if (sym!=PIPE) *wpid=pid;
		   while(--argc>=0) free(argv[argc]);	/* please release me */
		   return(term);	/* tells main routine what to do next */
      case EQ    : *wpid=0;
		   if (pipedin==TRUE || infd!=0 || outfd!=1 || errfd!=2)	/* must occur on own line */
		   {
		     write(2,"Cannot assign value to |,>,>> or <.\n",36);
		     return(ERRER);
		   }
		   for (i=0;argc>i;i++)	/* take all words before = */
		     if ((term=retsym(line,word,pos,TRUE))!=WORD)
		     {
		       if (term==ENDLN || term==SEMI || term==DBLPIPE || term==DBLAMP)
			/* run out of values, set "" */
		       {
			 for (;argc>i;i++) vset(argv[i],"");
			 return(term);
		       }
		       fprintf(stderr,"Invalid variable value for %s\n",argv[i]);
		       return(ERRER);
		     }
		     else vset(argv[i],word);
	/* now assign all the left over bits to the last one. */
		   while ((term=retsym(line,word,pos,TRUE))==WORD)
		   {
		     vadd(argv[i-1]," ");vadd(argv[i-1],word);
		   }
		   if ((term==SEMI) || (term==ENDLN || term==DBLPIPE || term==DBLAMP)) return(term);
		   fprintf(stderr,"Invalid variable value for %s\n",argv[i-1]);
		   return(ERRER);
      case ADD   : *wpid=0;
		   if (pipedin==TRUE || infd!=0 || outfd!=1 || errfd!=2)	/* must occur on own line */
		   {
		     write(2,"Cannot assign value to |,>,>> or <.\n",36);
		     return(ERRER);
		   }
		   for (i=0;argc!=i;i++)
		   {
		     if (retsym(line,word,pos,TRUE)!=WORD)
		     {
		       fprintf(stderr,"Invalid variable value for %s\n",argv[i]);
		       return(ERRER);
		     }
		     vadd(argv[i],word);
		   }
		   return(ENDLN);
      case ERRER : return(ERRER);
      default: write(2,"Help! Looney with a stick in intercom!!\n",40);
	       exit(1);
    }
}
