/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                 main.c                                    **
**    This file contains Main and a few miscellaneous startup things.        **
**                                                                           **
******************************************************************************/

#include "header.h"

int lengthint(num)
  int num;
{
  int i;

  for (i=0;num;num=num/10,i++);
  return(i);
}

void printime()
{
  long clock, time();
  struct tm *t, *localtime();

  time(&clock);
  t=localtime(&clock);
  printf("%2d:%02d:%02d",t->tm_hour,t->tm_min,t->tm_sec);
  fflush(stdout);
}

void prprompt(prtype)
  int prtype;
{
  extern int lenprompt,curr_hist;
  extern char *vget(),so[],se[];
  char c,prompt[64];		/* any prompt defn longer than this is silly */
  int i,len;

  lenprompt=0;
  switch(prtype)
  {
    case 1: if (vget("prompt")==(char *)UNDEF)
	    {
	      lenprompt=1;
	      write(1,"%",1);
	      return;
	    }
	    strncpy(prompt,vget("prompt"),64);
	    break;
    case 2: if (vget("prompt2")==(char *)UNDEF)
	    {
	      lenprompt=1;
	      write(1,"?",1);
	      return;
	    }
  }
  for (i=0;prompt[i];i++)
    if (prompt[i]=='%')
      switch(prompt[++i])
      {
	case EOS:
	case '%': write(1,"%",1);
		  lenprompt++;
		  break;
	case '!':
	case 'h': lenprompt+=lengthint(curr_hist);
		  printf("%d",curr_hist);
		  fflush(stdout);
		  break;
	case 'd': len=strlen(vget("cwd"));
		  lenprompt+=len;
		  write(1,vget("cwd"),len);
		  break;
	case 'S': printf("%s",so);
		  fflush(stdout);
		  break;
	case 's': printf("%s",se);	/* temp stop standout */
		  fflush(stdout);
		  break;
	case '@':
	case 't': lenprompt+=8;
		  printime();
		  break;
	default : write(1,"%",1);
		  lenprompt+=2;
		  if (prompt[i]<32 || prompt[i]==127)
		  {
		    write(1,"^",1);
		    c=prompt[i]+64;
		    write(1,&c,1);
		    lenprompt++;
		  } else write(1,&prompt[i],1);
      }
    else
    {
      if (prompt[i]<32 || prompt[i]==127)
      {
	write(1,"^",1);
	c=prompt[i]+64;
	write(1,&c,1);
	lenprompt++;
      } else write(1,&prompt[i],1);
      lenprompt++;
    }
}

bool tflagexist(id,tc)
  char *id,*tc;
{
  int i;

  for (i=0;tc[i]!=EOS;i++)
    if ((tc[i]==id[0]) && (tc[i+1]==id[1]))
      return(TRUE);
  return(FALSE);
}

#ifdef DEBUG
void printctrl(name,str)
 char *name, *str;
 {
  int i;

  printf("%s: ",name);
  for (i=0;str[i];i++)
  if (str[i]>31) putchar(str[i]);
  else { putchar('^');
	 if (str[i]>26) putchar(str[i]+64);
	 else putchar(str[i]+96);
       }
  putchar('\n');
 }
#endif

void terminal()
{
  extern void vset();
  extern int wid,beeplength,disable_auto;
  extern char termcapbuf[],bs[],nd[],cl[],cd[],up[],so[],se[],beep[];
  char term[10],bp[1024],*area;

  if (disable_auto) return;
/* set up cursor control sequences from termcap */

  strncpy(term,getenv("TERM"),10);
  tgetent(termcapbuf,term);

			/* The following is a hack to get Clam to */
			/* work under ATT, as we don't know how to */
			/* use the termcap emulation under ATT curses */
			/* If you can fix it, please let us know :-) */
#ifdef ATT
# define yukdollar(x) { int i; for(i=0;x[i];i++) if (x[i]=='$') x[i]=EOS; }
  area=bp;
  strncpy(bs,tgetstr("bc",&area),10);
  strcpy(bs,"\b");	/* Hack to get bs to work with our system */
  if ((wid=tgetnum("co"))==-1) wid=80;
  wid--;
  strncpy(cl,tgetstr("cl",&area),10);
  yukdollar(cl);
  strncpy(cd,tgetstr("cd",&area),10);
  yukdollar(cd);
  strncpy(nd,tgetstr("nd",&area),10);
  yukdollar(nd);
  strncpy(up,tgetstr("up",&area),10);
  yukdollar(up);
  strncpy(so,tgetstr("so",&area),10);
  yukdollar(so);
  strncpy(se,tgetstr("se",&area),10);
  yukdollar(se);
  strncpy(beep,tgetstr("bl",&area),10);
  yukdollar(beep);
  if (!strcmp(beep,"")) strcpy(beep,"");
  vset("beep",beep);
#ifdef DEBUG
  printctrl("bs",bs);
  printctrl("cl",cl);
  printctrl("cd",cd);
  printctrl("nd",nd);
  printctrl("up",up);
  printctrl("so",so);
  printctrl("se",se);
  printctrl("beep",beep);
#endif

#else

  if (tflagexist("bs",termcapbuf))
  {
    bs[0]='\b';
    bs[1]='\0';
  }
  else
  {
    area=bp;
    tgetstr("bc",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(bs,area,10);
  }
  if ((wid=tgetnum("co"))==-1) wid=80;
  wid--;			/* this is to eliminate unwanted auto newlines */
  if (tflagexist("cl",termcapbuf))
  {
    area=bp;
    tgetstr("cl",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(cl,area,10);
  }
  else cl[0]=EOS;
  if (tflagexist("cd",termcapbuf))
  {
    area=bp;
    tgetstr("cd",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(cd,area,10);
  }
  else cd[0]=EOS;
  if (tflagexist("nd",termcapbuf))
  {
    area=bp;
    tgetstr("nd",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(nd,area,10);
  }
  else nd[0]=EOS;
  if (tflagexist("up",termcapbuf))
  {
    area=bp;
    tgetstr("up",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(up,area,10);
  }
  else up[0]=EOS;
  if (tflagexist("so",termcapbuf))	/* assume if there's a 'so' also 'se' */
  {
    area=bp;
    tgetstr("so",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(so,area,10);
    area=bp;
    tgetstr("se",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(se,area,10);
  }
  else
  {
    so[0]=EOS;se[0]=EOS;
  }
  if (tflagexist("bl",termcapbuf))
  {
    area=bp;
    tgetstr("bl",&area);
    area=bp;
    while (isdigit(*area)) area++;
    strncpy(beep,area,20);
  }
  else strcpy(beep,"");
  vset("beep",beep);
#endif
}

void graceful(sig)
  int sig;
{
  void setdown();

  fprintf(stderr,"Received signal no %d\n",sig);
  setdown();
  exit(1);
}

void setup()
{
#ifdef JOB
  extern void checkjobs();
#endif
  int i;

#ifdef MINIX
  void resetsh();
		/* for minix this block is the same as resetsh */
		/* only differences for UCB with TIOCSETP|N	*/
  resetsh();

#else

#ifdef ATT

  struct termio tbuf;

#ifdef DEBUG
fprintf(stderr,"Setting up terminal...\n");
#endif

  if (ioctl(0,TCGETA,&tbuf)) perror("ioctl in setup");
  tbuf.c_lflag = tbuf.c_lflag & (~ICANON) & (~ECHO);
  tbuf.c_cc[4]=1;		/* read 1 char before returning like CBREAK */
  if (ioctl(0,TCSETA,&tbuf)) perror("ioctl s");

#else

  struct sgttyb t, *termod= &t;
  struct tchars s, *setsigc= &s;
# ifdef UCB
  struct ltchars moresigc;
  int pid;
# endif

#ifdef DEBUG
fprintf(stderr,"Setting up terminal...\n");
#endif

/* setup terminal with ioctl calls */

  if (ioctl(0,TIOCGETP,termod))		/* get the sgttyb struct */
    perror("ioctl in setup");
  termod->sg_flags |= CBREAK;		/* cbreak mode to get each char */
  termod->sg_flags &= (~ECHO);		/* do not echo chars to screen */
  if (ioctl(0,TIOCSETP,termod))		/* put it back, modified */
    perror("ioctl1 su");
  if (ioctl(0,TIOCGETC,setsigc))		/* get the tchars struct */
    perror("ioctl2 in setup");
  setsigc->t_intrc=(UNDEF);		/* no interrupt or quitting */
  /*setsigc->t_quitc=(UNDEF); Allow quit while debugging */
  setsigc->t_eofc=(UNDEF);		/* or eof signalling */
  if (ioctl(0,TIOCSETC,setsigc))		/* put it back, modified */
    perror("ioctl2 su");
# ifdef UCB
  moresigc.t_suspc=(UNDEF);		/* no stopping */
  moresigc.t_dsuspc=(UNDEF);		/* or delayed stopping */
  moresigc.t_rprntc=(UNDEF);		/* or reprinting */
  moresigc.t_flushc=(UNDEF);		/* or flushing */
  moresigc.t_werasc=(UNDEF);		/* or word erasing */
  moresigc.t_lnextc=(UNDEF);		/* or literal quoting */
  if (ioctl(0,TIOCSLTC,&moresigc))	/* set ltchars struct to be all undef */
    perror("ioctl3");
  pid=getpid();
  if (ioctl(0,TIOCSPGRP,&pid)) perror("ioctl stpg");
# endif
#endif

#endif

/* now set up signals */

  for (i=1;i<=NUMSIG;i++)
    signal(i,SIG_IGN);
/*  signal(SIGQUIT,SIG_DFL);  allow while debugging */
/*signal(SIGQUIT,SIG_IGN);*/
  signal(SIGHUP,SIG_DFL);
#ifdef UCB
  signal(SIGCONT,SIG_DFL);
#endif
  signal(SIGTERM,SIG_DFL);

/* This catches all the serious errors from within the shell, ILL -> SYS */
/* If any program uses these, then the programmer should be shot. */
  for (i=4;i<=12;i++)
  {
      if (i != SIGKILL) /* SIGKILL cannot be caught or ignored */
	  signal(i,graceful);
  }
#ifdef JOB
  signal(SIGCHLD,checkjobs);
#endif

/* set up termcap/terminfo entries for cursor control */
  terminal();
}

void resetsh()
{
#ifdef ATT

  struct termio tbuf;

  if (ioctl(0,TCGETA,&tbuf)) perror("ioctl in resetsh");
  tbuf.c_lflag = tbuf.c_lflag & (~ICANON) & (~ECHO);
  tbuf.c_cc[4]=1;		/* read 1 char before returning like CBREAK */
  if (ioctl(0,TCSETA,&tbuf)) perror("ioctl rs");

#else

  struct sgttyb t, *termod= &t;
  struct tchars s, *setsigc= &s;
# ifdef UCB
  struct ltchars moresigc;
  int pid;
# endif

#ifdef DEBUG
write(2,"Resetting shell\n",16);
#endif

  if (ioctl(0,TIOCGETP,termod))		/* get the sgttyb struct */
    perror("ioctl in resetsh");
  termod->sg_flags |= CBREAK;		/* cbreak mode to get each char */
  termod->sg_flags &= (~ECHO);		/* do not echo chars to screen */
  if (ioctl(0,TIOCSETN,termod))		/* put it back, modified */
    perror("ioctl1 rs");
  if (ioctl(0,TIOCGETC,setsigc))	/* get the tchars struct */
    perror("ioctl2 in resetsh");
  setsigc->t_intrc=(UNDEF);		/* no interrupt or quitting */
  /*setsigc->t_quitc=(UNDEF); Allow quit while debugging */
  setsigc->t_eofc=(UNDEF);		/* or eof signalling */
  if (ioctl(0,TIOCSETC,setsigc))	/* put it back, modified */
    perror("ioctl2 rs");
# ifdef UCB
  moresigc.t_suspc=(UNDEF);		/* no stopping */
  moresigc.t_dsuspc=(UNDEF);		/* or delayed stopping */
  moresigc.t_rprntc=(UNDEF);		/* or reprinting */
  moresigc.t_flushc=(UNDEF);		/* or flushing */
  moresigc.t_werasc=(UNDEF);		/* or word erasing */
  moresigc.t_lnextc=(UNDEF);		/* or literal quoting */
  if (ioctl(0,TIOCSLTC,&moresigc))	/* set ltchars struct to be all undef */
    perror("ioctl3 in resetsh");
  pid=getpid();
  if (ioctl(0,TIOCSPGRP,&pid)) perror("ioctl stpg");
# endif
#endif

}

void setdown()
{
#ifdef ATT

  struct termio tbuf;

#ifdef DEBUG
fprintf(stderr,"Setdown terminal\n");
#endif

  if (ioctl(0,TCGETA,&tbuf)) perror("ioctl in setdown");
  tbuf.c_lflag = tbuf.c_lflag | ICANON | ECHO;
  tbuf.c_cc[4]=04;		/* set EOT to ^D */
  if (ioctl(0,TCSETA,&tbuf)) perror("ioctl sd");

#else

  struct sgttyb t, *termod= &t;
  struct tchars s, *setsigc= &s;
# ifdef UCB
  struct ltchars moresigc;
# endif

#ifdef DEBUG
fprintf(stderr,"Setdown terminal\n");
#endif

  if (ioctl(0,TIOCGETP,termod))		/* get the sgttyb struct */
    perror("ioctl in setdown");
  termod->sg_flags &= (~CBREAK);	/* reset cooked mode */
  termod->sg_flags |= ECHO;		/* echo chars to screen */
  if (ioctl(0,TIOCSETP,termod))		/* put it back, modified */
    perror("ioctl1 sd");
  if (ioctl(0,TIOCGETC,setsigc))	/* get the tchars struct */
    perror("ioctl2 in setdown");
  setsigc->t_intrc=3;		/* set interrupt and quitting */
  setsigc->t_quitc=28;
  setsigc->t_eofc=4;			/* and eof signalling */
  if (ioctl(0,TIOCSETC,setsigc))	/* put it back, modified */
    perror("ioctl2 sd");
# ifdef UCB
  moresigc.t_suspc=26;			/* stopping */
  moresigc.t_dsuspc=25;		/* delayed stopping */
  moresigc.t_rprntc=18;		/* reprinting */
  moresigc.t_flushc=15;		/* flushing */
  moresigc.t_werasc=23;		/* word erasing */
  moresigc.t_lnextc=22;		/* literal quoting */
  if (ioctl(0,TIOCSLTC,&moresigc))	/* set ltchars struct to be default */
    perror("ioctl3 in setdown");
# endif
#endif
}

void leave_shell()
{
  extern void logout();
  extern bool loginsh;
  extern char *vget(),**arguments;
  extern int numargs;
#ifdef JOB
  extern bool stoppedjobs();
  extern int stopped;
#endif

  if (vget("ignoreeof")!=(char *)UNDEF)
  {
    if (loginsh==TRUE) write(1,"Use 'logout' to logout\n",23);
    else write(1,"Use 'exit' to exit clam\n",24);
    return;
  }
  else
  {			/* either logout or exit according to invokename*/
#ifdef JOB
    if (!stopped && stoppedjobs()==TRUE)
    {
      write(1,"There are stopped jobs.\n",24);
      stopped=2;
      return;
    }
#endif
    if (loginsh==TRUE) logout(numargs,arguments);	/* truncated args */
    else write(1,"exit\n",5);
    setdown();
    exit(0);
  }
}

int process(argc,argv,comfile)
  char *argv[],*comfile;
  int argc;
{
  extern int O_execstring,O_exiterror,O_faststart,O_interact,O_noexec,O_echoline,O_echoexp,O_echobefore,O_echoexpbefore,fromfile;
  int i;

  for (i=1;i<argc;i++)
  {
#ifdef DEBUG
printf("got%d %s\n",i,argv[i]);
#endif
    if (*argv[i]=='-')
    {
      if (!strcmp(argv[i],"-c"))
      {
	O_execstring=1;
	return(i+1);		/* all following args are taken as string */
      }
      if (!strcmp(argv[i],"-e"))
      {
	O_exiterror=1;
	continue;
      }
      if (!strcmp(argv[i],"-f"))
      {
	O_faststart=1;
	continue;
      }
      if (!strcmp(argv[i],"-i"))
      {
	O_interact=1;
	continue;
      }
      if (!strcmp(argv[i],"-p"))
      {
	O_noexec=1;
	continue;
      }
      if (!strcmp(argv[i],"-v"))
      {
	O_echoline=1;
	continue;
      }
      if (!strcmp(argv[i],"-x"))
      {
	O_echoexp=1;
	continue;
      }
      if (!strcmp(argv[i],"-V"))
      {
	O_echobefore=1;
	continue;
      }
      if (!strcmp(argv[i],"-X"))
      {
	O_echoexpbefore=1;
	continue;
      }
      fprintf(stderr,"Unknown option: %s\nusage: clam [ -cefpvxVX ] [ file ]\n",argv[i]);
      exit(1);
    }
    else
    {
      strcpy(comfile,argv[i]);
      fromfile=1;
      return(i);
    }
  }
  return(argc-1);
}

void shinit()
{
  extern void loadenv(),vset(),venvprint(),File();
  extern int O_faststart;

#ifdef HASH
  extern void inihash();
  extern void hashpath();
  extern bool hashed;
#endif
#ifdef ATT
  extern char *getcwd();
#else
# ifdef MINIX
  extern char *getcwd();
# else
  extern char *getwd();
# endif
#endif
  extern int disable_auto,curr_hist,O_echoline,O_echoexp,O_echobefore,O_echoexpbefore;
  extern bool loginsh;
  extern char *current_alias[],*invokename,*vget(),*getlogin();
  struct passwd *pw;
  FILE *fp;
  char *un,dir[MAXPL];
  int oldO_el,oldO_ee,i;
#ifdef UNIVERSE
  int olduniv;
#endif

/* set up default shell values and then read .login/.cshrc for user defined */
  if (*invokename=='-') loginsh=TRUE;
  else loginsh=FALSE;
  for (i=0;i<MAXAL;i++)
    current_alias[i]=NULL;
  disable_auto=1;		/* don't hash until files read */
#ifdef HASH
  hashed=FALSE;
#endif
#ifdef DEBUG
  fprintf(stderr,"env list:\n");
  venvprint();
#endif
  loadenv();		/* loads up environment vars and sets export mode */
#ifdef DEBUG
  fprintf(stderr,"env list:\n");
  venvprint();
#endif
			/* Minix hasn't got hashing, uses too much memory */
#ifdef HASH
  vset("HASH","");
#endif
  vset("SHELL",DFLTSH);
  vset("history","25");
  if ((un=getlogin()) == NULL)
    if ((pw=getpwuid(getuid())) == NULL) un="unknown";
    else un=pw->pw_name;
  vset("user",un);
#ifdef ATT
  (void) getcwd(dir,MAXPL);
#else
# ifdef MINIX
  (void) getcwd(dir,MAXPL-2);
# else
  (void) getwd(dir);
# endif
#endif
  vset("cwd",dir);
#ifdef UNIVERSE
  switch(olduniv=setuniverse(0))
  {
    case 1 : setuniverse(1);
	     vset("UNIV","att");
	     break;
    case 2 : setuniverse(2);
	     vset("UNIV","ucb");
	     break;
    default: setuniverse(olduniv);
	     fprintf(stderr,"Unknown universe index: %d\n",olduniv);
  }
#endif

/* now read user files .clamrc and then .login if it's a login shell */
  if (!O_faststart)
  {
    if (strncpy(dir,getenv("HOME"),MAXPL)==NULL)
    {
      write(2,"No environment variable: HOME\n",30);
      exit(1);
    }
    (void) strcat(dir,"/.clamrc");
    if ((fp=fopen(dir,"r"))!=NULL)
    {
      oldO_el=O_echoline;
      oldO_ee=O_echoexp;
      if (O_echobefore) O_echoline=1;
      else O_echoline=0;
      if (O_echoexpbefore) O_echoexp=1;
      else O_echoexp=0;
      File(fp,1);			/* nosave set for .clamrc */
      fclose(fp);
      if (!O_echobefore) O_echoline=oldO_el;
      if (!O_echoexpbefore) O_echoexp=oldO_ee;
    }
  }
  if (loginsh==TRUE)
  {
    if (strncpy(dir,getenv("HOME"),MAXPL)==NULL)
    {
      write(2,"No environment variable: HOME\n",30);
      exit(1);
    }
    (void) strcat(dir,"/.login");
    if ((fp=fopen(dir,"r"))!=NULL)
    {
      File(fp,1);			/* nosave set for .login */
      fclose(fp);
    }
  }
#ifdef HASH
  if (vget("HASH")!=(char *)UNDEF)
  {
    hashed=TRUE;
    inihash();
    hashpath();
  }
#endif
  disable_auto=0;
  curr_hist=1;
}

void interact()
{
  extern SYM_T intercom();
  extern bool getline(),getpipeline();
  extern void insert(),(*charfn)(),(*ptif)();
  extern int loadline,O_echoexp,O_exiterror,meta_1(),meta_2(),
	     waitfor();
  extern char saveline[];
#ifdef JOB
  extern void checkjobs(),reportjobs();
  extern int stopped,jobdone;
#endif
  SYM_T act;
  char line[MAXLL],pipeline[MAXLL];
  int i,pos,ppos,pid,nosave,retval;
  bool skip_to_semi;

#ifdef JOB
  stopped=jobdone=0;
#endif
  charfn=insert;
  ptif=insert;
  prprompt(1);
  while(1)
  {
    if (!loadline)
      for (i=0;i<MAXLL;i++) line[i]=EOS;
    else
      strncpy(line,saveline,MAXLL);

 /* How can stopped be altered from its initial value be these lines
    if (stopped==2) stopped=1;
    else stopped=0;
			Warren */
    if (getline(line,&nosave,0)==TRUE)
    {
      act=RDRIN;     /* set to a default so we do it once unless meta fails */
/* do metachar expansion now, also savehist will go in here */
      if (meta_1(line,nosave)) act=ERRER;
      if (O_echoexp)
      {
	write(2,line,strlen(line));
	write(2,"\n",1);
      }
      skip_to_semi=FALSE;
      pos=0;				/* reset to start of line */
      while (act!=ENDLN && act!=ERRER)
      {
	retval=0;

	for (i=0;i<MAXLL;i++) pipeline[i]=EOS;
	if (getpipeline(line,&pos,pipeline,skip_to_semi)==FALSE)
          break;	/* thar ain't no more */

#ifdef DEBUG
fprintf(stderr,"got pipeline %s<\n",pipeline);
#endif
/* now do metachar subst on each pipeline */
	if (meta_2(pipeline))
	{
	  /* act=ERRER;	 If only to be consistent, I should do this. */
	  break;
	}

#ifdef DEBUG
fprintf(stderr,"pipeline going to intercom >%s<\n",pipeline);
#endif
	ppos=0;		/* reset to start of pipeline */
	act=intercom(pipeline,&ppos,&pid, &i, FALSE,0);	/* call intercom with fromfile not set */

	skip_to_semi=FALSE;
	for (i=3;i<=NFILES;i++) close(i);
	if (act!=ERRER && pid && act!=BCKGND)
	  retval=waitfor(pid);
#ifdef JOB
	signal(SIGCHLD,checkjobs);
#endif
	resetsh();
	pid=0;
	if (O_exiterror && retval)
	{
	  write(2,"Exit on error.\n",15);
	  setdown();
	  exit(1);
	}
	if (act==DBLPIPE && !retval) skip_to_semi=TRUE;
	if (act==DBLAMP && retval) skip_to_semi=TRUE;
      }
    }
#ifdef JOB
    signal(SIGCHLD,checkjobs);		/* these are strewn about liberally */
    if (jobdone) reportjobs();
#endif
    prprompt(1);
  }
}

void execstring(argc,argv,argp)
  int argc,argp;
  char *argv[];
{
  extern SYM_T intercom();
  extern int fromfile,O_echoexp,O_exiterror,meta_1(),meta_2();
  SYM_T act;
  char line[MAXLL],pipeline[MAXLL];
  int i,pos,ppos,retval,pid;
  bool skip_to_semi;

  line[0]=EOS;
  fromfile=1;	/* a string's as good as a file any day. */
  for (;argp<argc;argp++)
  {
    strcat(line,argv[argp]);
    strcat(line," ");		/* don't worry about the extra space */
  }
#ifdef DEBUG
fprintf(stderr,"The line is\n%s\n",line);
#endif
  act=RDRIN;     /* set to a default so we do it once unless meta fails */
  if (meta_1(line,1)) act=ERRER;
  if (O_echoexp)
  {
    write(2,line,strlen(line));
    write(2,"\n",1);
  }
  skip_to_semi=FALSE;
  pos=0;				/* reset to start of line */
  while (act!=ENDLN && act!=ERRER)
  {
    retval=0;
    for (i=0;i<MAXLL;i++) pipeline[i]=EOS;
    if (getpipeline(line,&pos,pipeline,skip_to_semi)==FALSE)
      break;

    if (meta_2(pipeline))
    {
      /* act=ERRER	pedanticism rules */
      break;
    }

    ppos=0;	/* reset to start of pipeline */
    act=intercom(pipeline,&ppos,&pid, &i,FALSE,1);	/* call intercom with fromfile set */

    skip_to_semi=FALSE;
    for (i=3;i<=NFILES;i++) close(i);
    if (act!=ERRER && pid && act!=BCKGND)
      retval=waitfor(pid);
#ifdef JOB
    signal(SIGCHLD,checkjobs);
#endif
    pid=0;
    if (O_exiterror && retval)
    {
      write(2,"Exit on error.\n",15);
      exit(1);
    }
    if (act==DBLPIPE && !retval) skip_to_semi=TRUE;
    if (act==DBLAMP && retval) skip_to_semi=TRUE;
  }
  exit(0);
}
 
main(argc,argv,envp)
  int argc;
  char *argv[],*envp[];
{
  extern void copyenv(),File();
  extern char *invokename,**arguments,**environ,*newenv[];
  extern FILE *zin,*zout;
  extern int fromfile,numargs, O_execstring,NoIoctl;
  char filename[MAXFNL];
  int argp;

  NoIoctl=0;
  copyenv(newenv,envp);
  environ=newenv;
#ifdef DEBUG
fprintf(stderr,"Finished new environment copy\n");
#endif
  fromfile=0;
  filename[0]=EOS;
  if (!isatty(0)) fromfile=1;	      /* try this way, now. (catch jobs in bckgnd) */
  zout=stdout;			/* shell output to standard output */
  argp=process(argc,argv,filename);	/* argp is pointer to start of shell script args */
#ifdef DEBUG
fprintf(stderr,"main:fromfile %d filename %s\n",fromfile,filename);
#endif
  if (fromfile && *filename)		/* file is not from stdin, open it */
  {
      invokename=filename;
      shinit();			/* set up shell vars, read .clamrc and stuff */
      if ((zin=fopen(filename,"r"))==NULL)
      {
        fprintf(stderr,"Can't open file: %s\n",filename);
        exit(1);
      }
  }
  else
  {
    zin=stdin;
    invokename=argv[0];
    shinit();			/* set up shell vars, read .clamrc and stuff */
  }
  if (O_execstring) execstring(argc,argv,argp);	/* execute string and exit */
  if (fromfile)				/* non-interactive */
  {
    argv[argp]=invokename;	/* make sure $0 is right. */
    arguments= &argv[argp];	/* set new start of argument list */
    numargs=argc-argp;	/* set new arg number after taking out shell options */
#ifdef DEBUG
fprintf(stderr,"argc %d argp %d numargs %d\n",argc,argp,numargs);
#endif
    File(zin,0);		/* nosave isn't set. */
    fclose(zin);
    exit(0);
  }
  else
  {
    setup();			/* setup terminal correctly for shell */
    arguments=argv;
    numargs=argc;
    interact();			/* interactive */
  }
}
