/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                   hist.c                                  **
**    This file includes functions relevant to the history mechanism, but    **
**     not the metacharacter expansion of previous commands. (see meta.c)    **
**                                                                           **
******************************************************************************/

#include "header.h"

struct histlist
{
  int hnum;
  char *hline;
  struct histlist *next;
};

struct histlist *htop=0;

int savehist(line,histnum,max)
  char *line;
  int histnum,max;
{
  struct histlist *ptr,*old;
  extern int nohistdup;

  for (old=ptr=htop;ptr && ptr->hnum!=histnum;old=ptr,ptr=ptr->next);
  if (ptr)				/* change existing history */
  {
    if (nohistdup && !strcmp(old->hline,line))
    {
      if (ptr->hline[0]==EOS)	/* caused by a ^P */
      {
	if (htop!=ptr)
	  old->next=NULL;
	else
	  htop=NULL;
	free(ptr->hline);
	free(ptr);
      }
      return(0);			/* don't save duplicates */
    }
    ptr->hline=(char *) realloc (ptr->hline,(unsigned)(strlen(line)+1));
    strcpy(ptr->hline,line);
  }
  else
    if (htop)				/* there is a history, isn't there? */
    {
#ifdef DEBUG
fprintf(stderr,"nohistdup %d old %s line %s.\n",nohistdup,old->hline,line);
#endif
      if (nohistdup && !strcmp(old->hline,line))
	return(0);			/* don't save duplicates */
      old->next=ptr=(struct histlist *) malloc((unsigned)(sizeof(struct histlist))); 
      ptr->hline=(char *) malloc ((unsigned)(strlen(line)+1));
      strcpy(ptr->hline,line);
      ptr->hnum=histnum;
      ptr->next=0;
      while (histnum-(htop->hnum)>max)
      {
	ptr=htop;
	htop=htop->next;
	free(ptr->hline);free(ptr);
      }
    }
    else				/* no? well, let's make one then. */
    {
      htop=(struct histlist *) malloc ((unsigned)(sizeof(struct histlist)));
      htop->hline=(char *) malloc ((unsigned)(strlen(line)+1));
      strcpy(htop->hline,line);
      htop->hnum=histnum;
      htop->next=0;
    }
  return(1);
}

void loadhist(line,pos,histnum,curs)
  char *line;
  int *pos,histnum,curs[];
{
  extern void goend(),go(),clrline();
  extern int lenprompt;
  struct histlist *ptr;

  *pos=0;					/* pos at home */
  go(curs,lenprompt,0);				/* goto start of line and */
  clrline(line,0,curs);					/* clear it */
  for (ptr=htop;ptr && ptr->hnum!=histnum;ptr=ptr->next);
  if (ptr)
  {
    strcpy(line,ptr->hline);
    goend(line,pos,curs);
  }
  else;				/* we can't find that number so load nothing */
/* maybe it should beep here */
}

void mprint(line,nocr)
  char *line;
  int nocr;
{
  char buf[MAXLL];
  int i,j;

  for (j=0,i=0;line[i];i++,j++)
    if (line[i]<32 || line[i]==127)
    {
      buf[j++]='^';
      buf[j]=line[i]+64;
    }
    else buf[j]=line[i];
  buf[j]=EOS;
/* I'll toss up the idea of changing this to fprintf(zout,"%s",buf) for the
   purposes of builtin output redirection some time later + fflush for good
   luck. For now it can stay like this - but watch out. */
  write(1,buf,strlen(buf));
  if (!nocr) write(1,"\n",1);
}

void history(argv)
  char *argv[];
{
  struct histlist *ptr;
  extern int curr_hist,maxhist;

  for (ptr=htop;ptr && ptr->hnum<curr_hist;ptr=ptr->next)
    if (ptr->hnum>=curr_hist-maxhist)
    {
      printf("%4d  ",ptr->hnum);
      fflush(stdout);
      mprint(ptr->hline,0);	       /* this routine intercepts the ^ chars */
    }
}

bool gethist(event)
  char *event;
{
  extern int curr_hist;
  struct histlist *ptr;
  int histnum,f=0;

  if ((*event>='0') && (*event<='9') || (*event=='-') || (*event=='!'))
  {
    switch(*event)
    {
      case '-': histnum=curr_hist-atoi(event+1);
		break;
      case '!': histnum=curr_hist-1;
		break;
      default : histnum=atoi(event);
    }
    for (ptr=htop;ptr;ptr=ptr->next)
      if (ptr->hnum==histnum)
      {
	strcpy(event,ptr->hline);
	return(TRUE);
      }
    return(FALSE);
  }
  else
  {
    histnum=strlen(event);		/* double use of histnum to store len */

/* if the history matches the requested event then that history line is copied
into the event pointer. Note that the first histnum characters of event will
not change and thus further searches for more recently matching histories will
still be valid. f is set a a found flag. */

    for (ptr=htop;ptr;ptr=ptr->next)
      if (!strncmp(event,ptr->hline,histnum))
      {
	strcpy(event,ptr->hline);
	f=1;
      }
      if (f) return(TRUE);
      return(FALSE);
  }
}

char *getnumhist(histnum)
  int histnum;
{
  struct histlist *ptr;

  for (ptr=htop;ptr;ptr=ptr->next)
    if (ptr->hnum==histnum)
      return(ptr->hline);
  return((char *)UNDEF);
}

int matchhist(histnum)
  int histnum;
{
  extern int curr_hist;
  struct histlist *ptr;
  char *histptr,temp[MAXLL];
  int lastmatch=(-1);

  if ((histptr=getnumhist(histnum))!=(char *)UNDEF)
    strncpy(temp,histptr,MAXLL);
  else return(0);
  for (ptr=htop;ptr && ptr->hnum<histnum;ptr=ptr->next)
    if (!strcmp(temp,ptr->hline))
      lastmatch=ptr->hnum;
/* return the value of the next line after matching one. If none match return 0 */
  return(lastmatch+1);
}

int matchhline(line,startnum)
  char *line;
  int startnum;
{
  extern int curr_hist;
  struct histlist *ptr;
  int lastmatch=0,ll;

  /* finds match backwards for line */
  ll=strlen(line);
  for (ptr=htop;ptr && ptr->hnum<startnum;ptr=ptr->next)
    if (!strncmp(line,ptr->hline,ll))
      lastmatch=ptr->hnum;
  return(lastmatch);
}
