/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/* You may need to change the location of some of the .h files. I can't
   account for everyone... */
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>
#include <pwd.h>

#ifdef ATT
# include <dirent.h>
# include <termio.h>
# include <sys/file.h>
# include <sys/time.h>
#endif

#ifdef MINIX
# include <sgtty.h>
# include <dirent.h>
# include <fcntl.h>
#  ifndef ATARI_ST
#   include <sys/dir.h>
#   include <sys/time.h>
#  else
#   include <time.h>
#  endif
#endif

#ifdef UCB
# include <sgtty.h>
# include <sys/dir.h>
# include <sys/time.h>
# include <sys/file.h>
# include <sys/resource.h>
#  ifdef SUN
#   include <sys/wait.h>
#  else
#   include <wait.h>
#  endif
#endif

/* Here is the Minix section i.e all the things that had to be set up
   to get Minix to go */

#ifdef MINIX
# define TIOCSETN TIOCSETP
# define lstat stat
# define O_echoexpbefore O_ebefore
# define builtin_name b_name
# define builtin_func b_func
# define current_alias c_alias
# define getline getlin
# define alias_depth als_dpt
#endif

/* for some reason the read set the error flag before the eof flag so I
   wrote my own ffinish macro which does both feof and ferror simultaneously */

#ifdef MINIX
# define ffinish(p)	(((p)->_flags&(_EOF|_ERR))!=0)
#else
# define ffinish(p)	(((p)->_flag&(_IOEOF|_IOERR))!=0)
#endif

/***************************************************************************
	Anything that needs to be changed is under this line.
***************************************************************************/

/* name of file with user passwords and directory entries e.g. /etc/passwd */
#define PASSWD "/etc/passwd"

/* name of help program (full path, please) */
#define HELP "/usr/local/utilities/man"

/* name of default interpreter shell. Normally it will be Bourne Shell */
#define DFLTSH "/bin/sh"

/* name of default editor to use for alias creation. */
#define DFLTED "/usr/ucb/vi"

/* Clam needs to know where it is for customised popen */
#define CLAMSH "/ccen/callum/bin/clam"

/* Sizes of some data structures */
#ifdef MINIX
# define MAXARG  512			/* no. of arguments */
# define MAXWL 	 512			/* word length */
# define MAXFNL  128			/* file name length */
# define MAXLL  1024			/* line length */
# define MAXPL   128			/* path length */
# define MAXCAN 1000			/* maximum number of candidates */
# define VARNL    32			/* variable name length */
# define VARVL   256			/* variable value length */
# define USERNL   32			/* max length of user names */
# define MAXAL    16			/* max depth of aliases */
#else
# define MAXARG  512			/* no. of arguments */
# define MAXWL  1024			/* word length */
# define MAXFNL  256			/* file name length */
# define MAXLL  2048			/* line length */
# define MAXPL  2048			/* path length */
# define HSHSIZ 1021			/* size of hash array */
# define MAXCAN 2500			/* maximum number of candidates */
# define VARNL   256			/* variable name length */
# define VARVL  1024			/* variable value length */
# define USERNL   32			/* max length of user names */
# define MAXAL    32			/* max depth of aliases */
#endif

/* number of signals. For ucb usually 27, for att 19. */

#ifdef ATT
# define NUMSIG 19
#endif
#ifdef MINIX
# ifdef ATARI_ST
#  define NUMSIG NSIG		/* defined in <signal.h> */
# else
#  define NUMSIG 19
# endif
#endif
#ifdef UCB
# define NUMSIG 27
#endif

/****************************************************************************
	Don't change anything past this line unless you're hacking.
****************************************************************************/

/* Some general defines */
#define EOS '\0'
#define UNDEF -1
#define NFILES 20
#define ALIASEX   01		/* executable is alias */
#define BUILTEX   02		/* executable is builtin */
#define EXTYPE    03		/* mask for the type of executable */
#define BEFOREDOT  0		/* priority flag bit if before . on path */
#define AFTERDOT  04		/* priority flag bit if after . on path */
#define PRIORITY  04		/* mask for priority of executable (as above) */

/* Identification for error codes for metacharacter expansion function */
#ifdef OK	/* defined somewhere on minixST */
#undef OK
#endif
#define OK 0
#define SH_ERR -1
#define ST_ERR -2
#define BR_ERR -3
#define BQ_ERR -4
#define QM_ERR -5
#define TL_ERR -6
#define CY_ERR -7
#define CT_ERR -8
#define NX_ERR -9
#define DL_ERR -10

typedef enum TS {RDRIN,RDROUT,RDRERR,APPND,PIPE,WORD,ENDLN,SEMI,EQ,ADD,BCKGND,DBLPIPE,DBLAMP,ERRER} SYM_T;

/* some brain damaged people put these in stdio */
#ifdef FALSE
#undef FALSE
#endif

#ifdef TRUE
#undef TRUE
#endif

typedef enum bb {FALSE,TRUE} bool;

/* These structures are used to store the alias definitions. */
struct adefn
{
  char *a_line;
  struct adefn *nextln;
};

struct alias
{
  char *a_name;
  struct adefn *defin;
  struct alias *next;
};

/* ex_ptr is the hasharray structure's union which points to an executable's whereabouts */
union ex_ptr
{
  char *dir;
  void (*builtin_fn)();
  struct adefn *alias_defn;
};
  
/* har is the hasharray structure */
struct har
{
  char *name;
  char flag;
  union ex_ptr exec_ptr;
};

struct job
{
  int jobnumber;
  int pid;
  char *name;
  bool rdrout;
  char *dir;
#ifdef ATT
  int status;
#endif
#ifdef MINIX
  int status;
#endif
#ifdef UCB
  union wait status;
#endif
  long lastmod;
  struct job *next;
};

#ifdef __STDC__
#ifndef __NO_PROTO__

/* alias.c */
struct adefn *checkalias (char *aname);
void aliaslist (char *aname);
void savealias (char *aname, FILE *fp);
void addalias (char *aname, struct adefn *stdefn);
void makelinealias (char *aname, char *aline);
void makealias (char *aname, FILE *fp);
void delalias (char *aname);

/* builtin1.c */
void alias (int argc, char **argv, int infd, int outfd, int errfd,
	    char *ifil, char *ofil, char *efil, bool appnd, bool bckgnd);
void logout (int argc, char **argv, int infd, int outfd, int errfd,
	     char *ifil, char *ofil, char *efil, bool appnd, bool bckgnd);
void Kill (int argc, char *argv[], int infd, int outfd, int errfd,
	   char *ifil, char *ofil, char *efil, bool appnd, bool
	   bckgnd, bool piped);
void limit (int argc, char *argv[], int infd, int outfd, int errfd,
	    char *ifil, char *ofil, char *efil, bool appnd, bool
	    bckgnd, bool piped);
void unlimit (int argc, char *argv[], int infd, int outfd, int errfd,
	      char *ifil, char *ofil, char *efil, bool appnd, bool
	      bckgnd, bool piped);
void (*checkbuiltins())(char *);

/* builtin2.c */
void printlimit (char *limname);
void setlimit (char *limname, char *limval);
int getnextword (char *line, int *pos, char *word);
int convert (char *string);
void editalias (char *aname);

/* clex.c */
bool firstword (char *line, int pos);
void complete (char *line, int *pos, int curs[]);
void nameopt (char *line, int pos, int curs[]);

/* comlined.c */
void mputc (int c, FILE *f, int curs[]);
int oputc (int c);
void go (int curs[], int  hor, int vert);
void backward (int curs[]);
void forward (int curs[]);
void clrscrn (void);
void insert (char *line, int pos, int letter, int curs[]);
void overwr (char *line, int pos, int letter, int curs[]);
void show (char *line, int curs[], bool clearing);
void goend (char *line, int *pos, int curs[]);
void copyback (char *line, int pos, int curs[], int count);
void delnextword (char *line, int pos, int curs[]);
void delprevword (char *line, int *pos, int curs[]);
void backword (char *line, int *pos, int curs[]);
void forword (char *line, int *pos, int curs[]);
void yanknext (char *line, int pos, char *yankbuf);
void yankprev (char *line, int pos, char *yankbuf);
void clrline (char *line, int pos, int curs[]);
void transpose (char *line, int pos, int curs[]);
int strip (char *line);
void tardis (char *line, int *pos, int curs[]);
bool getline (char *line, int *nosave, int feature_off);

/* cx.c */
bool expand_tilde (char *user_path, int *builtin);
void help (char *line, int pos, int curs[]);

/* exec.c */
void setbgexec (void);
void resetsigdefaults (void);
bool findslash (char *string);
void runalias (struct adefn *start, int argc, char *argv[], int infd,
		int outfd, int errfd, char *ifil, char *ofil, char *efil,
		bool appnd, bool bckgnd, bool piped);
int getpath (char *fullpathname, char *name, int flag);
void panic (char *mess);
int atoo (char *str);
void setmask (char *str);
void redirect (int infd, int outfd, int errfd, char *ifil, char *ofil,
		char *efil, bool appnd, bool bckgnd);
int execute (int argc, char *argv[], int infd, int outfd, int errfd,
	     char *ifil, char *ofil, char *efil, bool appnd,
	     bool bckgnd, bool piped, int fromfile);

/* file.c */
bool getfileline (char *line, FILE *fp, int nostrip);
void File (FILE *finp, int nosave);


/* hash.c */
bool executable (char *dir, char *entname, int nojoin);
#ifdef HASH
int hash (char *name);
int hashaliases (void);
int hashbuiltins (void);
int tildehashisin (char *path);
void inihash (void);
void hashpath (void);
#endif

/* hist.c */
int savehist (char *line, int histnum, int max);
void loadhist (char *line, int *pos, int histnum, int curs[]);
void mprint (char *line, int nocr);
void history (char *argv[]);
bool gethist (char *event);
char *getnumhist (int histnum);
int matchhist (int histnum);
int matchhline (char *line, int startnum);

/* job.c */
#ifdef JOB
void joblist (void);
bool stoppedjobs (void);
struct job *findjob (int pid);
int pidfromjob (int jobno);
void addreport (struct job *newone);
int addjob (int pid, char *name, int outfd, bool bckgnd);
void newcurr (void);
void rmjob (int pid);
int update (int pid, union wait status);
void checkjobs (void);
int waitfor (int pid);
void reportjobs (void);
#endif

/* main.c */
int lengthint (int num);
void printime (void);
void prprompt (int prtype);
bool tflagexist (char *id, char *tc);
void printctrl (char *name, char *str);
void terminal (void);
void graceful (int sig);
void setup (void);
void resetsh (void);
void setdown (void);
void leave_shell (void);
int process (int argc, char *argv[], char *comfile);
void shinit (void);
void interact (void);
void execstring (int argc, char *argv[], int argp);
int main (int argc, char *argv[], char *envp[]);

/* meta.c */
void getdir (FILE *fp, char *line);
int isanum (char *string);
int meta_1 (char *line, int nosave);
int meta_2 (char *line);

/* parse.c */
bool getword (char *line, int *pos, char *word, bool allow_slash_or_bracket);
SYM_T retsym (char *line, char *word, int *pos, bool allow_colon);
bool getpipeline (char *line, int *pos, char *pipeline, bool sts);
SYM_T intercom (char *line, int *pos, int *wpid, int *outpfd,
		bool pipedin, int fromfile);

/* var.c */
char *vget (char *vname);
char *vwget (char *vname, int wnum);
bool export (char *vname, char *opt);
void makenvpath (void);
void makenventry (char *vname);
void makenv (void);
void vset (char *vname, char *vval);
void vadd (char *vname, char *vval);
void vdel (char *vname);
void venvdel (char *vname);
void vprint (void);
void venvprint (void);
void copyenv (char *newenv[], char *envp[]);
void loadenv (void);

#endif /* __NO_PROTO__ */
#endif /* __STDC__ */
