/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                 file.c                                    **
**       This file contains the file handling functions and line loader.     **
**                                                                           **
******************************************************************************/

#include "header.h"

bool getfileline(line,fp,nostrip)
  char *line;
  FILE *fp;
  int nostrip;
{
  extern int O_echoline,errno,strip();
  int c,i=0,skip=0;

  while (!feof(fp))
  {
    if ((c=getc(fp))==EOF) break;
    if (i==0 && c=='#')
      skip=1;
    if (c=='\n')
      if (i>0 && line[i-1]=='\\')
	i--;
      else
	break;
    else
      line[i++]=c;
  }
  line[i]=EOS;
  if (O_echoline)
  {
    write(2,line,strlen(line));
    write(2,"\n",1);
  }
  if (!nostrip) (void) strip(line);
  if (line[0]!=EOS && !skip) return(TRUE);
  else return(FALSE);
}

void File(finp,nosave)
  FILE *finp;
  int nosave;
{
  extern SYM_T intercom();
  extern bool getpipeline();
  extern int O_echoexp,O_exiterror,meta_1(),meta_2(),errno,disable_auto,waitfor();
  SYM_T act;
  char line[MAXLL],pipeline[MAXLL];
  int i,pos,ppos,pid,retval;
  bool skip_to_semi;

#ifdef DEBUG
fprintf(stderr,"Starting File()\n");
#endif
  while (!ffinish(finp))
  {
    for (i=0;i<MAXLL;i++) line[i]=EOS;
#ifdef DEBUG
fprintf(stderr,"Getting file line.\n");
#endif
    if (getfileline(line,finp,0)==TRUE)
    {
      act=RDRIN;
#ifdef DEBUG
fprintf(stderr,"Calling meta_1 with file line\n");
#endif
      if (meta_1(line,nosave)) act=ERRER;
#ifdef DEBUG
fprintf(stderr,"meta_1 success\n");
#endif
      if (O_echoexp)
      {
	write(2,line,strlen(line));
	write(2,"\n",1);
      }
      skip_to_semi=FALSE;
      pos=0;
      while (act!=ENDLN && act!=ERRER)
      {
	retval=0;

	for (i=0;i<MAXLL;i++) pipeline[i]=EOS;
#ifdef DEBUG
fprintf(stderr,"calling getpipeline\n");
#endif
	if (getpipeline(line,&pos,pipeline,skip_to_semi)==FALSE)
	  break;	/* thar ain't no more */

#ifdef DEBUG
fprintf(stderr,"calling meta_2\n");
#endif
	if (meta_2(pipeline))
	{
	  /* act=ERRER;   I should do this, if only to be consistent */
	  break;
	}

	ppos=0;		/* reset to start of pipeline */
	act=intercom(pipeline,&ppos,&pid,&i ,FALSE,1);	/* call intercom with fromfile  set */

#ifdef DEBUG
fprintf(stderr,"returned from intercom\n");
#endif
	skip_to_semi=FALSE;
	for (i=3;i<=NFILES;i++) if (i!=fileno(finp)) close(i);
	if (act!=ERRER && pid && act!=BCKGND)
	  retval=waitfor(pid);
	if (!disable_auto && act==ERRER) exit(1);	/* exit on shell syntax error */
	pid=0;
	if (O_exiterror && retval)
	{
	  write(2,"Exit on error.\n",15);
	  exit(1);
	}
	if (act==DBLPIPE && !retval) skip_to_semi=TRUE;
	if (act==DBLAMP && retval) skip_to_semi=TRUE;
      }
    }
#ifdef DEBUG
    else
      fprintf(stderr,"getfileline returned false\n");
#endif
  }
}

