/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                 exec.c                                    **
**     This file contains the functions relevant to command execution,       **
**       including path search, fg or bg setup, and execute function.        **
**                                                                           **
******************************************************************************/

#include "header.h"
#define FOUND 0
#define NONEXIST 2
#define NOTEXEC 13
#define NOALIAS 1
#define NOBUILTIN 2

#ifdef MINIX
extern int errno;
#endif
extern int alias_depth;
extern char **environ;
void (*builtin_func)();
struct adefn *alias_defn;
int stopflg,NoIoctl;

void setexec(pid)
  int pid;
{
  extern int fromfile;
#ifdef ATT
  struct termio tbuf;

#ifdef DEBUG
fprintf(stderr,"set exec\n");
#endif

  if (fromfile) return;		/* this is irrelevant if from a script */
  if (ioctl(0,TCGETA,&tbuf)) perror("ioctl in setexec");
  tbuf.c_lflag |= ICANON | ECHO;
  tbuf.c_cc[4]=04;	/* set EOT to ^D */
  tbuf.c_cc[5]=0;	/* set EOL to NUL */
  if (ioctl(0,TCSETA,&tbuf)) perror("ioctl1");

#else

  struct sgttyb t, *termod;
  struct tchars s, *setsigc;
#ifdef UCB
  struct ltchars moresigc;
#endif

#ifdef DEBUG
fprintf(stderr,"set exec\n");
#endif

  if (fromfile) return;		/* this is irrelevant if from a script */
/*** All this will be rewritten ***/
  termod= &t;
  if (ioctl(0,TIOCGETP,termod)) perror("ioctl in setexec");
  termod->sg_flags &= (~CBREAK);		/* cooked mode */
  termod->sg_flags |= ECHO;			/* with echo */
  if (ioctl(0,TIOCSETN,termod)) perror("ioctl1");
  setsigc= &s;
  if (ioctl(0,TIOCGETC,setsigc)) perror("ioctl2 in setexec");
  setsigc->t_intrc=03;				/* interrupt ctrl c */
  setsigc->t_quitc=034;				/* quit ctrl \ */
  setsigc->t_eofc=04;				/* eof ctrl d */
  if (ioctl(0,TIOCSETC,setsigc)) perror("ioctl2");
# ifdef UCB
  moresigc.t_suspc=032;				/* suspend ctrl z */
  moresigc.t_dsuspc=031;			/* delayed suspend ctrl y */
  moresigc.t_rprntc=022;			/* reprint ctrl r */
  moresigc.t_flushc=017;			/* flush ctrl o */
  moresigc.t_werasc=027;			/* word erase ctrl w */
  moresigc.t_lnextc=026;			/* literal next char ctrl v */
  if (ioctl(0,TIOCSLTC,&moresigc)) perror("ioctl3 in setexec");
  if (pid)	/* this is so when setexec is called without pid just to set the
	      signal keys, it doesn't repeat this bit (if that ever happens). */
  {
    if (ioctl(0,TIOCSPGRP,&pid)) perror("ioctl spg");
#ifdef DEBUG
    if (ioctl(0,TIOCGPGRP,&pid)) perror("Dioctl");
    fprintf(stderr,"terminal's pgrp is %d\n",pid);
    fprintf(stderr,"Setting pgrp to %d\n",pid);
#endif
    if (setpgrp(pid,pid)) perror("setpgrp");
    signal(SIGTTIN,SIG_DFL);
  }
# endif
/*** end of rewrite ***/

#endif

}

void setbgexec()
{
  int pid;

#ifdef DEBUG
  fprintf(stderr,"setbgexec\n");
#endif
#ifndef MINIX
  pid=getpid();
  setpgrp(pid,pid);
  signal(SIGTTIN,SIG_DFL);
#else
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
#endif
}

void resetsigdefaults()
{
  int sig;

  for(sig=1;sig<NSIG;sig++)
    signal(sig,SIG_DFL);
}

bool findslash(string)
  char *string;
{
  int i;

  for (i=0;string[i];i++)
    if (string[i]=='/') return(TRUE);
  return(FALSE);
}

static
void setflag()
{
  extern int fromfile;

  if (!fromfile) signal(SIGINT,SIG_IGN);
  else signal(SIGINT,SIG_DFL);
  kill(getpid(),SIGINT);
  stopflg=1;
}

#ifdef __STDC__
void runalias(struct adefn *start, int argc, char **argv, int infd,
	      int outfd, int errfd, char *ifil, char *ofil, char *efil,
	      bool appnd, bool bckgnd, bool piped)
#else
void runalias(start,argc,argv,infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd,piped)
  struct adefn *start;
  int argc,infd,outfd,errfd;
  char *argv[],*ifil,*ofil,*efil;
  bool appnd,bckgnd,piped;
#endif
{
  extern SYM_T intercom();
  extern FILE *zin;
  extern bool getpipeline();
  extern void setdown(),resetsh();
  extern char **arguments,*current_alias[];
  extern int O_echoexp,O_exiterror,numargs,fromfile,strip(),meta_1(),meta_2(),
	     waitfor();
#ifdef JOB
  extern void checkjobs();
#endif
  SYM_T act;
  struct adefn *ptr;
#ifndef ATT
  struct tchars setsigc;
#endif
  char line[MAXLL],pipeline[MAXLL],**oldargstemp;
  int i,pos,ppos,pid=0,oldnumargtemp,retval;
  bool skip_to_semi;

  if (bckgnd==TRUE) NoIoctl=1;
  if (alias_depth==0)	/* are we at the bottom level? */
  {
    stopflg=0;
    signal(SIGINT,setflag);
    if (!fromfile && bckgnd==FALSE)
    {
#ifdef ATT
      ;
#else
      if (ioctl(0,TIOCGETC,&setsigc)) perror("ioctl in runalias");
      setsigc.t_intrc=3;
      if (ioctl(0,TIOCSETC,&setsigc)) perror("ioctl r");
#endif
    }
  }
  if (alias_depth>=MAXAL)
  {
    fprintf(stderr,"Aliases nested too far (%d levels)\n",MAXAL);
    fflush(stderr);
    return;
  }
  /* This alias loop check should not be needed as it was done in getpath.
     However, it will stay here until I am satisified that the other one
     catches them all!
*/
  for (i=0;i<MAXAL && current_alias[i]!=NULL;i++)
    if (!strcmp(argv[0],current_alias[i]))
    {
      fprintf(stderr,"Alias loop detected. Alias previously encountered is '%s'\n",argv[0]);
      fflush(stderr);
      return;
    }
  current_alias[alias_depth++]=argv[0];	/* store alias name and move pointer */
  oldargstemp=arguments;
  arguments=argv;
  oldnumargtemp=numargs;
  numargs=argc;
#ifdef DEBUG
  fprintf(stderr,"fromfile %d numargs %d firstarg %s secondarg %s stopflg %d\n",fromfile,numargs,arguments[0],arguments[1],stopflg);
#endif
  for (ptr=start;ptr && !stopflg;ptr=ptr->nextln)
  {
    for (pos=0;line[pos];pos++) line[pos]=EOS;
    act=RDRIN;
    strncpy(line,ptr->a_line,MAXLL);
    (void) strip(line);
    if (meta_1(line,1)) act=ERRER;
    if (O_echoexp)
    {
      write(2,line,strlen(line));
      write(2,"\n",1);
    }
    skip_to_semi=FALSE;
    pos=0;
    while (act!=ENDLN && act!=ERRER)
    {
      if (stopflg) break;
      retval=0;
      for (i=0;i<MAXLL;i++) pipeline[i]=EOS;
      if (getpipeline(line,&pos,pipeline,skip_to_semi)==FALSE)
	break;

      if (meta_2(pipeline))
      {
#ifdef DEBUG
fprintf(stderr,"meta_2 failed\n");
#endif
	/* act=ERRER	pedantically included */
	break;
      }

      ppos=0;		/* reset to start of pipeline */
      act=intercom(pipeline,&ppos,&pid, &i, FALSE,fromfile);

      skip_to_semi=FALSE;
#ifdef DEBUG
fprintf(stderr,"pid returned from intercom is %d for line %s\n",pid,line);
fprintf(stderr,"fileno(zin) is %d\n",fileno(zin));
#endif
      for (i=3;i<=NFILES;i++) if (i!=fileno(zin)) close(i);
      if (act!=ERRER && pid && act!=BCKGND)
	retval=waitfor(pid);
#ifdef JOB
      signal(SIGCHLD,checkjobs);
#endif
      if (!fromfile && !NoIoctl) resetsh();
      pid=0;
      if (retval && O_exiterror)
      {
	write(2,"Exit on error.\n",15);
	if (!fromfile) setdown();
	exit(1);
      }
      if (act==DBLPIPE && !retval) skip_to_semi=TRUE;
      if (act==DBLAMP && retval) skip_to_semi=TRUE;
      if (act==SEMI) retval=0;
    }
#ifdef JOB
    signal(SIGCHLD,checkjobs);
#endif
  }
  current_alias[--alias_depth]=NULL;	/* go back to previous alias */
  arguments=oldargstemp;
  numargs=oldnumargtemp;
  if (alias_depth==0 && !fromfile && bckgnd==FALSE)
  {
#ifdef ATT
    ;
#else
    if (ioctl(0,TIOCGETC,&setsigc)) perror("runalias ioctl");
    setsigc.t_intrc=(UNDEF);
    if (ioctl(0,TIOCSETC,&setsigc)) perror("ioctl r2");
#endif
  }
}

int getpath(fullpathname,name,flag)
  char *fullpathname,*name,flag;
{
#ifdef HASH
  extern bool hashed;
  extern int hits,misses,errno;
  extern struct har hasharray[];
#endif
  extern bool dotinpath,executable();
  extern void (*checkbuiltins())();
  extern struct adefn *checkalias();
  extern char *current_alias[],*vget();
  SYM_T t,retsym();
  char path[VARVL],dir[MAXWL];
  int i,aliasloop,times,pos=0,hashval,pcnum=0;
#ifdef HASH
  int hash();
#endif
  DIR *dd,*opendir();
#ifdef ATT
  struct dirent *entry,*readdir();
#else
# ifdef MINIX
  struct dirent *entry;
# else
  struct direct *entry,*readdir();
# endif
#endif
  bool exist=FALSE;

  builtin_func=0;		/* reset the builtin and alias pointers */
  alias_defn=0;
  aliasloop=0;
#ifdef DEBUG
fprintf(stderr,"current_alias is %s<\n",alias_depth?current_alias[alias_depth-1]:"(none)");
#endif
/* if there is a slash in the name then we don't search just straight exec */
  if (findslash(name)==TRUE)
  {
/* check if it's a builtin here.   e.g. ~#/list */
    if (name[0]=='~' && name[1]=='#')
    {
      alias_defn=checkalias(&name[3]);	/* [3] will remove the ~#/. If they
					   stuff up it's their bad luck */
      builtin_func=checkbuiltins(&name[3]);	/* ditto */
      for (i=0;i<MAXAL && current_alias[i]!=NULL;i++)
	if (!strcmp(current_alias[i],&name[3]))
	{
	  aliasloop=1;
	  break;
	}
      if (alias_defn && aliasloop)
      {
	if (builtin_func)
	{
	  alias_defn=0;
	  return(FOUND);
	}
	write(2,"Alias loop.\n",12);
	return(NOTEXEC);
      }
      strcpy(fullpathname,name);
      return(FOUND);
    }
    strcpy(fullpathname,name);
    if (executable(fullpathname,NULL,1)==FALSE) return(NOTEXEC);
    return(FOUND);
  }

/* use hash table to find directory containing name but if hashing is not used
   for whatever reasons, then search manually through the path */
#ifdef HASH
  if (hashed==TRUE)
  {
    hashval=hash(name);
    for (times=0;hasharray[hashval].name && times<HSHSIZ;times++)
    {
      if (!strcmp(hasharray[hashval].name,name))
      {
#ifdef DEBUG
fprintf(stderr,"name match. check dot flag %o\n",hasharray[hashval].flag);
#endif
	if (dotinpath==TRUE && (hasharray[hashval].flag&PRIORITY))
	{
	  /* Dot occurs before this one so look for file in current directory */
#ifdef DEBUG
fprintf(stderr,"call executable\n");
#endif
	  errno=0;
	  if (executable(name,NULL,1)==TRUE)
	  {
	    if (times==0) hits++;		/* found it first go */
	    else misses++;			/* had a collision */
	    strcpy(fullpathname,hasharray[hashval].name);
	    return(FOUND);
	  }
	  /* otherwise we just fall through and do the other testing */
	}
#ifdef DEBUG
fprintf(stderr,"Not rejected by . checking for alias or builtin.\n");
#endif
	if (pos=(hasharray[hashval].flag&EXTYPE))
	{
#ifdef DEBUG
fprintf(stderr,"pos is %d\n",pos);
#endif
	  if (pos==ALIASEX)
	  {
	    for (i=0;i<MAXAL && current_alias[i]!=NULL;i++)
	      if (!strcmp(current_alias[i],hasharray[hashval].name))
	      {
		aliasloop=1;
		break;
	      }
	    if (aliasloop || flag)
	    {
	      hashval++;
	      hashval%=HSHSIZ;
	      continue;
	    }
	    else
	      alias_defn=hasharray[hashval].exec_ptr.alias_defn;
	  }
	  else
	    if (flag==NOBUILTIN)
	    {
	      hashval++;
	      hashval%=HSHSIZ;
	      continue;
	    }
	    else
	      builtin_func=hasharray[hashval].exec_ptr.builtin_fn;
	  if (times==0) hits++;
	  else misses++;
	  return(FOUND);
	}
	strcpy(fullpathname,hasharray[hashval].exec_ptr.dir);
	strcat(fullpathname,"/");
	strcat(fullpathname,hasharray[hashval].name);
#ifdef DEBUG
fprintf(stderr,"doing executable with %s<\n",fullpathname);
#endif
	if (executable(fullpathname,NULL,1)==FALSE)
	{
#ifdef DEBUG
fprintf(stderr,"executable failed\n");
#endif
	  exist=TRUE;
	  hashval++;
	  hashval%=HSHSIZ;
	  continue;
	}
	if (times==0) hits++;		/* found it first go */
	else misses++;			/* had a collision */
	return(FOUND);
      }
      hashval++;
      hashval%=HSHSIZ;
    }
#ifdef DEBUG
fprintf(stderr,"not in table.\n");
#endif
    if (dotinpath==TRUE)
    {
      /* check for name in here since not in hash table */
      errno=0;
      if (executable(name,NULL,1)==FALSE)
      {
	if (errno!=ENOENT)
	  exist=TRUE;
      }
      else
      {
	strcpy(fullpathname,"./");
	strcat(fullpathname,name);
	return(FOUND);
      }
    }
    if (aliasloop)
    {
      write(2,"Alias loop. No other command of same name on path.\n",51);
      return(NOTEXEC);
    }
    if (exist==TRUE) return(NOTEXEC);
    return(NONEXIST);
  }
  else			/* full path search, no hashing */
#endif
  {
    strcpy(path,vget("PATH"));
    while((t=retsym(path,dir,&pos,FALSE))!=ENDLN)
    {
      pcnum++;
      if (t!=WORD)
      {
	fprintf(stderr,"Component %d of $PATH is illegal.\n",pcnum);
	continue;
      }
#ifdef DEBUG
fprintf(stderr,"Looking in %s\n",dir);
#endif
      if (dir[0]=='~' && dir[1]=='#')
      {
	if (alias_defn=checkalias(name))
	{
	  for (i=0;i<MAXAL && current_alias[i]!=NULL;i++)
	    if (!strcmp(name,current_alias[i]))
	    {
#ifdef DEBUG
fprintf(stderr,"Detected alias loop and...");
#endif
	      aliasloop=1;
	      alias_defn=0;
	    }
	  if (!aliasloop) return(FOUND);
	}
	if (builtin_func=checkbuiltins(name)) return(FOUND);
#ifdef DEBUG
fprintf(stderr,"continuing.\n");
#endif
	continue;
      }
      if ((dd=opendir(dir))!=NULL)
      {
	while((entry=readdir(dd))!=NULL)
	  if (strcmp(entry->d_name,name)==0)		/* found same name */
	  {
	    if (executable(dir,entry->d_name,0)==FALSE)	/* if not executable */
	    {
	      exist=TRUE;			/* then found non-exec'ble */
	      continue;					/* and ignore it */
	    }
	    strcpy(fullpathname,dir);
	    strcat(fullpathname,"/");
	    strcat(fullpathname,entry->d_name);
	    closedir(dd);
	    return(FOUND);
	  }
	closedir(dd);
      }
    }
/* No else for above 'if'. If we can't open a directory then that's that. */
  }
  if (exist==TRUE || aliasloop) return(NOTEXEC);
  return(NONEXIST);
}

void panic(mess)
  char *mess;
{
  write(2,mess,strlen(mess));
  write(2,"\n",1);
  exit(0);
}

int atoo(str)
  char *str;
{
  int i,oct=0;

  for (i=0;str[i];i++)
    oct=oct*8+str[i]-48;
  return(oct);
}
    
void setmask(str)
  char *str;
{
  int cmask;

  cmask=atoo(str);
  umask(cmask);
}

#ifdef __STDC__
void redirect(int infd, int outfd, int errfd, char *ifil, char *ofil,
	      char *efil, bool appnd, bool bckgnd)
#else
void redirect(infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd)
  int infd,outfd,errfd;
  char *ifil,*ofil,*efil;
  bool appnd,bckgnd;
#endif
{
  extern char *vget();
  int fd,mode,flags;

  if (infd==0 && bckgnd==TRUE)		/* don't allow read from background */
  {
    strcpy(ifil,"/dev/null");
    infd=(-2);				/* now take input from /dev/null */
  }
  if (infd!=0)
  {
    close(0);
    if (infd>0)
    {
      if (dup(infd)!=0)			/* panic, did not dup stdin */
	panic("exec.c: dup: stdin");
    }
    else
#ifndef ATARI_ST
      if (open(ifil,O_RDONLY,0) == -1)
#else
      if (open(ifil,O_RDONLY) == -1)
#endif
      {
	fprintf(stderr,"Can't open %s\n",ifil);
	exit(0);
      }
  }
  if (outfd!=1)
  {
    close(1);
    if (outfd>1)
    {
      if (dup(outfd)!=1)		/* panic, did not dup stdout */
	panic("exec.c: dup: stdout");
    }
    else
    {
					/* Minix has old open call */
#ifdef MINIX
      flags=O_WRONLY;
      mode= 0777;
      errno= OK;			/* Set no current errors */
      if ( (!appnd) || (((open(ofil,flags))==-1) && (errno==EINVAL)) )
      {
        if (creat(ofil,mode) == -1)
        {  
 	 fprintf(stderr,"Can't open %s\n",ofil);
	 exit(0);
	}
	if (open(ofil,flags) == -1)
	{
 	 fprintf(stderr,"Can't open %s\n",ofil);
	 exit(0);
	}
      }
      if (errno!=OK)
      {
 	 fprintf(stderr,"Can't open %s\n",ofil);
	 exit(0);
      }
#else
      flags=O_WRONLY | O_CREAT;
      if (!appnd) flags|=O_TRUNC;
      mode=0777;
      if (open(ofil,flags,mode)==-1)
      {
	fprintf(stderr,"Can't open %s\n",ofil);
	exit(0);
      }
#endif
      if (appnd==TRUE)
	lseek(1,0L,2);
    }
  }
  if (errfd!=2)
  {
    close(2);
    if (errfd>2)
    {
      if (dup(errfd)!=2)
	panic("exec.c: dup: stderr");
    }
    else
    {
#ifdef MINIX
      flags= O_WRONLY;
      mode= 0777;
      if (creat(efil,mode)==-1)
      {
	write(2,"Can't open ", 11);
	write(2,efil,strlen(efil));
	exit(0);
      }
      if (open(efil,flags)==-1)
      {
	write(2,"Can't open ", 11);
	write(2,efil,strlen(efil));
	exit(0);
      }
#else
      flags=O_WRONLY | O_CREAT | O_TRUNC;
      mode=0777;
      if (open(efil,flags,mode)==-1)
      {
	write(2,"Can't open ",11);
	write(2,efil,strlen(efil));
	exit(0);
      }
#endif
    }
  }
  for (fd=3;fd<NFILES;fd++)
  (void) close(fd);
}
	
#include <errno.h>
extern int errno;
#ifdef __STDC__
int execute(int argc, char **argv, int infd, int outfd, int errfd,
	    char *ifil, char *ofil, char *efil, bool appnd,
	    bool bckgnd, bool piped, int frmfile)
#else
int execute(argc,argv,infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd,piped,frmfile)
  int argc,infd,outfd,errfd;
  char *argv[],*ifil,*ofil,*efil;
  bool appnd,bckgnd,piped;
  int frmfile;
#endif
{
  extern void makenv();
  extern char *invokename,*current_alias[];
  extern int errno,O_noexec,globpid;
#ifdef JOB
  extern int addjob();
  int jobno;
#endif
  int pid=0,i;
  char path[MAXPL];

  makenv();			/* make environment from exported variables */
  if ((errno=getpath(path,argv[0],0))==FOUND)
  {
    if (O_noexec) return(0);
    if (bckgnd==FALSE && piped==FALSE)
    {
      if (alias_defn!=0)
      {
#ifdef DEBUG
fprintf(stderr,"Executing runalias\n");
#endif
	runalias(alias_defn,argc,argv,infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd,piped);
	return(0);
      }
      if (builtin_func!=0)
      {
#ifdef DEBUG
fprintf(stderr,"Executing builtin\n");
#endif
	(*builtin_func)(argc,argv,infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd,piped);
	if (globpid)		/* set by fg */
	{
	  pid=globpid;
	  globpid=0;
	}
#ifdef DEBUG
fprintf(stderr,"returning pid %d after builtin\n");
#endif
	return(pid);
      }
    }
#ifdef DEBUG
fprintf(stderr,"Forking to use path\n");
#endif
#ifdef UCB
    signal(SIGCHLD,SIG_IGN);		/* we're assuming the fork will work */
#endif
    switch(pid=fork())
    {
      case -1: write(2,"Cannot create new process.\n",26);
	       return(0);
      case 0 : resetsigdefaults();
	       current_alias[alias_depth]=NULL;	/* make sure */
#ifdef DEBUG
fprintf(stderr,"bckgnd %d piped %d\n",bckgnd,piped);
fprintf(stderr,"maybe setexec from execute\n");
#endif
	       if (bckgnd==TRUE) setbgexec();
	       /*else*/ if (!NoIoctl && piped==FALSE && !fromfile) setexec(pid=getpid());
	       redirect(infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd);
	       if (alias_defn!=0)
	       {
#ifdef DEBUG
fprintf(stderr,"Executing runalias, new process\n");
#endif
		 runalias(alias_defn,argc,argv,infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd,piped);
		 exit(0);
	       }
	       if (builtin_func!=0)
	       {
#ifdef DEBUG
fprintf(stderr,"Executing builtin, new process\n");
#endif
		 (*builtin_func)(argc,argv,infd,outfd,errfd,ifil,ofil,efil,appnd,bckgnd,piped);
		 exit(0);
	       }
/* All caught signals should be reset by execve so we shouldn't have to do it in
   resetsigdefaults. It doesn't work for ignored ones, though. */
#ifdef DEBUG
fprintf(stderr,"path %s argv[0] %s argv[1] %s argv[2] %s\n",path,argv[0],argv[1],argv[2]);
#endif
	       execve(path,argv,environ);
		if (errno != ENOEXEC)		/* Don't use sh if exec fails */
			{perror("exec");	/* because lack of space */
			 exit(1);
			}

/* Try to use shell to interpret, now. First move args along, insert the
   default interpreter defined in header.h and away we go!! */
#ifdef DEBUG
fprintf(stderr,"Can't exec. Trying to use shell.\n");
#endif

	       for (i=argc;i;i--) argv[i]=argv[i-1];
	       argv[1]=(char *) realloc (argv[1],(unsigned)(strlen(path)+1));
	       strcpy(argv[1],path);		/* full path for source file */
#ifdef DEBUG
fprintf(stderr,"argv[1] is %s<\n",argv[1]);
#endif
	       argv[0]=(char *) malloc ((unsigned)(strlen(DFLTSH)+1));
	       strcpy(argv[0],DFLTSH);
	       strcpy(path,DFLTSH);
	       argv[++argc]=NULL;	/* one more arg for mankind... */
#ifdef DEBUG
fprintf(stderr,"path %s argv[0] %s argv[1] %s argv[2] %s\n",path,argv[0],argv[1],argv[2]);
#endif
	       execve(path,argv,environ);
/* okay, it still doesn't work, give up */
	       perror(path);
	       exit(1);
      default:
#ifdef JOB
	       if (!piped) jobno=addjob(pid,argv[0],outfd,bckgnd);
	       if (bckgnd==TRUE) printf("[%d] %d\n",jobno,pid);
#else
	       if (bckgnd==TRUE) printf(" %d\n",pid);
#endif
#ifdef DEBUG
fprintf(stderr,"Piped is %d\n",piped);
#endif
	       return(pid);
    }
  }
  else
  {
    if (frmfile)
    {
      write(2,invokename,strlen(invokename));
      write(2,": ",2);
    }
    perror(argv[0]);
  }
  return(0);
}

