/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                   cx.c                                    **
**          Even more extensions. ~ expansion and help for editor            **
**                                                                           **
******************************************************************************/

#include "header.h"

bool expand_tilde(user_path,builtin)
  char *user_path;
  int *builtin;
{
  extern void getdir();
  extern char beep[],*getlogin();
  struct passwd *pw;
  FILE *pswdp,*fopen();
  char *un,pwent[256],username[USERNL],restpath[MAXWL];
  int i,j,colon=0;

#ifdef DEBUG
fprintf(stderr,"user_path is %s\n",user_path);
#endif
  for (i=0;i<USERNL;i++) username[i]=EOS;
  if ((pswdp=fopen(PASSWD,"r"))==NULL)
  {
    fprintf(stderr,"\n%sCannot open file: %s\n",beep,PASSWD);
    user_path[0]=EOS;
    return(FALSE);
  }
/* we can ignore the first char since we know it's a ~. */
  for (i=1;user_path[i]!='/';i++)
    username[i-1]=user_path[i];
  username[i-1]=EOS;
#ifdef DEBUG
fprintf(stderr,"i is %d username is %s &user_path[i] is %s\n",i,username,&user_path[i]);
#endif
  strncpy(restpath,&user_path[i],MAXWL);	/* copy rest over to temp */
#ifdef DEBUG
fprintf(stderr,"restpath %s\n",restpath);
#endif
  if (username[0]==EOS)			/* if we have ~/rest/of/path */
  {
    if ((un=getlogin()) == NULL)
    {
      if ((pw=getpwuid(getuid())) == NULL)
      {
	fprintf(stderr,"\n%sCan't get username\n",beep);
	user_path[0]=EOS;
	return(FALSE);
      }
      else un=pw->pw_name;
    }
    strncpy(username,un,USERNL);
    i=strlen(username);
  }
  else i--;				/* now i equals strlen(username) */
#ifdef DEBUG
fprintf(stderr,"username is %s length is %d\nrestpath is %s\n",username,i,restpath);
#endif
  if (!strcmp(username,"#"))
  {
    *builtin=1;
    return(TRUE);			/* just return and don't change */
  }
  while (!feof(pswdp))
  {
    getdir(pswdp,pwent);
    if ((!strncmp(username,pwent,i)) && (pwent[i]==':'))
    {
      for (i=0;pwent[i] && colon<5;i++)
	if (pwent[i]==':') colon++;
      if (colon==5)
      {
	for (j=0;pwent[i] && pwent[i]!=':';i++,j++)
	  user_path[j]=pwent[i];
	strncpy(&user_path[j],restpath,MAXWL-j);
      }
      else
      {
	fprintf(stderr,"\n%sBad password entry in %s for %s.\n",beep,PASSWD,username);
/*	close(pswdp); */
	fclose(pswdp);
	return(FALSE);
      }
      break;
    }
  }
/*  close(pswdp); */
  fclose(pswdp);
/* this test is a repeat of the one above but will give a different error
   message if we can't find a matching username */
  if (colon!=5)
  {
    fprintf(stderr,"\n%sNo such user: %s\n",beep,username);
    return(FALSE);
  }
  return(TRUE);
}

void help(line,pos,curs)
  char *line;
  int pos,curs[];
{
  extern void yankprev(),prprompt(),show(),resetsigdefaults();
  extern int waitfor();
#ifdef JOB
  extern void checkjobs();
  extern int addjob();
#endif
  char word[MAXWL],*arg[3];
  int pid;

/* get the command we want to get help for */
  yankprev(line,pos,word);
	/* Minix doesn't have this signal */
#ifdef UCB
  signal(SIGCHLD,SIG_IGN);
#endif
  switch (pid=fork())
  {
    case -1: fprintf(stderr,"\nFork failed! Cannot run %s\n",HELP);
	     prprompt(1);
	     show(line,curs,TRUE);
	     return;
    case 0 : write(1,"\n",1);
	     resetsigdefaults();
	     arg[0]="man";
	     arg[1]=word;
	     arg[2]=0;
	     execv(HELP,arg);
	     perror(HELP);
	     exit(1);
    default:
#ifdef JOB
             (void) addjob(pid,HELP,1,FALSE);
#endif
	     (void) waitfor(pid);
#ifdef JOB
	     signal(SIGCHLD,checkjobs);
#endif
  }
  prprompt(1);
  show(line,curs,TRUE);
}
