/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                comlined.c                                 **
**                 This file contains the COMmand LINe EDitor.               **
**                                                                           **
******************************************************************************/

#include "header.h"

	/* Minix seems to have a strange stdio.h FILE struct */

#ifdef MINIX
#define _file	_fd
#endif

extern char termcapbuf[];
extern FILE *zin,*zout,*fopen();

#ifndef ATARI_ST
void mputc(c,f,curs)
  char c;
  FILE *f;
  int curs[];
{
  extern int wid;

  write(f->_file,&c,1);
  curs[0]++;
  if (curs[0]>=wid)
  {
    write(f->_file,"\n",1);			/* goto start of next line */
    curs[0]=curs[0]%wid;			/* hopefully gives zero */
    curs[1]++;
  }
}
#else
void mputc(c,f,curs)
  int c;
  FILE *f;
  int curs[];
{
  extern int wid;
  char cc = c;
  
  write(f->_file,&cc,1);
  curs[0]++;
  if (curs[0]>=wid)
  {
    write(f->_file,"\n",1);			/* goto start of next line */
    curs[0]=curs[0]%wid;			/* hopefully gives zero */
    curs[1]++;
  }
}
#endif

#ifndef ATARI_ST
void oputc(c)
  char c;
{
  write(zout->_file,&c,1);
}
#else
int oputc(c)
  int c;
{
    char cc = c;
    return write(zout->_file,&cc,1);
}
#endif

void go(curs,hor,vert)
  int curs[],hor,vert;
{
  extern char bs[],nd[],up[];
  int hdiff,vdiff;

  vdiff=vert-curs[1];			/* vertical difference between */
					/* current and future positions */

  if (vdiff<=0)				/* if negative go up */
    for(;vdiff;vdiff++) tputs(up,1,oputc);
  else					/* else go down */
  {
    for(;vdiff;vdiff--) write(1,"\n",1);
    curs[0]=0;
  }
    
  hdiff=hor-curs[0];			/* horizontal difference between */
					/* current and future positions */
  curs[0]=hor; curs[1]=vert;		/* a new current pos, hopefully */
	/* assigned here because hor changed below and curs needed above */

  if (hdiff<0)				/* if negative go back */
    if (-hdiff<=hor)			/* if shorter distance just use ^H */
      for(;hdiff;hdiff++) write(zout->_file,bs,strlen(bs));
    else				/* else cr and go forward */
    {
      write(zout->_file,"\r",1);
      for (;hor;hor--) tputs(nd,1,oputc);
    }
  else					/* have to go forward */
   for (;hdiff;hdiff--) tputs(nd,1,oputc);

}

void backward(curs)
  int curs[];
{
  extern int wid;
  extern char bs[];

  if (curs[0]==0)
    go(curs,wid-1,curs[1]-1);
  else
  {
    write(zout->_file,bs,strlen(bs));
    curs[0]--;
  }
}

void forward(curs)
  int curs[];
{
  extern int wid;
  extern char nd[];

  curs[0]++;
  if (curs[0]>=wid)
  {
    write(zout->_file,"\n",1);		/* goto start of next line */
    curs[0]=curs[0]%wid;		/* hopefully gives zero */
    curs[1]++;
  }
  else tputs(nd,1,oputc);
}

void clrscrn()
{
  extern char cl[];

  tputs(cl,1,oputc);			/* clear the screen */
}

void insert(line,pos,letter,curs)
  char *line,letter;
  int pos,curs[];
{
  extern int wid;
  int i,horig,vorig;
  char c;

  for (i=pos;line[i];i++);			/* goto end of line */
  for (;i!=pos;i--) line[i]=line[i-1];		/* copy characters forward */
  line[pos]=letter;				/* insert new char */
  if (letter<32 || letter==127) horig=curs[0]+2;
  else horig=curs[0]+1;
  vorig=curs[1];
  if (horig>wid-1)
  {
    horig=horig%wid;
    vorig++;
  }
  for (c=line[pos];c;c=line[++pos])		/* write out rest of line */
  {
    if (c<32 || c==127)				/* if it's a control char */
    {
      mputc('^',zout,curs);			/* print out the ^ and */
      mputc(c+64,zout,curs);			/* the equivalent char for it*/
    }
    else mputc(c,zout,curs);
  }
  go(curs,horig,vorig);
}

void overwr(line,pos,letter,curs)
  char *line,letter;
  int pos,curs[];
{
  extern int wid;
  int ctrl,horig,vorig;
  char c;

  ctrl=0;
  line[pos]=letter;				/* overwrite new char */
  if (letter<32 || letter==127)
  {
    horig=curs[0]+2;
    ctrl=1;
  }
  else horig=curs[0]+1;
  vorig=curs[1];
  if (horig>wid-1)
  {
    horig=horig%wid;
    vorig++;
  }
  if (ctrl)
  {
    for (c=line[pos];c;c=line[++pos])		/* write out rest of line */
    {
      if (c<32 || c==127)			/* if it's a control char */
      {
	mputc('^',zout,curs);			/* print out the ^ and */
	mputc(c+64,zout,curs);			/* the equivalent char for it*/
      }
      else mputc(c,zout,curs);
    }
  }
  else mputc(letter,zout,curs);
  go(curs,horig,vorig);	/* do this in case we moved, and to update curs[] */
}

#ifdef __STDC__
void show(char *line, int *curs, bool clearing)
#else
void show(line,curs,clearing)
  char *line;
  int curs[];
  bool clearing;
#endif
{
  extern int lenprompt;
  int pos=0,horig,vorig;
  char c;

  horig=curs[0];vorig=curs[1];			/* save original values */
  if (clearing==TRUE)
  {
    curs[0]=lenprompt;curs[1]=0;
  }
  else
  {
    go(curs,lenprompt,0);			/* goto start of line */
  }
  for (c=line[pos];c!=EOS;c=line[++pos])	/* write out rest of line */
    if (c<32 || c==127)				/* if it's a control char */
    {
      mputc('^',zout,curs);			/* print out the ^ and */
      mputc(c+64,zout,curs);			/* the equivalent char for it*/
    }
    else mputc(c,zout,curs);
  go(curs,horig,vorig);			/* go back from whence you came */
}

void goend(line,pos,curs)
  char *line;
  int *pos,curs[];
{
  char c;

  for (c=line[*pos];c;c=line[++(*pos)])
  {
    if (c<32 || c==127)
    {
      mputc('^',zout,curs);
      mputc(c+64,zout,curs);
    }
    else mputc(c,zout,curs);
  }
}

void copyback(line,pos,curs,count)
  char *line;
  int pos,curs[],count;
{
  char c;
  int i,horig,vorig,wipe;

#ifdef DEBUG
  fprintf(stderr,"pos %d count %d\n",pos,count);
#endif
  if ((i=pos+count)<MAXLL)
  {
    wipe=0;
    for (horig=pos;horig<i;horig++)
      if (line[horig]<32 || line[horig]==127) wipe+=2;	/* calculate amount to blank */
      else wipe++;
    for (;line[i]!=EOS;++i)		/* copy line back count chars */
      line[i-count]=line[i];
    for (horig=i-count;i>horig && i<MAXLL+1;i--)
      line[i-1]=EOS;			/* end with nulls */
  }
  else
  {
    write(2,"count passed to copyback is too big\n",35);
    return;
  }
  horig=curs[0];vorig=curs[1];
  for (c=line[pos];c;c=line[++pos])
    if (c<32 || c==127)
    {
      mputc('^',zout,curs);
      mputc(c+64,zout,curs);
    }
    else mputc(c,zout,curs);
#ifdef DEBUG
  fprintf(stderr,"wipe %d\n",wipe);
#endif
  for (i=0;i<wipe;i++) mputc(' ',zout,curs);	/* blank old chars */
  go(curs,horig,vorig);
}

void delnextword(line,pos,curs)
  char *line;
  int pos,curs[];
{
  int inword=0,l=1,charcount=0;

  while(l)
    switch(line[pos+charcount])
    {
      case EOS:
	l=0;
	break;
      case ' ':case '\t':case '>':case '<':case '|':case '/':
      case ';':case '=':case '+':case '&':case '`':
	if (inword) l=0;
	else charcount++;
	break;
      default:
	inword=1;
	charcount++;
    }
#ifdef DEBUG
  fprintf(stderr,"Deleting %d chars\n",charcount);
#endif
  copyback(line,pos,curs,charcount);
}

void delprevword(line,pos,curs)
  char *line;
  int *pos,curs[];
{
  int inword=0,l=1,charcount=0;

  while(l)
    if ((*pos)>0)
      switch (line[(*pos)-1])
      {
	case ' ':case '\t':case '<':case '>':case '|':case '/':
	case ';':case '=':case '+':case '&':case '`':
	  if (inword) l=0;
	  else
	  {
	    charcount++;
	    (*pos)--;
	  }
	  break;
	default:
	  inword=1;
	  charcount++;
	  (*pos)--;
      }
    else l=0;
#ifdef DEBUG
  fprintf(stderr,"Deleting %d chars\n",charcount);
#endif
/* l should be zero already, aren't I naughty! */
  for (;l<charcount;l++) backward(curs);	/* move back */
  copyback(line,*pos,curs,charcount);		/* and copy the line on top */
}

void backword(line,pos,curs)
  char *line;
  int *pos,curs[];
{
  int inword=0,l=1;
  char c;

  while(l)
    if ((*pos)>0)
      switch (c=line[(*pos)-1])
      {
	case ' ':case '\t':case '<':case '>':case '|':
	case ';':case '=':case '+':case '&':case '`':
	  if (inword) l=0;
	  else
	  {
	    backward(curs);
	    (*pos)--;
	  }
	  break;
	default:
	  inword=1;
	  if (c<32 || c==127) backward(curs);
	  backward(curs);
	  (*pos)--;
      }
    else l=0;
}

void forword(line,pos,curs)
  char *line;
  int *pos,curs[];
{
  int inspace=0,l=1;
  char c;

  while(l)
    switch (c=line[*pos])
    {
      case EOS:
	l=0;
	break;
      case ' ':case '\t':case '<':case '>':case '|':
      case ';':case '=':case '+':case '&':case '`':
	inspace=1;
	forward(curs);
	(*pos)++;
	break;
      default:
	if (inspace) l=0;
	else
	{
	  if (c<32 || c==127) forward(curs);
	  forward(curs);
	  (*pos)++;
	}
    }
}

void yanknext(line,pos,yankbuf)
  char *line,*yankbuf;
  int pos;
{
  int l=1,inword=0,i=0;

  while(l)
    switch(line[pos])
    {
      case EOS:
	l=0;
	yankbuf[i]=EOS;
	break;
      case ' ':case '\t':case '<':case '>':case '|':
      case ';':case '=':case '+':case '&':case '`':
	if (inword)
	{
	  l=0;
	  yankbuf[i]=EOS;
	}
	else
	  yankbuf[i++]=line[pos++];
	break;
      default:
	inword=1;
	yankbuf[i++]=line[pos++];
    }
}

void yankprev(line,pos,yankbuf)
  char *line,*yankbuf;
  int pos;
{
  int stpos=pos,inword=0,l=1;

  while(l && stpos>0)			/* this loop finds the start of the */
    switch(line[stpos-1])		/* previous word (at stpos) */
    {
      case ' ':case '\t':case '>':case '<':case '|':case '"':
      case ';':case '=':case '+':case '&':case '`':case '\'':
	if (inword) l=0;
	else stpos--;
	break;
      default:
	inword=1;
	stpos--;
    }
  for (l=0;stpos<pos;stpos++,l++)	/* then copy from stpos upto pos */
    yankbuf[l]=line[stpos];
  yankbuf[l]=EOS;
}

void clrline(line,pos,curs)
  char *line;
  int pos,curs[];
{
  extern bool tflagexist();
  extern char cd[];
  int i,horig,vorig;

  if (tflagexist("cd",termcapbuf)==TRUE)	/* If there's a special char for clr */
  {					/* then use it */
    tputs(cd,1,oputc);
    for (i=pos;line[i];i++) line[i]=EOS;
#ifdef DEBUG
fprintf(stderr,"cleared ok\n");
#endif
  }
  else					/* else we gotta use spaces. */
  {
    horig=curs[0];vorig=curs[1];	/* Orginal values for curs set. */

    for (i=pos;line[i];i++)		/* Wipe out all those chars */
    {					/* with spaces (so slow), */
      mputc(' ',zout,curs);
      if (line[i]<32 || line[i]==127) mputc(' ',zout,curs);
      line[i]=EOS;
    }
    go(curs,horig,vorig);		/* restore original curs position */
  }
}

void transpose(line,pos,curs)
  char *line;
  int pos,curs[];
{
  char temp;

  if (line[pos-1]<32 || line[pos-1]==127) backward(curs);
  backward(curs);
  temp=line[pos];
  line[pos]=line[pos-1];
  line[pos-1]=temp;
  if (line[pos-1]<32 || line[pos-1]==127)
  {
    mputc('^',zout,curs);
    mputc(line[pos-1]+64,zout,curs);
  }
  else mputc(line[pos-1],zout,curs);
  if (line[pos]<32 || line[pos]==127)
  {
    mputc('^',zout,curs);
    mputc(line[pos]+64,zout,curs);
  }
  else mputc(line[pos],zout,curs);
  if (line[pos]<32 || line[pos]==127) backward(curs);
  backward(curs);
}

int strip(line)
  char *line;
{
  int i,nosave=0;

  for (i=0;line[i]==' ';i++);
  if (line[i]=='#')
  {
    nosave=1;
    i++;
  }
  if (i) strcpy(line,&line[i]);
  return(nosave);
}

void tardis(line,pos,curs)
  char *line;
  int *pos,curs[];
{
  extern void loadhist();
  extern char beep[];
  extern int curr_hist,matchhist(),beeplength;
  int hnum;

/* matchhist finds the history line matching the previous command and returns
   the one after that, predicting that you want to do the same thing. */
  hnum=matchhist(curr_hist-1);
  if (hnum) loadhist(line,pos,hnum,curs);
  else write(1,beep,beeplength);
}

bool getline(line,nosave,feature_off)
  char *line;
  int *nosave,feature_off;
{
  extern int loadline,curr_hist,maxhist,lenprompt,O_echoline,beeplength,
	     savehist(),matchhline();
  extern char beep[],yankbuf[],*vget();
  extern void loadhist(),leave_shell(),complete(),nameopt(),prprompt(),help(),(*charfn)(),(*ptif)();
  char c,remline[MAXLL];
  int times=1,i,pos=0,hist=curr_hist,curs[2],hsave=lenprompt,vsave=0,possave=0,
      try=0;

  curs[0]=lenprompt;	/*lenprompt global set by prprompt or when prompt set*/
  curs[1]=0;					/* start on line 0 */
  if (loadline)
  {
    goend(line,&pos,curs);
    loadline=0;
  }
  else if (vget("TARDIS")!=(char *)UNDEF && !feature_off)
    tardis(line,&pos,curs);
  while (1)
  {
    c=getc(zin);
    for (;times>0;times--)
    switch(c)
    {
      case EOF : fprintf(stderr,"Help me, I'm being hit by a looney with a stick.\n");
		 if (!try)
		 {
		   fprintf(stderr,"Trying to reassign stdin...");
		   zin=stdin;
		   try=1;
		   continue;
		 }
		 else
		 {
		   fprintf(stderr,"Trying to reopen stdin...");
		   if ((zin=fopen("/dev/tty","w+"))==NULL)
		   {
		     fprintf(stderr,"failed!\n");
		     exit(1);
		   }
		   fprintf(stderr,"Successful!\n");
		   try=0;
		 }
		 continue;
      case EOS : hsave=curs[0];			/* save position (make mark) */
		 vsave=curs[1];
		 possave=pos;
		 break;
      case  1  : go(curs,lenprompt,0);	/* goto start of the line */
		 pos=0;
		 break;
      case  2  : if (pos>0)			/* if not at home, go back */
		 {
		   if (line[pos-1]<32 || line[pos-1]==127) backward(curs);
		   backward(curs);
		   pos--;
		 }
		 else write(1,beep,beeplength);		/* else ring bell */
		 break;
      case  3  : goend(line,&pos,curs);
		 write(zout->_file,"\n",1);
		 return(FALSE);
      case  4  : if (line[0]==EOS && !feature_off)
		 {
		   leave_shell(); /*eof*/
		   return(FALSE); /* return if no exit */
		 }
		 else if (line[pos]!=EOS)
			copyback(line,pos,curs,1); /* delete char */
		      else if (!feature_off) nameopt(line,pos,curs);
		 break;
      case  5  : goend(line,&pos,curs);		/* goto end of the line */
		 break;
      case  6  : if (line[pos]!=EOS)		/* if not at end, go forward */
		 {
		   if (line[pos]<32 || line[pos]==127) forward(curs);
		   forward(curs);
		   pos++;
		 }
		 else write(1,beep,beeplength);		/* else ring bell */
		 break;
      case  7  : go(curs,lenprompt,0);		/* goto start */
		 clrline(line,0,curs);		/* and kill from pos=0 */
		 hist=curr_hist;		/* reset hist */
		 hsave=curs[0];			/* save position (make mark) */
		 vsave=curs[1];
		 for (pos=0;pos<MAXLL;pos++) line[pos]=EOS;
		 pos=possave=0;
		 break;
      case  127:
      case  8  : if (pos>0)			/* if not at home, delete */
		 {
		   if (line[pos-1]<32 || line[pos-1]==127) backward(curs);
		   backward(curs);
		   copyback(line,--pos,curs,1); /*move line back on to prev char*/
		 }
		 else write(1,beep,beeplength);		/* else ring bell */
		 break;
      case '\t': if (line[0]!=EOS)
		   complete(line,&pos,curs); /* try to complete word */
		 else write(1,beep,beeplength);
		 break;
      case '\r':				/* end of the line, go and */
      case '\n': goend(line,&pos,curs);
		 write(zout->_file,"\n",1);
		 if (feature_off) return(TRUE);
		 *nosave=strip(line);			/* process it now */
		 if (line[0]!=EOS)
		 {
		   if (O_echoline)
		   {
		     write(2,line,strlen(line));
		     write(2,"\n",1);
		   }
		   return(TRUE);
		 }
		 else return(FALSE);
      case  11 : clrline(line,pos,curs);	/* kill line from cursor on */
		 break;
      case  12 : if (feature_off) break;
		 clrscrn();			/* Clear the screen */
		 prprompt(1);			/* Reprint the prompt and */
		 show(line,curs,TRUE);		/* the line typed so far. */
		 break;
      case  14 : if (feature_off) break;
		 if (hist<curr_hist)		/* put next hist in line buf */
		   loadhist(line,&pos,++hist,curs);
		 else if (hist==curr_hist)
		      	tardis(line,&pos,curs);
		      else
			write(1,beep,beeplength);
		 break;
      case  15 : if (charfn==ptif) charfn=overwr;
		 else charfn=insert;
		 break;
      case  16 : if (feature_off) break;
		 if (hist>curr_hist-maxhist && hist>1)	/* put prev hist in line buf */
		 {
		   if (hist==curr_hist)
		     (void) savehist(line,curr_hist,maxhist);
		   loadhist(line,&pos,--hist,curs);
		 }
		 else write(1,beep,beeplength);
		 break;
      case  17 : continue;	/* can't use this */
      case  18 : /* should redisplay prompt too */
		 show(line,curs,FALSE);		/* reprint the line */
		 break;
      case  19 : continue;	/* can't use this */
      case  20 : if (pos>0 && line[pos]!=EOS)	/* if not home or at end */
		   transpose(line,pos,curs);	/* swap current and prev char */
		 else write(1,beep,beeplength);		/* else ring bell */
		 break;
      case  21 : times=0;
		 c=getc(zin);
		 while(isdigit(c))
		 {
		   times=times*10+c-48;
		   c=getc(zin);
		 }
		 times++;	/* need to add 1 because it's dec'ed */
		 break;		/* immediately at end of for loop */
      case  22 : if (pos>=MAXLL)
		 {
		   write(1,beep,beeplength);
		   continue;
		 }
		 mputc('"',zout,curs); backward(curs);	/* literal char */
		 c=getc(zin);
		 if (c)			/* don't allow EOS (null) */
		   (*charfn)(line,pos++,c,curs);
		 break;
      case  23 : if (pos) delprevword(line,&pos,curs);
		 else write(1,beep,beeplength);
		 break;
      case  24 : pos=possave;
		 go(curs,hsave,vsave);
		 break;
      case  25 : if (pos!=0)				/* if not at home */
		   yankprev(line,pos,yankbuf);		/* yank previous word */
		 else write(1,beep,beeplength);		/* else ring bell */
		 break;
      case  26 : continue;
      case  27 : switch(c=getc(zin))
		 {
		   case   4 : if (!feature_off) nameopt(line,pos,curs);
			      break;
		   case 0177:
		   case   8 : if (pos>0)
			      {
				backward(curs);
				copyback(line,--pos,curs,1);
			      }
			      else write(1,beep,beeplength);
			      break;
		   case  12 : if (feature_off) break;
			      clrscrn();
			      prprompt(1);
			      show(line,curs,TRUE);
			      break;
		   case  16 : if (feature_off) break;
			      if (hist==curr_hist)
			      {
				/* if equal then remember this line cause it's
				   the one we have to match */
				strncpy(remline,line,MAXLL-1);
				remline[MAXLL-1]=EOS;
			      }
			      try=matchhline(remline,hist);
			      if (try)
			      {
				loadhist(line,&pos,try,curs);
				hist=try;
			      }
			      else write(1,beep,beeplength);
			      break;
		   case  27 :
		   case '\t': if (!feature_off)
				if (line[0]!=EOS) complete(line,&pos,curs);
				else write(1,beep,beeplength);
			      break;
		   case 'b' : case 2:
		   case 'B' : if (pos>0) backword(line,&pos,curs);
			      else write(1,beep,beeplength);
			      break;
		   case 'd' :
		   case 'D' : if (line[pos]!=EOS) delnextword(line,pos,curs);
			      else write(1,beep,beeplength);
			      break;
		   case 'f' : case 6:
		   case 'F' : if (line[pos]!=EOS) forword(line,&pos,curs);
			      else write(1,beep,beeplength);
			      break;
		   case 'h' :
		   case 'H' : if (!feature_off) help(line,pos,curs);
			      break;
		   case 'p' :
		   case 'P' : if (pos>MAXLL-strlen(yankbuf))
			      {
				write(1,beep,beeplength);
				break;
			      }
			      for (i=0;yankbuf[i];i++)	/* insert yank buffer */
				(*charfn)(line,pos++,yankbuf[i],curs);
			      break;
		   case  25 : if (pos!=0)		/* as above */
				yankprev(line,pos,yankbuf);
			      else write(1,beep,beeplength);
			      break;
		   case 'y' :
		   case 'Y' : if (line[pos]!=EOS)	/* if not at end */
				yanknext(line,pos,yankbuf);/* yank next word */
			      else write(1,beep,beeplength);/* else ring bell */
			      break;
		   case 'w' : case 23:
		   case 'W' : if (pos)	/* if not at end */
				delprevword(line,&pos,curs);
			      else write(1,beep,beeplength);
			      break;
		   case '0':case '1':case '2':case '3':case '4':
		   case '5':case '6':case '7':case '8':case '9':
			      times=0;
			      while(isdigit(c))
			      {
				times=times*10+c-48;
				c=getc(zin);
			      }
			      times++;	/* need to add 1 because it's dec'ed */
			      break;	/* immediately at end of for loop */
		   case '/' : if (line[pos])		/* search forward */
			      {
				c=getc(zin);		/* char to search for */
				for (i=pos+1;line[i] && c!=line[i];i++);
				if (line[i])
				  while (pos<i)
				  {
				    pos++;
				    if (line[pos-1]<32 || line[pos-1]==127) forward(curs);
				    forward(curs);
				  }
				else write(1,beep,beeplength);	/* not found */
			      }
			      else write(1,beep,beeplength);/* at end of line */
			      break;
		   case '?' : if (pos>0)		/* search backwards */
			      {
				c=getc(zin);		/* char to search for */
				for (i=pos-1;i>=0 && c!=line[i];i--);
				if (i>=0)
				  while (pos>i)
				  {
				    pos--;
				    if (line[pos]<32 || line[pos-1]==127) backward(curs);
				    backward(curs);
				  }
				else write(1,beep,beeplength);	/* not found */
			      }
			      else write(1,beep,beeplength);	/* at end of line */
			      break;
		   default :  write(1,beep,beeplength);
		 }
		 break;
      case  29 : continue;
      default  : if (pos>=MAXLL-1)
		 {
		   write(1,beep,beeplength);
		   break;
		 }
		 (*charfn)(line,pos++,c,curs);
		 break;
    }
    times=1;
  }
}

