/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                                 clex.c                                    **
**     This file contains functions relevant to the command line editor      **
**      but that are not part of the editor itself. These include name       **
**      completion and option listing.  Command Line Editor eXtensions.      **
**                                                                           **
******************************************************************************/

#include "header.h"
#include <sys/stat.h>

struct candidates_2
{
  char *c_name;
  int c_mode;
};

int stopflag;

static
void setflag()
{
  stopflag=1;
}

static void colprint(csa,number,longest)
  struct candidates_2 csa[];
  int number,longest;
{
  extern int wid,fromfile;
#ifndef ATT
  struct tchars setsigc;
#endif
  int i,j,collength,numperline,index;
  char format[6];

  stopflag=0;
  signal(SIGINT,setflag);
#ifdef ATT
#else
  if (!fromfile)
  {
    if (ioctl(0,TIOCGETC,&setsigc)) perror("colprint ioctl");
    setsigc.t_intrc=3;
    if (ioctl(0,TIOCSETC,&setsigc)) perror("ioctl1 c");
  }
#endif
  longest+=2;
  numperline=wid/longest;
  collength=number/numperline;
  if (number % numperline) collength++;
  sprintf(format,"%%-%ds",longest);
  for (i=0;i<collength && !stopflag;i++)
  {
    write(1,"\n",1);
    for (j=0;j<numperline;j++)
    {
      index=i+j*collength;
      if (index>=number) break;
      if ((csa[index].c_mode & S_IFMT) == S_IFDIR) strcat(csa[index].c_name,"/");
			/* No symbolic links in Minix or SysV */
#ifdef UCB
      else if ((csa[index].c_mode & S_IFMT) == S_IFLNK) strcat(csa[index].c_name,"@");
#endif
	   else if (csa[index].c_mode & 0111) strcat(csa[index].c_name,"*");
      printf(format,csa[index].c_name);
      fflush(stdout);
    }
  }
  write(1,"\n",1);
  signal(SIGINT,SIG_IGN);
#ifdef ATT
#else
  if (!fromfile)
  {
    if (ioctl(0,TIOCGETC,&setsigc)) perror("colprint ioctl");
    setsigc.t_intrc=(UNDEF);
    if (ioctl(0,TIOCSETC,&setsigc)) perror("ioctl2 c");
  }
#endif
}

bool firstword(line,pos)
  char *line;
  int pos;
{
  int inspace=0;

  for(;;pos--)
    switch(line[pos])
    {
      case '&':case ';':case '|':			/* found a beginning */
	return(TRUE);
      case ' ':case '>':case '<':
	if (pos==0) return(TRUE);	/* it shouldn't happen but people do
						funny things sometimes */
	inspace=1;
	break;
      default:
	if (inspace) return(FALSE);		/* found another char */
	if (pos==0) return(TRUE);		/* reached start of line */
    }
}

void complete(line,pos,curs)
  char *line;
  int *pos,curs[];
{
  struct candidates
  {
    char c_name[MAXWL];
    bool c_isdir;
    struct candidates *next;
  };
  extern struct alias *atop;
  extern bool findslash(),expand_tilde();
  extern void yankprev(),goend(),prprompt(),show(),getdir();
  extern void (*charfn)(); /* it would be safer to leave this on its own! */
  extern char *vget(),beep[],*builtin_name[];
  extern int lenprompt,beeplength;
  char word[MAXWL],dir[MAXPL],path[MAXPL];	/* larger than necessary */
  FILE *pswdp,*fopen();
  DIR *dd,*opendir();
  SYM_T t,retsym();
#ifdef ATT
  struct dirent *entry,*readdir();
#else
# ifdef MINIX
  struct dirent *entry;
# else
  struct direct *entry, *readdir();
# endif
#endif
  struct candidates *start,*ptr;
  struct stat *buf;
  struct alias *aptr;
  int i=0,max,looping=1,bltin;
  char c;

  yankprev(line,*pos,word);	/* first get the thing we're trying to expand */

/* Look for a slash to see if its a relative path name or current directory.
   Then look in the right directory entry so we can see what files are there */
  if (findslash(word)==TRUE)
  {
    bltin=0;
    if (word[0]=='~')
      if (expand_tilde(word,&bltin)==FALSE)	/* converts to full path and checks failure */
      {
	prprompt(1);
	show(line,curs,TRUE);
	return;
      }
/* If it was in the metadirectory ~# then make the candidates specially */
    if (bltin)
    {
      for (i=0;word[i]!='/';i++);
      max=strlen(&word[i+1]);
      ptr=start=0;
      for (aptr=atop;aptr;aptr=aptr->next)
	if (!strncmp(&word[i+1],aptr->a_name,max))
	{
	  if (ptr!=NULL)	/* ptr==NULL iff start==NULL */
	  {
	    ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=ptr->next;
	  }
	  else
	  {
	    start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=start;
	  }
	  ptr->next=0;		/* to make sure */
	  strncpy(ptr->c_name,aptr->a_name,MAXWL);
	  ptr->c_isdir=FALSE;
	}
      for (bltin=0;builtin_name[bltin];bltin++)
	if (!strncmp(&word[i+1],builtin_name[bltin],max))
	{
	  if (start)
	  {
	    ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=ptr->next;
	  }
	  else
	  {
	    start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=start;
	  }
	  ptr->next=0;		/* to make sure */
	  strncpy(ptr->c_name,builtin_name[bltin],MAXWL);
	  ptr->c_isdir=FALSE;
	}
    }
    else
    {
      for (i=0;word[i];i++);		/* find end of word */
      for (;word[i]!='/';i--);		/* go back to final slash */
      if (i==0)				/* the directory is root */
	strcpy(dir,"/");
      else
      {
	strncpy(dir,word,i);	/* copy the dir name so we can open it */
	dir[i]=EOS;
      }
      if ((dd=opendir(dir))==NULL)
      {
	printf("\n%s%s unreadable\n",beep,dir);
	prprompt(1);
	show(line,curs,TRUE);
	return;
      }
      max=strlen(&word[i+1]);
      start=0;
      buf=(struct stat *) malloc ((unsigned)(sizeof(struct stat)));
      while ((entry=readdir(dd))!=NULL)
/* Check to see if the chars we typed match so far */
	if (!strncmp(&word[i+1],entry->d_name,max))
	{
	  if (start)
	  {
	    ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=ptr->next;
	  }
	  else
	  {
	    start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=start;
	  }
	  ptr->next=0;			/* make sure it's null */
	  strncpy(ptr->c_name,entry->d_name,MAXWL);
	  strcat(dir,"/");strcat(dir,entry->d_name);
	  stat(dir,buf);
	  if (buf->st_mode&S_IFDIR) ptr->c_isdir=TRUE;
	  else ptr->c_isdir=FALSE;
	}
      closedir(dd);
      free(buf);
    }
  }
  else /* no slash */
  {
    start=0;
    if (word[0]=='~')
    {
      if ((pswdp=fopen(PASSWD,"r"))==NULL)
      {
	printf("\n%sCan't open %s\n",beep,PASSWD);
	prprompt(1);
	show(line,curs,TRUE);
	return;
      }
      for (i=0;word[i];i++)
	word[i]=word[i+1];
      max=i-1;
      while (!feof(pswdp))
      {
	getdir(pswdp,dir);		/* use dir to store passwd entry */
/* check to see if this password entry matches chars typed so far */
	if (!strncmp(word,dir,max))
	{
	  if (start)
	  {
	    ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=ptr->next;
	  }
	  else
	  {
	    start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	    ptr=start;
	  }
	  ptr->next=0;
	  for (i=0;dir[i]!=':' && dir [i]!=EOS;i++)
	    ptr->c_name[i]=dir[i];
	  ptr->c_name[i]=EOS;
	  ptr->c_isdir=TRUE;
	}
      }
/*      close(pswdp); */
      fclose(pswdp);
    }
    else	/* not ~, search whole path */
    {
      if (firstword(line,*pos)==TRUE)
	strcpy(path,vget("PATH"));
      else strcpy(path,".");
      i=0;
      max=strlen(word);
      while ((t=retsym(path,dir,&i,FALSE))!=ENDLN)
      {
	if (!strcmp(dir,"~#"))		/* special case for ~# metadirectory */
	{
	  for (aptr=atop;aptr;aptr=aptr->next)
	    if (!strncmp(word,aptr->a_name,max))
	    {
	      if (start)
	      {
		ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
		ptr=ptr->next;
	      }
	      else
	      {
		start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
		ptr=start;
	      }
	      ptr->next=0;		/* to make sure */
	      strncpy(ptr->c_name,aptr->a_name,MAXWL);
	      ptr->c_isdir=FALSE;
	    }
	  for (bltin=0;builtin_name[bltin];bltin++)
	    if (!strncmp(word,builtin_name[bltin],max))
	    {
	      if (start)
	      {
		ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
		ptr=ptr->next;
	      }
	      else
	      {
		start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
		ptr=start;
	      }
	      ptr->next=0;		/* to make sure */
	      strncpy(ptr->c_name,builtin_name[bltin],MAXWL);
	      ptr->c_isdir=FALSE;
	    }
	  continue;		/* do next one now that ~# is taken care of */
	}
	if (t!=WORD) continue;		/* illegal path component ignored */
	if ((dd=opendir(dir))==NULL) continue;	/* same again */
	buf=(struct stat *) malloc ((unsigned)(sizeof(struct stat)));
	while ((entry=readdir(dd))!=NULL)
	/* Check to see if the chars we typed match so far */
	  if (!strncmp(word,entry->d_name,max))
	  {
	    if (start)
	    {
	      ptr->next=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	      ptr=ptr->next;
	    }
	    else
	    {
	      start=(struct candidates *) malloc ((unsigned)(sizeof(struct candidates)));
	      ptr=start;
	    }
	    ptr->next=0;		/* make sure it's null */
	    strncpy(ptr->c_name,entry->d_name,MAXWL);
	    strcat(dir,"/");strcat(dir,entry->d_name);
	    stat(dir,buf);
	    if (buf->st_mode&S_IFDIR) ptr->c_isdir=TRUE;
	    else ptr->c_isdir=FALSE;
	  }
        closedir(dd);
	free(buf);
      } /* end while retsym*/
    } /* end else ~ */
  } /* end else findslash */
  if (start)			/* have we found any ?? */
  {
/* Now we start comparing at the element c_name[max] and checking all candidates
   to see if they have the same char in this position. In this way we can expand
   until finished or there is an end to the ambiguity. */
    while (looping)
    {
      if ((c=start->c_name[max])==EOS) looping=0;
      for (ptr=start->next;ptr;ptr=ptr->next)
	if (c!=ptr->c_name[max]) break;
      if (ptr)	/* we have failed with this char if ptr isn't nil */
      {
	write(1,beep,beeplength);
	break;
      }
      if (looping) (*charfn)(line,(*pos)++,c,curs);
      else
	if (!start->next)
	  if (start->c_isdir==TRUE) (*charfn)(line,(*pos)++,'/',curs);
	  else (*charfn)(line,(*pos)++,' ',curs);
      max++;
    }
/* free up the space */
    for (ptr=start;ptr;start=ptr)
    {
      ptr=ptr->next;
      free(start);
    }
  }
  else			/* we don't have any candidates so... */
    write(1,beep,beeplength);
}

static int compare(a,b)
  struct candidates_2 *a,*b;
{
  return(strcmp(a->c_name,b->c_name));
}

/* The following function is essentially the same as the previous one except
   that the candidate list is printed out rather than used to expand the
   existing word. It would be possible to put the common code in a separate
   function but it is more efficient (fewer function calls) and more readable
   with the code in place. -C.G. */

void nameopt(line,pos,curs)
  char *line;
  int pos,curs[];
{
  extern struct alias *atop;
  extern bool findslash(),expand_tilde();
  extern void yankprev(),goend(),prprompt(),show(),getdir();
  extern int lenprompt;
  extern char *vget(),beep[],*builtin_name[];
  char word[MAXWL],dir[MAXPL],path[MAXPL],statfile[MAXPL];	/* larger than necessary */
  FILE *pswdp,*fopen();
  DIR *dd,*opendir();
  SYM_T t,retsym();
#ifdef ATT
  struct dirent *entry,*readdir();
#else
# ifdef MINIX
  struct dirent *entry;
# else
  struct direct *entry, *readdir();
# endif
#endif
  struct candidates_2 carray[MAXCAN];		/* seems a good size */
  struct stat *buf;
  struct alias *aptr;
  int i,bltin,max,index=0,maxlength=0,temp,compare();
  extern int beeplength;
  
  if ((pos==0) || (line[pos-1]==' '))
    strcpy(word,"");		/* nothing there to get */
  else
    yankprev(line,pos,word);	/* first get the thing we've got so far */

/* Look for a slash to see if its a relative path name or current directory.
   Then look in the right directory entry so we can see what files are there */
  if (findslash(word)==TRUE)
  {
    bltin=0;
    if (word[0]=='~')
      if (expand_tilde(word,&bltin)==FALSE)	/* converts to full path and checks failure */
      {
	prprompt(1);
	show(line,curs,TRUE);
	return;
      }
    if (bltin)
    {
      for (i=0;word[i]!='/';i++);
      max=strlen(&word[i+1]);
      for (aptr=atop;aptr;aptr=aptr->next)
	if (!strncmp(&word[i+1],aptr->a_name,max))
	{
	  carray[index].c_name=(char *) malloc ((unsigned)(temp=strlen(aptr->a_name)+2));
	  if (carray[index].c_name!=NULL)
	    strcpy(carray[index].c_name,aptr->a_name);
	  else
	  {
	    write(2,"\nCannot malloc memory for candidates list\n",42);
	    return;
	  }
	  if (temp>maxlength) maxlength=temp;
	  carray[index].c_mode=1;
	  index++;
	}
      for (bltin=0;builtin_name[bltin];bltin++)
	if (!strncmp(&word[i+1],builtin_name[bltin],max))
	{
	  carray[index].c_name=(char *) malloc ((unsigned)(temp=strlen(builtin_name[bltin])+2));
	  if (carray[index].c_name!=NULL)
	    strcpy(carray[index].c_name,builtin_name[bltin]);
	  else
	  {
	    write(2,"\nCannot malloc memory for candidates list\n",42);
	    return;
	  }
	  if (temp>maxlength) maxlength=temp;
	  carray[index].c_mode=1;
	  index++;
	}
    }
    else
    {
      for (i=0;word[i];i++);		/* find end of word */
      for (;word[i]!='/';i--);		/* go back to final slash */
      if (i==0)				/* the directory is root */
        strcpy(dir,"/");
      else
      {
	strncpy(dir,word,i);	/* copy the dir name so we can open it */
	dir[i]=EOS;
      }
      max=strlen(&word[i+1]);
      if ((dd=opendir(dir))==NULL)
      {
	printf("\n%s%s unreadable\n",beep,dir);
	prprompt(1);
	show(line,curs,TRUE);
	return;
      }
      buf=(struct stat *) malloc ((unsigned)(sizeof(struct stat)));
      while ((entry=readdir(dd))!=NULL)
      {
	if (entry->d_name[0]=='.' && (entry->d_name[1]=='.' || entry->d_name[1]==EOS))
	  continue;				/* ignore '.' and '..' */
/* Check to see if the chars we typed match so far */
	if (!strncmp(&word[i+1],entry->d_name,max))
	{
	  carray[index].c_name=(char *) malloc ((unsigned)(temp=strlen(entry->d_name)+2));
	  if (carray[index].c_name!=NULL)
	    strcpy(carray[index].c_name,entry->d_name);
	  else
	  {
	    write(2,"\nCannot malloc memory for candidates list\n",42);
	    return;
	  }
	  if (temp>maxlength) maxlength=temp;
	  strcpy(statfile,dir);
	  strcat(statfile,"/");strcat(statfile,entry->d_name);
#ifdef UCB
	  lstat(statfile,buf);
#else
	  stat(statfile,buf);
#endif
	  carray[index].c_mode=buf->st_mode;
	  index++;
	}
      }
      closedir(dd);
      free(buf);
    }
  }
  else	/* no slash */
  {
    if (word[0]=='~')
    {
      if ((pswdp=fopen(PASSWD,"r"))==NULL)
      {
	printf("\n%sCan't open file: %s\n",beep,PASSWD);
	prprompt(1);
	show(line,curs,TRUE);
	return;
      }
      for (i=0;word[i];i++)
	word[i]=word[i+1];
      max=i-1;				/* length of string of chars typed */
      while (!feof(pswdp))
      {
	getdir(pswdp,dir);		/* use dir to store pswd entry */
/* check to see if user password entry matches chars typed so far */
	if ((max==0) || !strncmp(word,dir,max))
	{
/* Now use path to store the actual username to go into the candidate list.
   temp is the length of the username */
	  if (index>=MAXCAN)
	  {
	    write(2,"Too many users!!\n",17);
	    break;
	  }
	  for (temp=0;dir[temp]!=':' && dir[temp]!=EOS;temp++)
	    path[temp]=dir[temp];
	  path[temp]=EOS;
	  carray[index].c_name=(char *) malloc ((unsigned)(temp+1));
	  if (carray[index].c_name!=NULL)
	    strcpy(carray[index].c_name,path);
	  else
	  {
	    write(2,"\nCannot malloc enough memory for candidates list\n",49);
	    prprompt(1);
	    show(line,curs,TRUE);
	    return;
	  }
	  if (temp>maxlength) maxlength=temp;
	  carray[index++].c_mode=0;
	}
      }
/*      close(pswdp); */
      fclose(pswdp);
    }
    else	/* not ~, search whole path */
    {
      max=strlen(word);
      if (firstword(line,pos)==TRUE)
        strcpy(path,vget("PATH"));
      else strcpy(path,".");
      i=0;
      while ((t=retsym(path,dir,&i,FALSE))!=ENDLN)
      {
	if (!strcmp(dir,"~#"))		/* special case for ~# metadirectory */
        {
	  for (aptr=atop;aptr;aptr=aptr->next)
	    if (!strncmp(word,aptr->a_name,max))
	    {
	      carray[index].c_name=(char *) malloc ((unsigned)(temp=strlen(aptr->a_name)+2));
	      if (carray[index].c_name!=NULL)
		strcpy(carray[index].c_name,aptr->a_name);
	      else
	      {
		write(2,"\nCannot malloc memory for candidates list\n",42);
		return;
	      }
	      if (temp>maxlength) maxlength=temp;
	      carray[index].c_mode=1;
	      index++;
	    }
	  for (bltin=0;builtin_name[bltin];bltin++)
	    if (!strncmp(word,builtin_name[bltin],max))
	    {
	      carray[index].c_name=(char *) malloc ((unsigned)(temp=strlen(builtin_name[bltin])+2));
	      if (carray[index].c_name!=NULL)
		strcpy(carray[index].c_name,builtin_name[bltin]);
	      else
	      {
		write(2,"\nCannot malloc memory for candidates list\n",42);
		return;
	      }
	      if (temp>maxlength) maxlength=temp;
	      carray[index].c_mode=1;
	      index++;
	    }
	  continue;		/* keep going now that ~# is taken care of */
	}
        if (t!=WORD) continue;		/* illegal path component ignored */
        if ((dd=opendir(dir))==NULL) continue;	/* same again */
        while ((entry=readdir(dd))!=NULL)
        {
	  if (entry->d_name[0]=='.' && (entry->d_name[1]=='.' || entry->d_name[1]==EOS))
	    continue;				/* ignore '.' and '..' */
	  /* Check to see if the chars we typed match so far */
	  if ((max==0) || !strncmp(word,entry->d_name,max))
	  {
	    if (index>=MAXCAN)
	    {
	      write(2,"Too many files!!\n",17);
	      break;
	    }
	    temp=strlen(entry->d_name);
	    carray[index].c_name=(char *) malloc ((unsigned)temp+1);
	    if (carray[index].c_name!=NULL)
	      strcpy(carray[index].c_name,entry->d_name);
	    else
	    {
	      write(2,"\nCannot malloc memory for candidates list\n",41);
	      prprompt(1);
	      show(line,curs,TRUE);
	      return;
	    }
	    if (temp>maxlength) maxlength=temp;
	    carray[index].c_mode=0;
	    index++;
	  }
        }
        closedir(dd);
      }
    }
  }
  if (index)			/* have we found any ?? */
  {
#ifdef __GNUC__
    qsort((char *)carray,(unsigned long)index,
    	  (unsigned long)(sizeof(struct candidates_2)),compare);
#else
    qsort((char *)carray,index,(int)(sizeof(struct candidates_2)),compare);
#endif
    colprint(carray,index,maxlength);
/* free up the space */
    for (index--;index>=0;index--)
      free(carray[index].c_name);
    prprompt(1);
    show(line,curs,TRUE);
  }
  else			/* we don't have any candidates so... */
    write(1,beep,beeplength);
}
