/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/*****************************************************************************
**                                                                          **
**                             builtin2.c                                   **
**   This file contains the support stuff for builtin functions and other   **
**   builtins that made the original file too big.                          **
**                                                                          **
*****************************************************************************/

#include "header.h"
#define ALL -1
#define AMBIG -2

#ifdef UCB
static int whichres(resname)
  char *resname;
{
  int len;

  len=strlen(resname);
  if (!len) return(ALL);
  if (!strncmp("filesize",resname,len)) return(RLIMIT_FSIZE);
  if (!strncmp("datasize",resname,len)) return(RLIMIT_DATA);
  if (!strncmp("stacksize",resname,len)) return(RLIMIT_STACK);
  if (!strncmp("memoryuse",resname,len)) return(RLIMIT_RSS);
  if (len==1 && *resname=='c') return(AMBIG);	/* yes, this is silly */
  if (!strncmp("coredumpsize",resname,len)) return(RLIMIT_CORE);
  if (!strncmp("cputime",resname,len)) return(RLIMIT_CPU);
  return(RLIM_NLIMITS);
}
void printlimit(limname)
  char *limname;
{
  struct rlimit rs;
  int res,jumpout;

  res=whichres(limname);
  switch(res)
  {
    case AMBIG:
      printf("Ambiguous resource name.\n");
      return;
    case ALL:
    case RLIMIT_CPU:
      if (res!=ALL) break;
    case RLIMIT_FSIZE:
      if (res!=ALL) break;
    case RLIMIT_DATA:
      if (res!=ALL) break;
    case RLIMIT_STACK:
      if (res!=ALL) break;
    case RLIMIT_RSS:
      break;
    case RLIM_NLIMITS:
      printf("No such resource: %s\n",limname);
      return;
    default:
      fprintf(stderr,"Looney with a stick in printlimit()!!\n");
      exit(1);
  }
}

void setlimit(limname,limval)
  char *limname,*limval;
{
}
#endif

int getnextword(line,pos,word)
  char *line,*word;
  int *pos;
{
  int i=0,inword=0,quote=0;

#ifdef DEBUG
fprintf(stderr,"In getnextword pos %d\n",*pos);
#endif
  while (1)
  {
    switch (line[*pos])
    {
      case EOS: word[i]=EOS;
#ifdef DEBUG
fprintf(stderr,"EOS\n");
#endif
		if (i) return(1);
		return(0);
      case ' ': if (quote) word[i++]=line[(*pos)++];
		else
		{
		  if (inword)
		  {
		    (*pos)++;
		    word[i]=EOS;
#ifdef DEBUG
fprintf(stderr,"space\n");
#endif
		    return(1);
		  }
		  else (*pos++);
		}
		break;
      case '"': quote=1-quote;		/* only " in read statement allowed */
		(*pos)++;
		break;
      case '\\':(*pos++);		/* only needed for quoting space or " */
		if (line[*pos])
		  word[i++]=line[(*pos)++];
		else			/* can't quote eos */
		{
		  word[i++]='\\';word[i]=EOS;	/* so put the \ there */
		  return(1);
		}
		break;
      default : inword=1;
#ifdef DEBUG
fprintf(stderr,"c %c\n",line[*pos]);
#endif
		word[i++]=line[(*pos)++];
		break;
    }
  }
}

int convert(string)
  char *string;
{
  if (!strcmp(string,"HUP")) return(1);
  if (!strcmp(string,"INT")) return(2);
  if (!strcmp(string,"QUIT")) return(3);
  if (!strcmp(string,"ILL")) return(4);
  if (!strcmp(string,"TRAP")) return(5);
  if (!strcmp(string,"IOT")) return(6);
  if (!strcmp(string,"EMT")) return(7);
  if (!strcmp(string,"FPE")) return(8);
  if (!strcmp(string,"KILL")) return(9);
  if (!strcmp(string,"BUS")) return(10);
  if (!strcmp(string,"SEGV")) return(11);
  if (!strcmp(string,"SYS")) return(12);
  if (!strcmp(string,"PIPE")) return(13);
  if (!strcmp(string,"ALRM")) return(14);
  if (!strcmp(string,"TERM")) return(15);
  if (!strcmp(string,"URG")) return(16);
  if (!strcmp(string,"STOP")) return(17);
  if (!strcmp(string,"TSTP")) return(18);
  if (!strcmp(string,"CONT")) return(19);
  if (!strcmp(string,"CHLD")) return(20);
  if (!strcmp(string,"TTIN")) return(21);
  if (!strcmp(string,"TTOU")) return(22);
  if (!strcmp(string,"IO")) return(23);
  if (!strcmp(string,"XCPU")) return(24);
  if (!strcmp(string,"XFSZ")) return(25);
  if (!strcmp(string,"VTALRM")) return(26);
  if (!strcmp(string,"PROF")) return(27);
  return(SIGTERM);
}

void editalias(aname)
  char *aname;
{
  extern struct adefn *checkalias();
  extern void makealias(),resetsigdefaults();
#ifdef HASH
  extern void hashpath();
  extern bool hashed;
#endif
#ifdef JOB
  extern int addjob();
  extern void checkjobs();
#endif
  extern int waitfor();
  struct adefn *defn_top,*dptr;
  FILE *fp;
  char file[MAXFNL],editor[MAXPL];
  int pid;

  /* call editor etc and load up alias from temp file */
  pid=getpid();
  sprintf(file,"/tmp/alias%d",pid);
  if (defn_top=checkalias(aname))
  {
#ifdef DEBUG
fprintf(stderr,"Reloading old alias\n");
#endif
    if ((fp=fopen(file,"w"))==NULL)
    {
      write(2,"Can't create temporary file.\n",29);
      return;
    }
    for (dptr=defn_top;dptr;dptr=dptr->nextln)
      fprintf(fp,"%s\n",dptr->a_line);
    fclose(fp);
  }
  if (getenv("EDITOR"))
    strcpy(editor,getenv("EDITOR"));
  else
    strcpy(editor,DFLTED);
#ifdef UCB
  signal(SIGCHLD,SIG_IGN);
#endif
#ifdef DEBUG
fprintf(stderr,"editor is %s<\n",editor);
#endif
  switch(pid=fork())
  {
    case -1 : write(2,"Fork failure.\n",14);
	      return;
    case 0  : resetsigdefaults();
	      execl(editor,editor,file,0);
	      perror("execl");
	      exit(1);
    default :
#ifdef JOB
              (void) addjob(pid,editor,1,FALSE);
#endif
	      (void) waitfor(pid);
  }
#ifdef JOB
  signal(SIGCHLD,checkjobs);
#endif
  if ((fp=fopen(file,"r"))!=NULL)
  {
#ifdef DEBUG
fprintf(stderr,"Making alias. errno %d\n",errno);
#endif
    makealias(aname,fp);
    fclose(fp);
    if (unlink(file))
      write(2,"Can't remove temporary file\n",28);
#ifdef HASH
    if (hashed==TRUE) hashpath();
#endif
  }
  else fprintf(stderr,"Can't reopen file: %s\n",file);
}
