/*****************************************************************************
**                                                                          **
**          The Clam Shell is Copyright (C) 1988 by Callum Gibson.          **
**       This file is part of Clam Shell. You may freely use, copy and      **
**     distribute it, but if you alter any source code do not distribute    **
**   the altered copy. i.e. you may alter this file for your own use only.  **
**                                                                          **
*****************************************************************************/
/******************************************************************************
**                                                                           **
**                               alias.c                                     **
**     This file contains functions relevant to aliases, including creation  **
**     in two ways, listing, interpreting. Aliases are in the metadirectory  **
**     ~# and are searched (and hashed if being used) before the builtins.   **
**                                                                           **
*******************************************************************************/

#include "header.h"

struct alias *atop=NULL;

struct adefn *checkalias(aname)
  char *aname;
{
  struct alias *aptr;
  int lex;

/* Aliases are stored in alphabetical order. We exit the loop as soon as
   we've passed the spot it can be in. If found, return definition pointer */

  for (aptr=atop;aptr;aptr=aptr->next)
    if ((lex=strcmp(aname,aptr->a_name))==0)
      return(aptr->defin);
    else if (lex<0)
	   return(0);
  return(0);
}

void aliaslist(aname)
  char *aname;
{
  extern void mprint();
  struct alias *aptr;
  struct adefn *dptr;

  if (aname!=NULL)
  {
    struct adefn *d_top;
    /* single alias definition */
    d_top=NULL;
    d_top=checkalias(aname);
    if (d_top!=NULL)
      for (dptr=d_top;dptr!=NULL;dptr=dptr->nextln)
	mprint(dptr->a_line,0);
    else write(2,"No such alias.\n",15);
    return;
  }
  for (aptr=atop;aptr;aptr=aptr->next)
  {
    mprint(aptr->a_name,1);
    for (dptr=aptr->defin;dptr;dptr=dptr->nextln)
    {
      write(1,"\t",1);
      mprint(dptr->a_line,0);
    }
  }
}

void savealias(aname,fp)
  char *aname;
  FILE *fp;
{
  struct alias *aptr;
  struct adefn *dptr;

  for (aptr=atop;aptr;aptr=aptr->next)
    if (!strcmp(aname,aptr->a_name))
      for (dptr=aptr->defin;dptr;dptr=dptr->nextln)
	fprintf(fp,"%s\n",dptr->a_line);
}

void addalias(aname,stdefn)
  char *aname;
  struct adefn *stdefn;
{
  struct alias *aptr,*old,*new;
  struct adefn *dptr,*d;
  int i,lex=(-1);

#ifdef DEBUG
fprintf(stderr,"In addalias\n");
#endif
/* search from top of list until we get to the point that is greater than or
   equal to the alias name. i is 0 if aname less than all. Set lex to -1 in
   case loop never executes and we make the first one. */

  for (i=0,old=aptr=atop;aptr;i++,old=aptr,aptr=aptr->next)
    if ((lex=strcmp(aname,aptr->a_name))==0)
      break;
    else if (lex<0)
	 break;

#ifdef DEBUG
fprintf(stderr,"out of alias search loop\n");
#endif
  if (lex<0)
    if (i)		/* normal insertion between old and aptr */
    {
      new=(struct alias *) malloc ((unsigned)(sizeof(struct alias)));
      if (new==NULL)
      {
	perror("addalias: malloc1");
	return;
      }
      old->next=new;			/* insert the new alias node */
      new->next=aptr;
      new->defin=stdefn;		/* point at new definition */
      new->a_name=(char *) malloc ((unsigned)(strlen(aname)+1));
      if (new->a_name==NULL)
      {
	perror("addalias: malloc2");
	return;
      }
      strcpy(new->a_name,aname);
    }
    else		/* insertion before atop. old=aptr=atop still */
    {
      old=(struct alias *) malloc ((unsigned)(sizeof(struct alias)));
      if (old==NULL)
      {
	perror("addalias: malloc3");
	return;
      }
      old->next=atop;
      old->a_name=(char *) malloc ((unsigned)(strlen(aname)+1));
      if (old->a_name==NULL)
      {
	perror("addalias: malloc4");
	return;
      }
      strcpy(old->a_name,aname);
      old->defin=stdefn;
      atop=old;
    }
  else
    if (lex==0)		/* alias already exists, just change definition */
    {
      for (dptr=aptr->defin;dptr;dptr=d)
      {
	d=dptr->nextln;
	free(dptr->a_line);
	free(dptr);
      }
      aptr->defin=stdefn;
    }
    else		/* alias doesn't exist, append to list. */
    {
      new=(struct alias *) malloc ((unsigned)(sizeof(struct alias)));
      if (new==NULL)
      {
	perror("addalias: malloc5");
	return;
      }
      new->next=0;
      old->next=new;
      new->a_name=(char *) malloc ((unsigned)(strlen(aname)+1));
      if (new->a_name==NULL)
      {
	perror("addalias: malloc6");
	return;
      }
      strcpy(new->a_name,aname);
      new->defin=stdefn;
    }
#ifdef DEBUG
fprintf(stderr,"finished addalias\n");
#endif
}

void makelinealias(aname,aline)
  char *aname,*aline;
{
  struct adefn *ptr;

#ifdef DEBUG
fprintf(stderr,"In makelinealias\n");
#endif
  ptr=(struct adefn *) malloc ((unsigned)(sizeof(struct adefn)));
  if (ptr==NULL)
  {
    perror("makelinealias: malloc1");
    return;
  }
  ptr->a_line=(char *) malloc ((unsigned)(strlen(aline)+1));
  if (ptr->a_line==NULL)
  {
    perror("makelinealias: malloc2");
    return;
  }
  strcpy(ptr->a_line,aline);
  ptr->nextln=0;
  addalias(aname,ptr);
#ifdef DEBUG
fprintf(stderr,"finished makelinealias\n");
#endif
}

void makealias(aname,fp)
  char *aname;
  FILE *fp;
{
  struct adefn *defn_top,*dptr;
  char line[MAXLL];
  int i;

#ifdef DEBUG
fprintf(stderr,"In makealias\n");
#endif
  dptr=defn_top=NULL;
  while (!feof(fp))
  {
    for (i=0;i<MAXLL;i++) line[i]=EOS;
    if (getfileline(line,fp,1))		/* nostrip is set */
    {
#ifdef DEBUG
fprintf(stderr,"alias line:\n%s<<-\n",line);
#endif
      if (dptr!=NULL)	/* dptr==NULL iff defn_top==NULL */
      {
	dptr->nextln=(struct adefn *) malloc ((unsigned)(sizeof(struct adefn)));
	dptr=dptr->nextln;
      }
      else
      {
	defn_top=(struct adefn *) malloc ((unsigned)(sizeof(struct adefn)));
	dptr=defn_top;
      }
      dptr->a_line=(char *) malloc ((unsigned)(strlen(line)+1));
      strcpy(dptr->a_line,line);
    }
  }
  if (dptr!=NULL) dptr->nextln=NULL;
  addalias(aname,defn_top);
}

void delalias(aname)
  char *aname;
{
  struct alias *ptr,*old;
  struct adefn *dpt1,*dpt2;
  int i,lex;

  for (i=0,old=ptr=atop;ptr;i++,old=ptr,ptr=ptr->next)
    if ((lex=strcmp(aname,ptr->a_name))==0)
      if (i)
      {
	for (dpt1=dpt2=ptr->defin;dpt2;dpt1=dpt2)
	{
	  dpt2=dpt2->nextln;
	  free(dpt1->a_line);
	  free(dpt1);
	}
	old->next=ptr->next;
	free(ptr->a_name);
	free(ptr);
	return;
      }
      else
      {
	atop=atop->next;
	free(ptr->a_name);
	free(ptr);
	return;
      }
    else if (lex<0)
	   break;
  fprintf(stderr,"No such alias : %s\n",aname);
}
