#


#include "xmp.h"
#include "protect.h"

! Trampoline limits (AP initalization)

.define _init_ap
.define _end_init_ap


! Usable functions

.define _phys_copy_dword
.define	_copy_registers_to_trampoline
.define _f_this_cpu
.define _lock_mp_kernel
.define _unlock_mp_kernel
.define _mp_switching_lock
.define _mp_switching_unlock
.define _mp_switching_islocked
.define _mp_heldq_lock
.define _mp_heldq_unlock
.define _mp_IPI
.define _enable_cache
.define _disable_cache
.define _halt

! Variables
.extern k_stktop
.extern _ap_main
.extern _k_main_lock
.extern _mp_IPI_c

.sect	.text;	
.align 4


!*===========================================================================*
!*				phys_copy_dword				     *
!*===========================================================================*
! PUBLIC void phys_copy_dword(phys_bytes source, phys_bytes destination);
! Copy a block of physical memory.
PC_ARGS	=	4 + 4 + 4 + 4	! 4 + 4 
!		es edi esi eip	 src dst

	.align	16
_phys_copy_dword:
	cld
	push	esi
	push	edi
	push	ds

	mov	eax, FLAT_DS_SELECTOR
	mov	ds, ax

	mov	eax, PC_ARGS(esp)	! src
	mov	ebx, PC_ARGS+4(esp)	! dst

	mov	edx, (eax)
	mov	(ebx), edx

	pop	ds
	pop	edi
	pop	esi
	ret





!*===========================================================================*
!*				init_ap		                             *
!*===========================================================================*
! This is the entry point for second processor (AP) to start executing 
! (the linux trampoline)
! At this point, we are in 16-bit real mode, with no stack
! ip register is 0
! cs points to something like 000xx000h
! ds is unusable due to code relocation from where assembler links to 
!    somewhere like 000xx000h
!
! Actions:
! 1. Mark data area to tell the BSP we are running in real mode
! 2. Read values of many registers to prepare environment to jump
!    into protected mode in same conditions as BSP
! 3. Change to protected mode
! 4. Jump to protected mode trampoline section
!
! NOTE that this code MUST be assembled as 16-bit
! Using C16 (o16+a16) marks, we force the assember to generate 16-bit
!   instructions, but it introduces operand-size modifiers machine code
!   (bytes 66h and 67h before each instruction) because when in 32-bit 
!   protected mode, 66h & 67h force the cpu to interpret next instruction 
!   as 16-bit. But when in 16-bit real mode, 66h & 67h force the cpu to 
!   execute next instruction as 32-bit. So we need to delete these marks from
!   trampoline code. As trampoline must be relocated to an address 
!   4Kb-page-aligned, then the marks must be replaced by <nop> code (90h)
!
.sect .data
.align	16

#define C16		o16 a16

_init_ap:
	C16	jmp	_skip_data
_data_area:				! Space for variables
_gdtr_data:	.data2	0x0000		!   gdt limit
		.data4	0x00000000	!       addr
_idtr_data:	.data2	0x0000		!   idt limit
		.data4  0x00000000	!       addr
_esi_data:	.data4	0x00000000	!   esi
_edi_data:	.data4	0x00000000	!   edi
_ebp_data:	.data4	0x00000000	!   ebp
_skip_data:
	! Mark life_flag to tell BSP we are running
	C16	cli			! safe from interrupts
	C16	mov	ax,	cs
	C16	mov	ds,	ax	! ds= cs (_init_ap)

	! Prepare environment to jump into protected mode
	C16	lgdt	( [ TR_GDTR_OFFSET ] )
	C16	lidt	( [ TR_IDTR_OFFSET ] )

	! Into protected mode
		mov	eax,	cr0
		orb	al,	1
		mov	cr0,	eax
	! Far jmp to start with 32 bit execution.
	! Jump to a .text CS-addressed point
	C16	jmpf	CS_SELECTOR:_trampoline_pm
_end_init_ap:
	hlt




.sect .text
.align 16

#define wbinv	.data1 0x0F, 0x09

!*===========================================================================*
!*				enable_cahe	                             *
!*===========================================================================*
! Enable cache on current cpu
_enable_cache:
		mov	ax,	cr0
		and	ax,	0x9FFFFFFF	! 100111111111...111
		mov	cr0,	ax
		wbinv
		ret

!*===========================================================================*
!*				disable_cahe	                             *
!*===========================================================================*
! Disable cache on current cpu
_disable_cache:
		wbinv
		mov	ax,	cr0
		or	ax,	0x60000000	! 01100000000....000
		mov	cr0,	ax
		ret


!*===========================================================================*
!*				trampoline_pm	                             *
!*===========================================================================*
! This is the protected mode section of the trampoline 
! Load apropiate values into registers and jump to
!    ap_main c function to start execution 
_trampoline_pm:
	! We are in protected mode. Load AP registers as in BSP
		mov	ax,	DS_SELECTOR
		mov	ds,	ax		! load DS
		mov	ss,	ax		! load SS
		mov	es,	ax		! load ES
		mov	fs,	ax		! load FS
		mov	gs,	ax		! load GS
		mov	eax,	( _esi_data )
		mov	esi,	eax		! load ESI
		mov	eax,	( _edi_data )
		mov	edi,	eax		! load EDI
		mov	eax,	( _ebp_data )
		mov	ebp,	eax		! load EBP
	! Load TSS of this ap
		THIS_CPU(eax)
		dec	eax			! AP# less 1
		shl	eax,	3		! mult DESC_SIZE
		add	eax,	TSS_FIRST_AP_SELECTOR
		ltr	ax			! load TSS
	! Now we are ready to address as usual and execute normal
	! kernel code, so, lets go
	! Each CPU needs its own stack space inside kernel stack
	! Make esp point to cpus stack top
		THIS_CPU(eax)
		SET_CPU_STK(eax)
	! Enable AP cache
		call	_enable_cache
	! Continue in C code
		call	_ap_main
hlt





!*===========================================================================*
!*			copy_registers_to_trampoline		             *
!*===========================================================================*
! Copy the contents of gdtr, idtr and 32-bit specific registers into 
!   the trampoline data area so that trampoline can after read them 
!   from its relocation

_copy_registers_to_trampoline:
	! Copy gdt and idt
		sgdt	(_gdtr_data)
		sidt	(_idtr_data)
	! Copy 32-bit regsiters
		mov	eax,	esi
		mov	(_esi_data),	eax
		mov	eax,	edi
		mov	(_edi_data),	eax
		mov	eax,	ebp
		mov	(_ebp_data),	eax
		ret



!*===========================================================================*
!*				f_this_cpu				     *
!*===========================================================================*
! Returns APIC id of curret cpu (0..n-1)
_f_this_cpu:
	o16	push	ds
		push	edx
		THIS_CPU_SHORT(eax)
		pop	edx
	o16	pop	ds
		ret



!*===========================================================================*
!*				lock_mp_kernel				     *
!*===========================================================================*
! This is the same that use the assembler macro MP_LOCK(k_main_lock)
!    but callable from C code

_lock_mp_kernel:
	MP_LOCK(_k_main_lock)
	ret



!*===========================================================================*
!*				unlock_mp_kernel			     *
!*===========================================================================*
! This is the same that use the assembler macro MP_UNLOCK(k_main_lock)
!    but callable from C code
_unlock_mp_kernel:
	MP_UNLOCK(_k_main_lock)
	ret




!*===========================================================================*
!*				mp_switching_lock			     *
!*===========================================================================*
! locks a multiprocessor-safe semaphore for switching jobs
.sect	.data
.align	4
switching_data:	.data4	MP_LOCK_FREEVAL
.sect	.text

_mp_switching_lock:
	MP_LOCK(switching_data)
	ret


!*===========================================================================*
!*				mp_switching_unlock			     *
!*===========================================================================*
! unlocks a multiprocessor-safe semaphore for switching jobs

_mp_switching_unlock:
	MP_UNLOCK(switching_data)
	ret



!*===========================================================================*
!*				mp_heldq_lock				     *
!*===========================================================================*
! locks a multiprocessor-safe semaphore for handling held process queue
.sect	.data
.align	4
held_data:	.data4	MP_LOCK_FREEVAL
.sect	.text

_mp_heldq_lock:
	MP_LOCK(held_data)
	ret


!*===========================================================================*
!*				mp_heldq_unlock				     *
!*===========================================================================*
! unlocks a multiprocessor-safe semaphore for handling held process queue

_mp_heldq_unlock:
	MP_UNLOCK(held_data)
	ret



!*===========================================================================*
!*				mp_switching_islocked			     *
!*===========================================================================*
! Tell is switching lock is locked or not

_mp_switching_islocked:
	mov	eax,	(switching_data)
	xor	eax,	MP_LOCK_FREEVAL
	ret





!*===========================================================================*
!*					mp_IPI				     *
!*===========================================================================*
! Entry point of Interprocessor Interrupts. This is an interrupt handler
! that call the C version of the handler

.align 16
_mp_IPI:
	call	save			/* save interrupted process state */
	sti 				/* enable interrupts		  */
	call	_mp_IPI_c		/* run C code of handler	  */
	cli				/* disable interrupts		  */
	ret				/* restart (another) process      */



!*===========================================================================*
!*					halt				     *
!*===========================================================================*
! Stop execution of a CPU

.align 16
_halt:
	cli
	hlt
	jmp _halt




