#

#ifndef XMP_H
#define XMP_H


#include <minix/config.h>
#include <minix/const.h>
#include "const.h"

/****************************************************************/
/* Constants of trampoline management                           */
/****************************************************************/

/* Offsets from trampoline start to data areas */
#define TR_GDTR_OFFSET		_gdtr_data - _init_ap
#define TR_IDTR_OFFSET		_idtr_data - _init_ap

#define AP_LIFE_FLAG_MARK	0xCCCC


/****************************************************************/
/* Macro definitions for kernel stack management		*/
/****************************************************************/




#define	K_STACK_BYTES_SH	10	/* log2 K_STACK_BYTES */
					/* K_STACK_BYTES MUST BE POWER OF 2 */

#if (K_STACK_BYTES != (1<<K_STACK_BYTES_SH))
#error "ERROR: K_STACK_BYTES_SH is not log2(K_STACK_BYTES)"
#endif

/* This secuence sets kernel stack to the top of kernel stack
   depending of current cpu number stored in <reg>
   Registers <reg>, EDX, ESP are afected
   <reg> can be EAX, EBX, ECX */

#define SET_CPU_STK(reg)				;\
		shl	reg,	K_STACK_BYTES_SH	;\
		mov	edx,	k_stktop		;\
		sub	edx,	reg			;\
		mov	esp,	edx



/* This secuence provides in <reg> current cpu number from 0 to n-1
   Registers <reg>, EDX, DS are afected 
   SHORT version does not restores DS_SELECTOR in DS 
   <reg> can be EAX, EBX, ECX */

#define THIS_CPU_SHORT(reg)				;\
		mov	edx,	(_local_apic_base)	;\
		add	edx,	0x20			;\
		mov	reg,	FLAT_DS_SELECTOR	;\
		mov	ds,	reg			;\
		mov	reg,	(edx)			;\
		and	reg,	0x0F000000		;\
		shr	reg,	6*4



#define THIS_CPU(reg) 					;\
		THIS_CPU_SHORT(reg)			;\
		mov	edx,	DS_SELECTOR		;\
		mov	ds,	dx




/* If MP is not enabled, cpu# is 0, else it's neccessary ask the APIC */
#if (ENABLE_MP == 1) 
#define this_cpu	 f_this_cpu()
#else
#define this_cpu	 0
#endif

/* This code defines semaphores safe from parallel access
   To lock we need a semaphore variable and a label id (unique)
   To unlock we need the semaphore variable
   A semaphore variable is a data (>=1byte) dobleword aligned */

#define MP_LOCK_FREEVAL		0 

#if ( ENABLE_MP == 1 ) 

#define MP_LOCK(semaphore_var)				;\
0:		clc					;\
	lock	bts	(semaphore_var),	0	;\
		jnc	2f				;\
1:		cmp	(semaphore_var),MP_LOCK_FREEVAL	;\
		jne	1b				;\
		jmp	0b				;\
2:		

#define MP_UNLOCK(semaphore_var)			;\
	lock	btr	(semaphore_var),	0	


#else



#define MP_LOCK(semaphore_var)				;\
		mov	(semaphore_var),	1

#define MP_UNLOCK(semaphore_var)			;\
		mov	(semaphore_var),	0	

#endif



#endif
