/* Definitions of MP table and Floating Pointer Structure 
   From Intel MP 1.4 specification */


#define SIGN_FPS        "_MP_"   /* MP signature of floating pointer struct */
#define FP_IMCRP_MASK   128

/* Describes a FPS (floating pointer structure) */

struct floating_pointer {
  char	 fp_signature[4];	/* must be _MP_ */
  u32_t  fp_mp_table;		/* address to MP table */
  u8_t   fp_length;		/* FPS size in 16-byte parragraphs */
  u8_t   fp_version;		/* version number: 04h for 1.4 */
  u8_t   fp_cheksum;		/* bytes in FPS must sum 0 */
  u8_t   fp_sd_config_num;	/* standar config number (0 for none) */
  u8_t   fp_imcrp;		/* bit 7 is IMCR present and PIC mode */
  char   unused[3];		/* last 3 bytes are reserved */
};


#define SIGN_MP_C_HEADER  "PCMP"    /* signature for MP config table */


/* Describes the estruct of MP configuration table header */
struct mp_config_header {
   char  mpch_signature[4];        /* must be "PCMP" */
   u16_t mpch_length;              /* base table size including header */
   u8_t  mpch_version;             /* MP specification version number*/
   u8_t  mpch_checksum;            /* base table + checksum must sum 0 */
   char  mpch_oem_id[8];           /* manufacturer id (space filled) */
   char  mpch_product_id[12];      /* product id (space filled) */
   u32_t mpch_oem_table;           /* optional manufacturer table address */
   u16_t mpch_oem_table_size;      /* manufacturer table size */
   u16_t mpch_entry_count;         /* entry count in MP table */
   u32_t mpch_apic_addr;           /* IO address for local APIC */
   u16_t mpch_extended_length;     /* extended table length */
   u8_t  mpch_extended_checksum;   /* extended table checksum */
   char  mpch_reserved;            /* unused */
};





/* describes struct of a PROCESSOR entry type */
#define CPU_ENTRY_ID     0
#define CE_EN_FLAG_MASK  1
#define CE_BP_FLAG_MASK  2

struct cpu_entry {
   u8_t  ce_type;               /* 0 for this type */
   u8_t  ce_local_apic_id;      /* local APIC id number */
   u8_t  ce_local_apic_ver;     /* local APIC version */
   u8_t  ce_flags;              /* CPU enabled and CPU is bootstrap */
   u32_t ce_signature;          /* CPU type */
   u32_t ce_features;           /* features of this CPU */
   char  reserved[8];           /* reserved */
};





/* indentifies CPU type masking ce_signature field of a cpu_entry struct */

#define CPU_SIGN_STEPING_MASK  0x0000000F
#define CPU_SIGN_MODEL_MASK    0x000000F0
#define CPU_SIGN_FAMILY_MASK   0x00000F00
#define CPU_SIGN_MASK          CPU_SIGN_MODEL_MASK | CPU_SIGN_FAMILY_MASK

#define INVALID_CPU(signature)  (((signature & 0x00000FFF) == 0) ||         \
                                 ((signature & 0x00000FFF) == 0xFFF))

/* masking ce_signature with CPU_SIGN_MASK we can identify CPU type */
#define CPU_486DX      0x00000400
#define CPU_486DX_     0x00000410
#define CPU_486SX      0x00000420
#define CPU_487        0x00000430
#define CPU_DX2        0x00000430
#define CPU_486SL      0x00000440
#define CPU_SX2        0x00000450
#define CPU_DX4        0x00000480
#define CPU_P510_567   0x00000510
#define CPU_P735_815   0x00000520


/* masks bits of ce_featrues field of a cpu_entry struct */

#define CPU_FPU_MASK     1
#define CPU_MCE_MASK   128
#define CPU_CX8_MASK   256
#define CPU_ONCHIP_APIC_MASK  512

/* describes struct of a BUS entry type */
#define BUS_ENTRY_ID  1

struct bus_entry {
   u8_t be_type;               /* 1 for this type */
   u8_t be_id;                 /* BUS type ID */
   char be_type_str[6];        /* manufacturer's description */
};


/* describes struct of a I/O APIC entry type */
#define IO_APIC_ENTRY_ID  2
#define AE_EN_FLAG_MASK   1

struct io_apic_entry {
   u8_t ae_type;               /* 2 for this type */
   u8_t ae_id;                 /* IO APIC identification */
   u8_t ae_version;            /* IO APIC version number */
   u8_t ae_flags;              /* bit 0 means enabled */
   u32_t ae_address;           /* IO APIC memory address */
};



/* describes struct of a I/O INTERRUPT ASSING entry type */
#define IO_INT_ENTRY_ID  3
#define IE_PO_FLAG_MASK  3
#define IE_EL_FLAG_MASK  12

#define PO_BUS           0
#define PO_HIGH          1
#define PO_LOW           3

#define EL_BUS           0
#define EL_EDGE          1
#define EL_LEVEL         3

#define INT_INT          0
#define INT_NMI          1
#define INT_SMI          2
#define INT_EXTINT       3

struct io_int_entry {
   u8_t ie_type;               /* 3 for this type */
   u8_t ie_int_type;           /* iinterupt type */
   u16_t ie_flags;             /* bits 0-1 are PO and 2-3 are EL */
   u8_t ie_bus_id;             /* source bus */
   u8_t ie_bus_irq;            /* IRQ in source bus */
   u8_t ie_apic_id;            /* destination I/O APIC */
   u8_t ie_apic_int;           /* INTN in destination I/O APIC */
};



/* describes struct of a LOCAL INTERRUPT ASSING entry type */
#define LOCAL_INT_ENTRY_ID  4
#define LIE_PO_FLAG_MASK    3
#define LIE_EL_FLAG_MASK    12


struct l_int_entry {
   u8_t lie_type;               /* 4 for type type */
   u8_t lie_int_type;           /* interrupt type */
   u16_t lie_flags;             /* bits 0-1 are PO and 2-3 are EL */
   u8_t lie_bus_id;             /* source bus */
   u8_t lie_bus_irq;            /* IRQ in source bus */
   u8_t lie_apic_id;            /* destination local APIC */
   u8_t lie_apic_int;           /* INTN in destination local APIC */
};






