
/************************************************************/
/* Print Floaing Pointer Structure information		    */
/************************************************************/

void print_fps_info(void){
   ADDS_MP_STATUS("\tMP specification version ");
   ADDN_MP_STATUS(fps.fp_version / 16 +1, 10, 0);
   ADDS_MP_STATUS(".");
   ADDN_MP_STATUS(fps.fp_version % 16, 10, 0);
   ADDS_MP_STATUS("\n\tStandard MP configuration ");
   ADDN_MP_STATUS(fps.fp_sd_config_num, 10, 0);
   if (! fps.fp_sd_config_num) 
	ADDS_MP_STATUS(" (custom config)");
   ADDS_MP_STATUS("\n\tIMCR&PIC mode ");
   if (!(fps.fp_imcrp & FP_IMCRP_MASK)) 
	ADDS_MP_STATUS("not ");
   ADDS_MP_STATUS("present\n");
   ADDS_MP_STATUS("\tMP config table at 0x");
   ADDN_MP_STATUS(fps.fp_mp_table,16,0);
   ADDS_MP_STATUS("\n");
}



/************************************************************/
/* Print MP table information				    */
/************************************************************/

void print_mp_configuration(void) {
   char buffer[13];
   int i;

   ADDS_MP_STATUS("\tMP especification version ");
   ADDN_MP_STATUS(mph.mpch_version / 16 +1, 10,0);
   ADDS_MP_STATUS(".");
   ADDN_MP_STATUS(mph.mpch_version % 16, 10,0);
   ADDS_MP_STATUS("\n\tOEM signarute ");
   for (i=0; i<8; i++) buffer[i]=mph.mpch_oem_id[i];
   buffer[i]=0;
   ADDS_MP_STATUS(buffer);
   ADDS_MP_STATUS(" product ID ");
   for (i=0; i<12; i++) buffer[i]=mph.mpch_product_id[i];
   buffer[i]=0;
   ADDS_MP_STATUS(buffer);
   ADDS_MP_STATUS("\n\tLocal APIC mem address: 0x");
   ADDN_MP_STATUS(mph.mpch_apic_addr, 16, 8);
   ADDS_MP_STATUS("\n\tMP table entry count: ");
   ADDN_MP_STATUS(mph.mpch_entry_count, 10, 0);
   ADDS_MP_STATUS("\n");
}






/************************************************************/
/* Print I/O APIC information				    */
/************************************************************/

void show_io_apic_info(void) {
   u32_t val;
   int i;

   ADDS_MP_STATUS("I/O APIC id");
   ADDN_MP_STATUS((IO_APIC_READ(IO_APIC_ID_REG) & IOA_ID_MASK)
                  >>IOA_ID_SHIFT, 10,0);
   ADDS_MP_STATUS(" version ");
   ADDN_MP_STATUS(((val=IO_APIC_READ(IO_APIC_VERSION_REG)) & IOA_VER_MASK)
                  >>IOA_VER_SHIFT, 10,0);
   ADDS_MP_STATUS(", ");
   ADDN_MP_STATUS((val & IOA_MXENT_MASK)>>IOA_MXENT_SHIFT,10,0);
   ADDS_MP_STATUS(" max. redirection entries, arbitration prior. at ");
   ADDN_MP_STATUS((IO_APIC_READ(IO_APIC_ARBITR_REG) & IOA_ARB_MASK)
                  >>IOA_ARB_SHIFT,10,0);
   ADDS_MP_STATUS("\n");

   for (i=0; i<=5; i++) {
      ADDS_MP_STATUS("Red.ent#");
      ADDN_MP_STATUS(i,10,2);
      ADDS_MP_STATUS("-");
      val=IO_APIC_READ(IO_APIC_REDTBL_REG_HIGH(i));
      ADDN_MP_STATUS(val,2,32);
      val=IO_APIC_READ(IO_APIC_REDTBL_REG_LOW(i));
      ADDN_MP_STATUS(val,2,32);
      ADDS_MP_STATUS("\n");     
   }
}


/************************************************************/
/* Print MP table entries information			    */
/************************************************************/


#define PRINT_CPU_ENTRY(cpu)						\
            ADDS_MP_STATUS("CPU type ");				\
            ADDN_MP_STATUS(ce.ce_signature,16,0);			\
            ADDS_MP_STATUS(" APIC id");					\
            ADDN_MP_STATUS(ce.ce_local_apic_id,10,0);			\
            if (ce.ce_flags & CE_EN_FLAG_MASK) ADDS_MP_STATUS(" en");	\
                                          else ADDS_MP_STATUS("dis");	\
            ADDS_MP_STATUS("abled as ");				\
            if (ce.ce_flags & CE_BP_FLAG_MASK) ADDS_MP_STATUS("BSP\n");	\
                                          else ADDS_MP_STATUS("AP\n")


#define PRINT_IO_APIC_ENTRY(ae)						\
            ADDS_MP_STATUS("I/O APIC id");				\
            ADDN_MP_STATUS(ae.ae_id,10,0);				\
            ADDS_MP_STATUS(" v");					\
            ADDN_MP_STATUS(ae.ae_version,10,0);				\
            if (ae.ae_flags & AE_EN_FLAG_MASK) ADDS_MP_STATUS(" en");	\
                                          else ADDS_MP_STATUS("dis");	\
            ADDS_MP_STATUS("abled at 0x");				\
            ADDN_MP_STATUS(ae.ae_address,16,8);				\
            ADDS_MP_STATUS("\n")



#define PRINT_IO_INT_ENTRY(ioie)					\
	    ADDS_MP_STATUS("IOInt:t");					\
	    ADDN_MP_STATUS(ioie.ie_int_type,10,0);			\
	    ADDS_MP_STATUS("irq");					\
	    ADDN_MP_STATUS(ioie.ie_bus_irq,10,0);			\
	    ADDS_MP_STATUS("->IOAPIC");					\
	    ADDN_MP_STATUS(ioie.ie_apic_id,10,0);			\
	    ADDS_MP_STATUS("LINTIN");					\
	    ADDN_MP_STATUS(ioie.ie_apic_int,10,0);			\
	    ADDS_MP_STATUS("\t\t")

#define PRINT_LOCAL_ENTRY(lie)						\
	    ADDS_MP_STATUS("LOCAL INT ENTRY: type ");			\
	    ADDN_MP_STATUS(lie.lie_int_type,10,0);			\
	    ADDS_MP_STATUS(" irq  ");					\
	    ADDN_MP_STATUS(lie.lie_bus_irq,10,0);			\
	    ADDS_MP_STATUS(" conected to L.APIC ");			\
	    ADDN_MP_STATUS(lie.lie_apic_id,10,0);			\
	    ADDS_MP_STATUS(" LINTIN");					\
	    ADDN_MP_STATUS(lie.lie_apic_int,10,0);			\
	    ADDS_MP_STATUS("\n")			


#define PRINT_MP_SUMMARY(cpu_c,bus_c,apic_c,ioint_c,lint_c)	\
	   ADDS_MP_STATUS("\tSUMMARY MP info: ");			\
	   ADDN_MP_STATUS(cpu_c,10, 0);					\
	   ADDS_MP_STATUS(" CPUs, ");					\
	   ADDN_MP_STATUS(bus_c,10, 0);					\
	   ADDS_MP_STATUS(" BUS definition(s), ");			\
	   ADDN_MP_STATUS(apic_c,10, 0);				\
	   ADDS_MP_STATUS(" I/O APIC(s),\n\t\t");			\
	   ADDN_MP_STATUS(ioint_c,10, 0);				\
	   ADDS_MP_STATUS(" I/O int. assignation(s), ");		\
	   ADDN_MP_STATUS(lint_c,10, 0);				\
	   ADDS_MP_STATUS(" local int. assignation(s).\n")



/************************************************************/
/* Print trampoline machine code and information	    */
/************************************************************/

void dump_trampoline(u32_t trampoline_addr, u32_t trampoline_sz) {
   int i;
   u8_t c;

   ADDS_MP_STATUS("Trampoline allocated at 0x");
   ADDN_MP_STATUS(trampoline_addr,16,8);
   ADDS_MP_STATUS("\n");

   for (i=0; i<trampoline_sz; i++) {
       phys_copy(trampoline_addr+i, vir2phys(&c),1);
       ADDS_MP_STATUS(" ");
       if (i % 26 == 0) ADDS_MP_STATUS("  ");
       ADDN_MP_STATUS(c,16,2);
   }
   ADDS_MP_STATUS("\n");
}


