#ifndef MP_H
#define MP_H
/*********************************************************************/
/* Multiprocessor declarations and types                             */
/*********************************************************************/

#include <sys/types.h>
#include "xmp.h"

extern char MP_STATUS[];	/* String containing information about
				   MP start procedure */

/* PUBLIC FUNCTIONS */
void mp_start(void);
void mp_stop(void);
void lock_mp_kernel(void);
void unlock_mp_kernel(void);
void mp_switching_lock(void);
void mp_switching_unlock(void);
int  mp_switching_islocked(void);
void mp_heldq_lock(void);
void mp_heldq_unlock(void);
void enable_cache(void);
void disable_cache(void);
void halt(void);

/* MP interprocessor communication */
#define MP_CM_NONE	0	/* nothig to do */
#define MP_CM_DISABLE	1	/* disable cpu */
#define MP_CM_ENABLE	2	/* enable cpu */
#define MP_CM_SCHED	3	/* schedule and pick a new process to run */
#define MP_CM_PICKPROC	4	/* pick a new process to run */
#define MP_CM_REBOOT	5	/* invoke wreboot(mp_param) */
#define MP_CM_HALT	6	/* stop cpu */
#define MP_CM_ARG_NONE	0	/* no parameter */
void interrupt_cpu(int cpu, int command, int param);


/* FUNCIONS DEFINED IN ASSEMBLER CODE */
void phys_copy_dword (unsigned long source, unsigned long destination);
void copy_registers_to_trampoline(void);
int f_this_cpu(void);
void mp_IPI(void);


#define CPU_ENABLED	1		/* cpu is runing */
#define CPU_DISABLED	0		/* cpu is not runing */
#define CPU_DISABLING	2		/* cpu is ordered to disable */
#define CPU_HALTED	3		/* cpu is halted */
extern int cpu_available[MP_NR_CPUS];	/* is this cpu running now? */
/* Enable and disable a CPU. If echo is nonzero, prints a message */
void enable_cpu(int cpu,int echo);	
void disable_cpu(int cpu,int echo);
void halt_cpu(int cpu);
#define WITH_ECHO	1
#define WITHOUT_ECHO	0



#define FOR_EACH_CPU(cpu)		for(cpu=0; cpu<MP_NR_CPUS; ++cpu)

#define FOR_EACH_AP(cpu)		for(cpu=1; cpu<MP_NR_CPUS; ++cpu)

#define FOR_EACH_ENABLED_CPU(cpu)	FOR_EACH_CPU(cpu) \
					if (cpu_available[cpu]==CPU_ENABLED)



#endif
