#ifndef lint
static char *RCS_refresh_folder_c = "$Id: refresh.c,v 1.1 90/09/19 14:00:09 rogers Exp $";
#endif

/* --------------------
	vmail -- refresh_folder.c

	Routine for rescanning a folder.

	James Perkins 9-19-90 (jamesp@metolius.wr.tek.com)
-------------------- */

#include "defs.h"

/* --------------------
	Refresh the folder's display - reread the scan listing
-------------------- */
void
refresh_folder()
{
	folder	f, p;
	char	*curfname = curflr->name;
	char	str[LEN];

	/*
	 * INACTIVATE CURRENT FOLDER
	 */

	/* find first, last page of folder */
	p = curflr; FRST_OF_NAME(p);
	f = curflr; LAST_OF_NAME(f);

	/* free (should really, actually free here...) */
	p->next = f->next;
	p->valid = false;
	p->mail = p->last = (item) NULL;
	p->pagenum = p->pages = 1;
	if(p->next != (folder) NULL)
		p->next->prev = p;

	/* Get new current folder in case the re-scan comes up empty */
	curflr = p;
	NEXT_VALID(curflr);
	if(curflr == (folder) NULL) {
		curflr = p;
		PREV_VALID(curflr);
	}
	if(curflr == (folder) NULL) {
		/* Note: just made the last folder inactive ... */
	}

	/*
	 * GOTO ORIGINAL, STARTING FOLDER NAME
	 */

	GOTO_NAME(f, curfname);
	if(f == (folder) NULL) {
		addstatus("no such folder", true);
		return;
	}
	if(!f->valid) {
		f->valid = true;
		addstatus("re-reading mail headers ...", true);
		(void)find_mail(f, false);
		if(f->valid == EMPTY) {
			/* go to another valid folder (found by code above) */
			if (curflr == (folder) NULL) {
				/* No other valid folder to go to! */
				addstatus("Last active folder is empty", true);
				to_normal();
				exit(0);
			}
			(void)sprintf(str, "%s -- folder empty", f->name);
			addstatus(str, true);
			f = curflr;
		}
	}
	else {
		addstatus("internal error: folder unexpectedly valid!", true);
		to_normal();
		exit(0);
	}

	alternate = (folder) NULL;
	curflr = f;
	curmail = f->mail;
	y = FIRST;
	display_page();
}
