#ifndef lint
static char *RCS_inc_c = "$Id: inc.c,v 1.3 90/04/23 14:41:07 rogers Exp $";
#endif

/* --------------------
	vmail -- inc.c

	Incorporate new mail with "inc", parse output and update appropriate
	folder-pages.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include "defs.h"

#define INCORP		"Incorporating new mail into "
#define TAIL		"...\n"

static folder isfol;		/* folder into which mail is being incorporated */
static item ismail;			/* last item of mail on isfol page */
static int count;			/* number of items on isfol page */

/* --------------------
	Call, inc, parse output to work out what items have been read and into
	what folders.
-------------------- */
void
inc()
{
	char	str[LEN], line[LEN], *tmp, *fgets();
	FILE	*pp, *fdopen();
	int		num, pd[2], len = strlen(INCORP), numbers();
	bool	redraw = true;
#ifdef POSIX_1
	int status;
#else
	union wait status;
#endif

	addstatus("incorporating mail ... ", true);
	(void)pipe(pd);
	if(! vfork()) {
		(void)close(pd[0]);
		(void)dup2(pd[1], 1);
		(void)close(pd[1]);
		(void)dup2(1, 2);
		execlp(INC, "inc", 0);
	}
	(void)close(pd[1]);
	if((pp = fdopen(pd[0], "r")) == (FILE *) NULL) {
		addstatus("panic, can't incorporate mail", true);
		return;
	}
	while((tmp = fgets(str, LEN, pp)) != (char *) NULL)	/* read "inc" output */
		if(strncmp(tmp, INCORP, len) == 0) {	/* reading into new folder */
			tmp += len;
			tmp[strlen(tmp)-strlen(TAIL)] = '\0';
			goto_incorp_folder(tmp);
			if(isfol == (folder) NULL) {
				(void)sprintf(line, "can't go to folder %s", tmp);
				addstatus(line, true);
				redraw = false;
				break;
			} else {
				(void)sprintf(line, "incorporating mail into folder %s", tmp);
				addstatus(line, true);
			}
		} else if(num = numbers(tmp))	/* continuing to read into folder */
			create_mail_record(num);
		else if(strlen(str) > 2) {		/* vmail is confused - break */
			str[strlen(str)-1] = '\0';
			addstatus(str, true);
			redraw = false;
			break;
		}
	if(redraw) {
		if(isfol != curflr)
			alternate = curflr;
		curflr = isfol;
		curmail = ismail;
		y = count;
		display_page();
	}
	(void)fclose(pp);
	(void)wait(&status);
}


/* --------------------
	Extract the first number from str.
-------------------- */
int
numbers(str)
	char	*str;
{
	char	save, *tmp;
	int		i;

	for(; *str == ' ' ; str++)
		;
	for(tmp=str ; *str >= '0' && *str <= '9' ; str++)
		;
	save = *str, *str = '\0', i = atoi(tmp), *str = save;
	return(i);
}


/* --------------------
	Find the folder into which mail is being incorporated, set isfol,
	ismail, count.
-------------------- */
void
goto_incorp_folder(str)
	char	*str;
{
	folder	create_folder();

	GOTO_NAME(isfol, str);
	if(isfol == (folder) NULL) {	/* new folder */
		isfol = create_folder(str);
		isfol->valid = true;
		ismail = (item) NULL;
		count = FIRST-1;
	} else {
		if(! isfol->valid) {
			isfol->valid = true;
			(void)find_mail(isfol, false);
		}
			/* find last appropriate folder record */
		LAST_OF_NAME(isfol);
		for(count=FIRST, ismail=isfol->mail ; ismail->next != (item) NULL ;
												count++, ismail=ismail->next)
			;
	}
}


/* --------------------
	Create and insert new item record into isfol, may need to create new page.
-------------------- */
void
create_mail_record(num)
	int		num;
{
	item	m;
	folder	new_folder();

	m = NEW(mail_item);
	get_title(isfol, m, num);
	m->next = (item) NULL;
	if(count > lines) {
			/* create new folder record */
		isfol = new_folder(isfol);
		ismail = (item) NULL;
		count = FIRST;
	} else
		count++;
	if(ismail == (item) NULL) {
			/* new record, possibly new folder */
		m->prev = (item) NULL;
		isfol->mail = isfol->last = m;
	} else {
			/* insert at end of list of mail items */
		m->prev = ismail;
		ismail->next = isfol->last = m;
	}
	ismail = m;
}
