#ifndef lint
static char *RCS_choose_c = "$Id: choose.c,v 1.2 90/04/23 14:40:52 rogers Exp $";
#endif

/* --------------------
	vmail -- choose.c

	Tty-based folder selection.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include "defs.h"

#define START			10				/* offset from margin of screen */
#define RESET()			toggle=false,	/* left- or right- hand indicator */ \
						i=FIRST+1,		/* initial row */					 \
						j=START,		/* initial column */				 \
						f=first			/* first folder */

WINDOW	*chooser = (WINDOW *) NULL;

/* --------------------
	Display folder selection page, read commands to move around page and
	select folders.
-------------------- */
void
choose()
{
	int		n, i, j;
	bool	toggle;
	folder	next, f, showing(),
			first = folders,	/* first folder on screen */
			last;				/* folder after last folder on screen */
	char	c, str[LEN], flushin();

	RESET();
	if(chooser == (WINDOW *) NULL)
		chooser = newwin(0, 0, 0, 0);
	last = showing(first);
restart:
	while((c = flushin()) != ' ' && c != 'q') switch(c) {
		case '\r':		/* go to next screen of folder names */
		case '\n':
			if(last == (folder) NULL)
				beep();
			else {
				first = last;
				last = showing(first);
				RESET();
			}
			break;
		case '\b':		/* go back one page of folders */
			if(first == folders)
				beep();
			else {
				for(i=(lines-FIRST)*2 ; i > FIRST && first->prev != (folder) NULL ; i--, first=first->prev)
					;
				last = showing(first);
				RESET();
			}
			break;
		case CTRL_L:	/* redraw */
			last = showing(first);
			break;
		case 'h':		/* move left */
			if(! toggle)	/* already at left */
				beep();
			else {
				next = f;
				FRST_OF_NAME(next);
				next = next->prev;
				if(next == (folder) NULL)
					beep();
				else {
					f = next; j = START; toggle = false;
					(void)wmove(chooser, i, j);
					(void)wrefresh(chooser);
				}
			}
			break;
		case 'j':		/* move down */
			if(i+1 >= lines)	/* at bottom */
				beep();
			else {
				next = f;
				for(n=0 ; n < 2 && next != (folder) NULL ; n++) {
					LAST_OF_NAME(next);
					next = next->next;
				}
				if(next == (folder) NULL)
					beep();
				else {
					i++; f = next;
					(void)wmove(chooser, i, j);
					(void)wrefresh(chooser);
				}
			}
			break;
		case 'k':		/* move up */
			if(i <= FIRST+1)	/* at top */
				beep();
			else {
				next = f;
				for(n=0 ; n < 2 && next != (folder) NULL ; n++) {
					FRST_OF_NAME(next);
					next = next->prev;
				}
				if(next == (folder) NULL)
					beep();
				else {
					i--; f = next;
					(void)wmove(chooser, i, j);
					(void)wrefresh(chooser);
				}
			}
			break;
		case 'l':		/* move right */
			if(toggle)		/* at right */
				beep();
			else {
				next = f;
				LAST_OF_NAME(next);
				next = next->next;
				if(next == (folder) NULL)
					beep();
				else {
					f = next; j = cols/2; toggle = true;
					(void)wmove(chooser, i, j);
					(void)wrefresh(chooser);
				}
			}
			break;
		default:
			beep();
			break;
	}
	if(c == ' ') {		/* attempt to go to folder */
		if(! f->valid) {	/* load folder */
			mvwaddstr(chooser, FIRST, 0, "Reading mail headers ...");
			(void)wmove(chooser, i, j);
			(void)wrefresh(chooser);
			f->valid = true;
			(void)find_mail(f, false);
		}
		if(f->valid == EMPTY) {		/* folder is empty */
				/* Go back to chooser, display "empty" message */
			(void)sprintf(str, "%s -- folder empty", f->name);
			if(first == f)		/* find new first folder for page */
				if(f->next != (folder) NULL)
					first = f->next;
				else
					first = folders;
			last = showing(first);
			RESET();
			mvwaddstr(chooser, FIRST, 0, str);
			(void)wmove(chooser, i, j);
			(void)wrefresh(chooser);
			goto restart;
		} 
		curflr = f;
		curmail = f->mail;
		y = FIRST;
	}
	display_page();
}


/* --------------------
	Show all folder names starting with "start" ending with last folder or
	when page is full.
-------------------- */
folder
showing(start)
	folder	start;
{
	int		count, i = FIRST+1, j = START;
	bool	toggle = false;
	folder	p, f;
	item	m;
	char	str[LEN];

	(void)wclear(chooser);
	mvwaddstr(chooser, TITLE, 0,
"h,j,k,l -- left,down,up,right        <return>,<bs> -- next/prev page of folders");
	mvwaddstr(chooser, STATUS, 0,
"<space> -- select folder             q -- quit, no change         ^L -- refresh");
	for(p=f=start ; i < lines && f != (folder) NULL ; p=f=p->next) {
		if(f->valid) {
				/* find last page of folder, count items in folders */
			for(count=0, p=f ; p->next != (folder) NULL &&
										p->next->name == f->name ; p=p->next)
				for(m=p->mail ; m != (item) NULL ; m=m->next, count++)
					;
			for(m=p->mail ; m != (item) NULL ; m=m->next, count++)
				;
			if(count == 1)
				(void)sprintf(str, "%s: %d, 1 item", f->name, f->mail->number);
			else
				(void)sprintf(str, "%s: %d-%d, %d items", f->name, f->mail->number,
													p->last->number, count);
		} else
			(void)sprintf(str, "%-15s(inactive)", f->name);
		if(f == curflr) standout();
		mvwaddstr(chooser, i, j, str);
		if(f == curflr) standend();
		if(toggle)
			j = START, i++;
		else
			j = cols/2;
		toggle = ! toggle;
	}
	(void)wmove(chooser, FIRST+1, START);
	(void)wrefresh(chooser);
	return(f);
}


WINDOW *folwin = (WINDOW *) NULL;

/* --------------------
	List all folders, active or otherwise.
-------------------- */
void
list_folders()
{
	folder	f = folders, p;
	int		count, i = FIRST, half = cols/2;
	bool	toggle = false;
	char	str[LEN];
	WINDOW	*newwin();
	item	m;

	if(folwin == (WINDOW *) NULL)
		folwin = newwin(0, 0, 0, 0);
	(void)wclear(folwin);
	for(p=f ; ; p=f=p->next) {
		if((i+2) % lines == 0) {
			if(use_prompt(folwin) == 'q')
				break;
			i = FIRST;
			(void)wclear(folwin);
		}
		if(f == (folder) NULL) {
			(void)use_prompt(folwin);
			break;
		}
		if(f->valid) {
				/* find last page of folder, count items in folders */
			for(count=0, p=f ; p->next != (folder) NULL &&
										p->next->name == f->name ; p=p->next)
				for(m=p->mail ; m != (item) NULL ; m=m->next, count++)
					;
			for(m=p->mail ; m != (item) NULL ; m=m->next, count++)
				;
			if(count == 1)
				(void)sprintf(str, "%s: %d, 1 item", f->name, f->mail->number);
			else
				(void)sprintf(str, "%s: %d-%d, %d items", f->name, f->mail->number,
													p->last->number, count);
		} else
			(void)sprintf(str, "%-15s(inactive)", f->name);
		if(f == curflr)
			(void)wstandout(folwin);
		if(toggle) {
			mvwaddstr(folwin, i, half, str);
			i++;
		} else
			mvwaddstr(folwin, i, 10, str);
		if(f == curflr)
			(void)wstandend(folwin);
		toggle = !toggle;
	}
	display_page();
}
