/*queue.h,v 1.1 1995/02/23 09:18:58 blong Exp
**queue.h,v
 * Revision 1.1  1995/02/23  09:18:58  blong
 * Update to 1.4beta from ACM 1.3.3
 * Adds round robin stay alive children processes and Error Document direction
 *
 */

#ifndef _QUEUE_H
#define _QUEUE_H 1

/* Since a file descriptor (in my experience) is merely an integer, this is
implemented as a queue for integers.  For now, its going to be dynamic, 
implemented over a linked list. */

typedef struct _queueRec {
    int Data;
    void* Next;
    void* Prev;
} queueRec;
    
typedef struct _queue {
    queueRec* Front;
    queueRec* Back;
    int num;
} queue;

queue* createQueue();
int enQueue(queue* q, int newfd);
int deQueue(queue* q);
int numQueue(queue* q);

#endif
    
