#!/bin/sh
#
# xrsh 1.3 - Start up a remote X process.     		Author: Kees J. Bot
#
# SYNOPSIS
# xrsh [-l user] host xcommand [-toolkitoption ...] [-option ...]
#
# BUGS
# Arguments to xrsh are evaluated more than once.
# Heavy use of all the different quoting characters the shell has.
# Line noise looks more readable.

usage='echo "Usage: xrsh [-l user] host xcommand [-toolkitoption ...] [-option ...]" >&2; exit 1'

case $#:$1:$2 in
0::|[12]:-l:*|2:*:-l)
		eval "$usage"			# xrsh [garbage ...]
		;;
*:-l:*)		user=$2; host=$3; shift 3	# xrsh -l user host ...
		;;
*:*:-l)		user=$3; host=$1; shift 3	# xrsh host -l user ...
		;;
*:-*:*)		eval "$usage"			# xrsh -garbage ...
		;;
*)		user=$USER; host=$1; shift	# xrsh host ...
esac

case $USER:${NODENAME=`uname -n`} in
$user:$host)	# No reason to go remote
	unset XRSH
	$* &
	exit 0
esac

case $DISPLAY in
:0*|unix:0*)	DISPLAY=$NODENAME:0 export DISPLAY
esac

#
# The XDMCP magic cookie is retrieved from the .Xauthority file and passed
# to the other side.

cookie="`xauth -i list $DISPLAY`"

# Home directory of root and bin need not be writable for xauth, also we
# need different files for the two users.

case $user in
root|bin)
	xauthority='XAUTHORITY=/usr/adm/.Xauthority.$USER; export XAUTHORITY'
esac

#
# Feed an rsh with environment settings and the command to execute.

echo "
trap '' 1 15
DISPLAY=$DISPLAY; export DISPLAY
${TZ+TZ='$TZ';export TZ}

$xauthority
xauth add $cookie

$XRSH

$* </dev/null >/dev/null 2>&1 3<&- 4<&- 5<&- 6<&- 7<&- 8<&- 9<&- &

" | rsh -l $user $host exec sh || { \
	excode=$?
	echo "Is the line '$NODENAME $USER' in the .rhosts file of $user?" >&2
	exit $excode
}
