#!/bin/sh
#
# suxcmd 1.3 - su <user> -c "xcommand"			Author: Kees J. Bot

case $# in
0|1)	echo "Usage: suxcmd user X-command" >&2
	exit 1
esac

user="$1"; shift

#
# The XDMCP magic cookie is retrieved from the .Xauthority file and passed
# to the new users authority file.

cookie="`xauth -i list $DISPLAY`"

#
# Home directory of root and bin need not be writable for xauth, also we
# need different files for the two users.

case $user in
root|bin)
	xauthority='XAUTHORITY=/usr/adm/.Xauthority.$USER; export XAUTHORITY'
esac

#
# Let su change user-id, set up an environment and execute the command.

exec su -e $user -c "
trap '' 1 15
DISPLAY=$DISPLAY; export DISPLAY
${TZ+TZ='$TZ';export TZ}

$xauthority
xauth add $cookie

$* </dev/null >/dev/null 2>&1 &"
