#!/bin/sh
#
#	startX 1.2 - start X11 session.			Author: Kees J. Bot

cd	# Home sweet home.

Xroot=/opt/XF86-3.1.1

#
# Set default server and display variables.
#

nodename=`uname -n`
chrome=default
test -f $Xroot/bin/X11/X && chrome=useX

server=
host=
xsession=
serveropt=

DISPLAY=$nodename:0

usage()
{
	echo >&2 "\
Usage: startX [-display display] [-server server] [-remote [user@]host]
	[-mono] [-color] [-color16] [-serveroption] [script]"
	exit 1
}

do_opts()
# Process arguments.
{
	local nopts
	shift $1
	shift 1
	nopts=$#

	while [ $# -gt 0 ]; do
		case $1 in
		'-?')	usage
			;;
		-display)
			test $# -ge 2 || usage
			DISPLAY="$2"
			shift 2
			;;
		-server)
			test $# -ge 2 || usage
			server="$2"
			shift 2
			;;
		-remote)
			test $# -ge 2 || usage
			case $2 in
			*@*)	host=`IFS=@; set -- $2; echo -l \$1 \$2`
				;;
			*)	host="$2"
			esac
			shift 2
			;;
		-mono)
			chrome=mono
			shift
			;;
		-color|-colour)
			chrome=color
			shift
			;;
		-color16|-colour16)
			chrome=color16
			shift
			;;
		-gray|-grey)
			test $chrome = default && chrome=color
			serveropt="$serveropt -class GrayScale"
			shift
			;;
		-*)
			serveropt="$serveropt $1"
			shift
			;;
		*)	case $xsession in
			'')	xsession="$1" ;;
			*)	usage
			esac
			shift
		esac
	done
	OPTIND=`expr $nopts - $# + 1`
}

# Process command line options.
do_opts 0 "$@"
shift `expr $OPTIND - 1`

if [ -f /etc/XF86Config ]
then
	# Process options from the XF86Config file.
	while read confline
	do
		# Process lines starting with #$startX.
		case "$confline" in
		'#$'start[xX])
			do_opts 1 $confline
			;;
		'#$ 'start[xX])
			do_opts 2 $confline
		esac
	done < /etc/XF86Config || exit
fi

# Default server depends on "chrome".
test $chrome = default && chrome=`sysenv chrome`

case $chrome:$server in
useX:)	server=X
	;;
mono:)	server=XF86_Mono
	;;
color:)	server=XF86_SVGA
	;;
color16:)
	server=XF86_VGA16
esac

# The default session script.
test -z "$xsession" && xsession=.Xsession

export DISPLAY

#
# Start a server if the intended display is on the local host.
#

if [ "$DISPLAY" = "$nodename:0" ]
then
	#
	# Create magic cookie for authentication.
	#
	cookie=`mkcookie`
	xauth add $DISPLAY MIT-MAGIC-COOKIE-1 $cookie

	# Start server.
	server=`startXserver $server -auth .Xauthority $serveropt` || exit

	if [ -n "$host" ]
	then
		# Start the session on a remote host (see xrsh(1)).
		echo "
		DISPLAY=$DISPLAY; export DISPLAY
		${TZ+TZ='$TZ';export TZ}
		xauth add $DISPLAY MIT-MAGIC-COOKIE-1 $cookie
		exec startX -display $DISPLAY $xsession
		" | xterm -name xterm-console -e sh -c \
			"trap '' 2 3 15; tail -f /usr/adm/log& \
				exec rsh $host exec sh <&9 9<&-" 9<&0
	elif [ ! -f $xsession ]
	then
		# Start a single xterm if the user session script doesn't exist.
		xterm -name xterm-console
	else
		# Start user session inside a "console" window.
		xterm -name xterm-console -e sh -c \
			"trap '' 2 3 15; tail -f /usr/adm/log& \
				 exec sh $xsession"
	fi

	# Take the server down.
	kill $server
	while kill -0 $server 2>/dev/null; do sleep 1; done
	exit 0
else
	#
	# The server is elsewhere, run .Xsession if it exists.
	#
	if [ -n "$host" ]
	then
		# The session is also started elsewhere.
		echo "
			DISPLAY=$DISPLAY; export DISPLAY
			${TZ+TZ='$TZ';export TZ}
			xauth add `xauth -i list $DISPLAY`
			exec startX -display $DISPLAY $xsession
		" | rsh $host exec sh
	elif [ ! -f $xsession ]
	then
		echo "startX: $xsession: no such file" >&2; exit 1
	else
		exec sh $xsession
	fi
fi
