#!/bin/sh
#
# rxterm - Start up a remote xterm.	    Author: Kees J. Bot  (kjb@cs.vu.nl)
#
# SYNOPSIS
# rxterm [-l user] host [-toolkitoption ...] [-option ...]
#

usage='echo "Usage: rxterm [-l user] host [-toolkitoption ...] [-option ...]" >&2; exit 1'

case $#:$1:$2 in
0::|[12]:-l:*|2:*:-l)
		eval "$usage"			# rxterm [garbage ...]
		;;
*:-l:*)		user=$2; host=$3; shift 3	# rxterm -l user host ...
		;;
*:*:-l)		user=$3; host=$1; shift 3	# rxterm host -l user ...
		;;
*:-*:*)		eval "$usage"			# rxterm -garbage ...
		;;
*)		user=$USER; host=$1; shift	# rxterm host ...
esac

case $USER:${NODENAME-`uname -n`} in
$user:$host)
	xterm -n $user@$host -T $user@$host $* &
	;;
*:*)
	exec xrsh -l $user $host xterm -n $user@$host -T $user@$host $*
esac
