/*	mkcookie 1.3 - Generate a random cookie for xauth(1).
 *							Author: Kees J. Bot
 *								7 Feb 1992
 */
#define nil 0
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

void hex(unsigned long val, int n)
/* Emit n hex digits from val. */
{
	while (n > 0) {
		printf("%x", (val & 0x0F));
		if (ferror(stdout)) perror("mkcookie");
		val /= 0x10;
		n--;
	}
}

int main(int argc, char **argv)
{
	struct timeval tv;
	FILE *pf;
	int c, i;
	unsigned long p, q;

	if (sysutime(UTIME_TIMEOFDAY, &tv) < 0) {
		perror("mkcookie");
		exit(1);
	}

	hex(tv.tv_usec, 6);
	hex(tv.tv_sec, 8);
	hex(getpid(), 4);

	if ((pf= popen("ps alx", "r")) != nil) {
		q= 0;
		i= 0;

		while ((c= getc(pf)) != EOF) {
			q ^= (unsigned long) (c & 0xF) << i;
			i= (i + 4) % 32;
		}
		hex(q, 8);
		pclose(pf);
	}

	putchar('\n');
	fflush(stdout);
	if (ferror(stdout)) { perror("mkcookie"); exit(1); }
	exit(0);
}
