/*	utime / stime 1.3 - Set time of file using old time to start with.
 *			    Set global time if argv[0] == stime. (Minix only)
 *
 *							Author: Kees J. Bot
 *								23 Jun 1988
 *
 *	BUG:		    Assumes that arrow keys produce ANSI escapes.
 *	FEATURE:	    You may also use the hjkl-keys.
 */
#define nil 0
#if __minix
#define _POSIX_SOURCE	1
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#include <utime.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <termios.h>

char *name;

struct termios term;

void save_term(void)
{
	tcgetattr(0, &term);
}

void cbreak(void)
{
	struct termios cbrk;

	cbrk= term;
	cbrk.c_lflag&= ~(ICANON | ECHO);
	tcsetattr(0, TCSANOW, &cbrk);
}

void cooked(void)
{
	tcsetattr(0, TCSANOW, &term);
}

void quit(int sig)
{
	cooked();
	exit(sig);
}

time_t gettime(char *tfile)
{
	struct stat st;

	if (stat(tfile, &st) < 0) {
		fprintf(stderr, "%s: %s: %s\n", name, tfile, strerror(errno));
		quit(1);
	}
	return st.st_mtime;
}

void settime(char *tfile, time_t T)
{
	struct utimbuf tbuf;

	tbuf.actime= tbuf.modtime= T;

	if (utime(tfile, &tbuf) < 0) {
		fprintf(stderr, "%s: %s: %s\n", name, tfile, strerror(errno));
		quit(1);
	}
}

#define SEC	((time_t) 1)
#define MIN	 (60 * SEC)
#define HOUR	 (60 * MIN)
#define DAY	 (24 * HOUR)
#define WEEK	  (7 * DAY)
#define MONTH	 (30 * DAY)
#define YEAR	(365 * DAY)

/* Thu Jun 23 21:05:21 1988 */
/*  1   5   9  2  5  8    3 */

char pos[]=   {   1,     5,   9,   12,  15,  18,   23,  44,
		 50,    54,  58,   61,  64,  67,   72		};
time_t off[]= { DAY, MONTH, DAY, HOUR, MIN, SEC, YEAR, SEC,
		DAY, MONTH, DAY, HOUR, MIN, SEC, YEAR 		};

#define FIRST	3
#define NPOS	(sizeof(pos)/sizeof(pos[0]))

char *decimal(time_t T)		/* Correct for signed and unsigned time_t */
{
	int sign= ' ';
	unsigned long t;
	static char buf[12];
	char *bp= buf + sizeof(buf);

	if (T < 0) sign= '-', t= -T; else t= T;

	do
		*--bp= t%10 + '0';
	while ((t/=10) != 0);

	*--bp= sign;

	do *--bp= ' '; while (bp > buf);

	return buf;
}

void print(int p, time_t T)
{
	char buf[(1+24+9+12+4+24+4)*2];
	char loc[24], zone[8], *utc, *dec;
	struct tm *tmp;

	tmp= localtime(&T);
	memcpy(loc, asctime(tmp), 24);
	(void) strftime(zone, 8, "%Z", tmp);
	utc= asctime(gmtime(&T));
	dec= decimal(T);

	buf[0]= '\r';
	memcpy(buf+1, loc, 24);
	memset(buf+1+24, ' ', 9);
	memcpy(buf+1+24+1, zone, strlen(zone));
	memcpy(buf+1+24+9, dec, 12);
	memcpy(buf+1+24+9+12, "    ", 4);
	memcpy(buf+1+24+9+12+4, utc, 24);
	memcpy(buf+1+24+9+12+4+24, " UTC", 4);
	memcpy(buf+1+24+9+12+4+24+4, buf, 1+24+9+12+4+24+4);
	write(1, buf, 1+24+9+12+4+24+4+1+pos[p]);
}

void nl(void)	{ write(1, "\n", 1); }

int getkey(void)
{
	char c;

	return read(0, &c, 1) <= 0 ? '\n' : (c & 0xFF);
}

#define pair(e, c)	(((e) << 8) | c)

void change(time_t *pT)
{
	time_t T= *pT;
	int p= FIRST;
	int escape= 0, c;

	print(p, T);

	while ((c= getkey()) != '\n' && c != '\r') {
		switch (pair(escape, c)) {

		case '\33':
			escape= c;
			break;

		case pair('\33', '['):
			escape= '[';
			break;

		case pair('[', 'B'):
		case 'j':
			escape= 0;
			T-= off[p];
			break;

		case pair('[', 'A'):
		case 'k':
			escape= 0;
			T+= off[p];
			break;

		case pair('[', 'D'):
		case 'h':
			escape= 0;
			p= (p+NPOS-1) % NPOS;
			break;

		case pair('[', 'C'):
		case 'l':
			escape= 0;
			p= (p+1) % NPOS;
			break;

		default:
			escape= 0;
		}
		if (escape == 0) print(p, T);
	}
	nl();
	*pT= T;
}

int main(int argc, char **argv)
{
	time_t T;
	char *file;

	if ((name= strrchr(argv[0], '/')) == nil) name= argv[0]; else name++;

	if (strcmp(name, "stime") == 0) {
		if (argc > 2) {
			fprintf(stderr, "Usage: %s [file]\n", name);
			exit(-1);
		}
	} else {
		if (argc != 2) {
			fprintf(stderr, "Usage: %s file\n", name);
			exit(-1);
		}
	}
	save_term();

	file= argv[1];
	T= file == nil ? time(nil) : gettime(file);

	if (signal(SIGINT, SIG_IGN) != SIG_IGN) signal(SIGINT, quit);

	cbreak();

	change(&T);

#if _MINIX
	if (strcmp(name, "stime") == 0 && stime(&T) < 0) {
		fprintf(stderr, "%s: Can't set system time: %s\n", name,
							strerror(errno));
		quit(1);
	}
#endif

	if (file != nil) settime(file, T);

	quit(0);
}
