#!/bin/sh
#
#	checkhier 2.6 - check the directory hierarchy	Author: Kees J. Bot
#								7 May 1995

case "`id`" in
'uid=0('*)	;;
*)	echo "$0: must be run by root" >&2
	exit 1
esac

# List of all interesting top level files and directories, with mode,
# owner and group.  Only the key files are listed, the rest is owned
# by bin, has mode 755 or 644, and is not critical to the operation of
# the system.
{
	cat <<'EOF'
drwxr-xr-x	root	operator	/
drwxr-xr-x	bin	operator	/bin
-rw-r--r--	bin	operator	/boot
drwxr-xr-x	root	operator	/dev
drwxr-xr-x	root	operator	/etc
-rw-r--r--	root	operator	/etc/fstab
-rw-r--r--	root	operator	/etc/group
-rw-r--r--	root	operator	/etc/inetd.conf
-rw-r--r--	root	operator	/etc/motd
-rw-r--r--	root	operator	/etc/mtab
-rw-r--r--	root	operator	/etc/passwd
-rw-r--r--	root	operator	/etc/profile
-rw-r--r--	root	operator	/etc/protocols
-rw-r--r--	root	operator	/etc/rc
-rw-r--r--	root	operator	/etc/services
-rw-------	root	operator	/etc/shadow
-rw-r--r--	root	operator	/etc/syslog.conf
-rw-r--r--	root	operator	/etc/termcap
-rw-r--r--	root	operator	/etc/timeinfo
-rw-r--r--	root	operator	/etc/ttytab
-rw-r--r--	root	operator	/etc/utmp
dr-xr-xr-x	root	operator	/fd0
dr-xr-xr-x	root	operator	/fd1
drwxr-xr-x	bin	operator	/minix
dr-xr-xr-x	root	operator	/mnt
dr-xr-xr-x	root	operator	/root
drwxr-xr-x	bin	operator	/sbin
drwxrwxrwt	root	operator	/tmp
drwxr-xr-x	root	operator	/usr
lrwxrwxrwx	root	operator	/usr/adm -> ../var/adm
drwxr-xr-x	ast	other		/usr/ast
drwxr-xr-x	bin	operator	/usr/bin
drwxr-xr-x	bin	operator	/usr/etc
drwxr-xr-x	bin	operator	/usr/include
drwxr-xr-x	bin	operator	/usr/lib
lrwxrwxrwx	root	operator	/usr/lib/cpp -> ack/cpp
-rw-r--r--	bin	operator	/usr/lib/crontab
-rw-rw-r--	bin	operator	/usr/lib/packages
drwxr-xr-x	bin	operator	/usr/lib/smail
drwxr-xr-x	bin	operator	/usr/lib/zoneinfo
drwxrwxr-x	root	operator	/usr/local
lrwxrwxrwx	root	operator	/usr/local/adm -> ../../var/local/adm
drwxrwxr-x	bin	operator	/usr/local/bin
drwxrwxr-x	bin	operator	/usr/local/etc
drwxrwxr-x	bin	operator	/usr/local/include
drwxrwxr-x	bin	operator	/usr/local/lib
drwxrwxr-x	bin	operator	/usr/local/man
drwxrwxr-x	bin	operator	/usr/local/sbin
drwxrwxr-x	bin	operator	/usr/local/src
drwxr-xr-x	bin	operator	/usr/man
drwxr-xr-x	bin	operator	/usr/mdec
lrwxrwxrwx	root	operator	/usr/preserve -> ../var/preserve
drwxr-xr-x	bin	operator	/usr/sbin
lrwxrwxrwx	root	operator	/usr/spool -> ../var/spool
drwxr-xr-x	bin	operator	/usr/src
lrwxrwxrwx	root	operator	/usr/tmp -> ../var/tmp
drwxr-xr-x	root	operator	/home
drwxrwxr-x	root	operator	/opt
drwxr-xr-x	root	operator	/var
drwxrwxr-x	root	operator	/var/adm
-rw-r--r--	root	operator	/var/adm/lastlog
-rw-r--r--	root	operator	/var/adm/log
drwxr-xr-x	root	operator	/var/adm/old
-rw-r--r--	root	operator	/var/adm/wtmp
drwxr-xr-x	bin	operator	/var/lib
drwxrwxr-x	root	operator	/var/local
drwxrwxr-x	bin	operator	/var/local/adm
drwxrwxr-x	root	operator	/var/opt
drwx------	root	operator	/var/preserve
drwxr-xr-x	root	operator	/var/run
drwxr-xr-x	root	operator	/var/spool
drwx--x--t	root	operator	/var/spool/at
drwx--x--t	root	operator	/var/spool/at/past
drwxrwxr-x	root	uucp		/var/spool/locks
drwx------	daemon	daemon		/var/spool/lpd
drwxr-xr-x	root	operator	/var/spool/smail
drwxrwx---	uucp	uucp		/var/spool/uucp
drwxrwxr-x	uucp	uucp		/var/spool/uucppublic
drwxrwxrwt	root	operator	/var/tmp
EOF

} | {
	# Check if each file has the proper attributes.  Offer a correction
	# if not.
	banner="\
# List of commands to fix the top level hierarchy.  Do not apply these
# commands blindly, but check and repair by hand.
"

	while read mode owner group file arrow link
	do
		set -$- `ls -ld $file 2>/dev/null` '' '' '' '' '' '' '' ''
		curmode=$1 curowner=$3 curgroup=$4
		test $owner = '?' && curowner=$owner
		test $group = '?' && curgroup=$group
		shift 8
		curlink=$3

		# Stale file in /etc?
		if [ "$file" : '/etc.*' -a -f "$file" -a \
					! "$file" -newer "/usr/src$file" ]
		then
			echo "${banner}cp -s /usr/src$file $file   # stale?"
			banner=
		fi

		# File types?
		if [ x`expr "$mode" : '\\(.\\)'` != \
					x`expr "$curmode" : '\\(.\\)'` \
			-o x$link != x$curlink ]
		then
			case $curmode in
			?*)	echo "${banner}rm -r $file"
				banner=
			esac
			curmode= curowner= curgroup= curlink=
			case "$mode:$file" in
			d*:*)	echo "${banner}mkdir $file"
				;;
			l*:*)	echo "${banner}ln -s $link $file"
				;;
			-*:/etc/*)
				echo "${banner}cp -p /usr/src$file $file"
				;;
			-*:*)	echo "${banner}> $file"
				;;
			*:*)	echo "$0: $mode $file: unknown filetype" >&2
				exit 1
			esac
			banner=
		fi

		# Symlinks have no owners.
		case $mode in
		l*)	curmode=$mode curowner=$owner curgroup=$group
		esac

		# Mode?
		if [ x$mode != x$curmode ]
		then
			octmode=
			m=$mode
			for i in u g o
			do
				r=0 w=0 x=0
				case $m in
				?r??*)		r=4
				esac
				case $m in
				??w?*)		w=2
				esac
				case $m in
				???[xst]*)	x=1
				esac
				octmode=$octmode`expr $r + $w + $x`
				m=`expr $m : '...\\(.*\\)'`
			done
			r=0 w=0 x=0
			case $mode in
			???[sS=]??????)	r=4
			esac
			case $mode in
			??????[sS=]???)	w=2
			esac
			case $mode in
			?????????[tT=])	x=1
			esac
			case $r$w$x in
			000)	;;
			*)	octmode=`expr $r + $w + $x`$octmode
			esac

			echo "${banner}chmod $octmode $file"
			banner=
		fi

		# Ownership?
		if [ x$owner != x$curowner -o x$group != x$curgroup ]
		then
			echo "${banner}chown $owner:$group $file"
			banner=
		fi
	done
	case "$banner" in
	'')	exit 1
	esac
	exit 0
}
