/*	arx 1.3 - Does "ar xv achive ...", but archive is standard input.
 *		  It's task is to extract those V7 format ar(1) archives
 *		  used on the Minix 1.5 distribution disks.
 *						Author: Kees J. Bot
 */
#define nil 0
#include "sys/types.h"
#include "sys/stat.h"
#include "utime.h"
#include "time.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "errno.h"

/* V7 archive format, with PDP-11 longs! */

#define	ARMAG	0177545

struct ar_hdr {
	char		ar_name[14];
	unsigned char	ar_date[4];	/* long in byte order 2 3 1 0 */
	char		ar_uid;
	char		ar_gid;
	unsigned char	ar_mode[2];	/* short in byte order 0 1 */
	unsigned char	ar_size[4];	/* long in byte order 2 3 1 0 */
};

int member(char *n, char **a)
{
	if (*a == nil) return 1;

	do {
		if (strcmp(n, *a++) == 0) return 1;
	} while (*a != nil);

	return 0;
}

long pdp11l(unsigned char *l)
/* PDP-11 longs have words in high-endian order, and words in little-endian
 * order.
 */
{
	return (l[2] <<  0)
	     | (l[3] <<  8)
	     | (l[0] << 16)
	     | (l[1] << 24);
}

short pdp11s(unsigned char *s)
/* PDP-11 shorts are little-endian. */
{
	return (s[0] << 0)
	     | (s[1] << 8);
}

int main(int argc, char **argv)
{
	unsigned short magic;
	struct ar_hdr ar;
	long ar_date, ar_size;
	struct utimbuf ubuf;
	char name[sizeof(ar.ar_name)+1];
	FILE *f;
	off_t len;
	int c, err=0;

	if (fread((char *) &magic, sizeof(magic), 1, stdin) != 1
		|| magic != ARMAG
	) {
		fprintf(stderr, "%s: input is not in ar V7 format\n",
			argv[0]);
		exit(1);
	}

	while (fread((char *) &ar, sizeof(ar), 1, stdin) == 1) {
		ar_date= pdp11l(ar.ar_date);
		ar_size= pdp11l(ar.ar_size);

		strncpy(name, ar.ar_name, sizeof(ar.ar_name));
		name[sizeof(ar.ar_name)]= 0;

		if (!member(name, argv+1)) {
			f= nil;
		} else
		if ((f= fopen(name, "w")) == nil) {
			fprintf(stderr, "%s: Can't open %s: %s\n",
				argv[0], name, strerror(errno));
			err= 1;
		} else {
			fprintf(stderr, "x - %s\n", name);
		}
		len= ar_size;

		while (len > 0) {
			if ((c= getchar()) == EOF) {
				fprintf(stderr,
					"%s: Archive ends prematurely\n",
					argv[0]);
				err= 1;
				break;
			}
			if (f != nil && putc(c, f) < 0) {
				fprintf(stderr, "%s: Write error on %s\n",
					argv[0], name);
				exit(1);
			}
			len--;
		}
		if (f != nil) {
			if (fclose(f) == EOF) {
				fprintf(stderr, "%s: Write error on %s: %s\n",
					argv[0], name, strerror(errno));
				exit(1);
			}
			if (chmod(name, pdp11s(ar.ar_mode)) < 0) {
				fprintf(stderr,
					"%s: Can't set mode of %s: %s\n",
					argv[0], name, strerror(errno));
				err= 1;
			}
			ubuf.actime= time((time_t *) nil);
			ubuf.modtime= ar_date;
			if (utime(name, &ubuf) < 0) {
				fprintf(stderr,
					"%s: Can't set time of %s: %s\n",
					argv[0], name, strerror(errno));
				err= 1;
			}
			/* (Ignore uid & gid.) */
		}
		if (ar_size & 1) (void) getchar();
	}
	exit(err);
}
/* Kees J. Bot  4-4-89. */
