#!/bin/sh
#
# @build 1.4 - Execute a command in the build tree.	Author: Kees J. Bot
#

src=`pwd`	# Where the source tree lives.

case $#:$0 in
*:*/@build)
	;;
0:*/@clone)
	set -$- clone -S $src
	;;
*:*/@*)
	set -$- `expr $0 : '.*/@\(.*\)'` "$@"
esac

#
# Change the first occurence of 'src' by 'build'.
#

case $src in
*/src)
	# Path ending in '/src'.
	build=`echo $src | sed 's:/src:/build:'`
	;;
*/src/*)
	# A subdirectory of a 'src' directory.
	build=`echo $src | sed 's:/src/:/build/:'`
	;;
*)
	echo "$0: Directory $src does not appear to be a source directory" >&2
	exit 1
esac

if [ -d $build ]
then
	cd $build || exit
elif [ "$1" = clone ]
then
	install -d $build || exit
	cd $build || exit
else
	echo "$build does not exist." >&2
	echo -n "Is it ok to clone $src? " >&2; read y
	case $y in
	y|Y|yes)	;;
	*)	exit 1
	esac
	install -d $build || exit
	cd $build || exit
	test -t 2 && echo clone -S $src $build >&2
	clone -S $src || exit
fi

test -t 2 && echo "cd $build; $*" >&2
exec $*
