/*
update.h

Create an update out of various items.

Created:	Aug 16, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef UPDATE_H
#define UPDATE_H

typedef struct update
{
	ipaddr_t u_dest;
	ipaddr_t u_subnetmask;
	int u_ifno;
	ipaddr_t u_gateway;
	int u_dist;
} update_t;

struct nwio_route;
int route2update ARGS(( struct nwio_route *route_p, update_t *update_p ));
int update_compare ARGS(( const void *uv1, const void *uv2 ));
void dynr_loadarr ARGS(( void ));

#endif /* UPDATE_H */
