/*
update.c

Created:	Aug 16, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/syslog.h>
#include <sys/types.h>
#include <net/hton.h>
#include <net/gen/in.h>
#include <net/gen/inet.h>
#include <net/gen/rip.h>
#include <net/gen/route.h>

#include "ansi.h"
#include "interface.h"
#include "itab.h"
#include "update.h"

DEFUN
(int update_compare, (uv1, uv2),
	const void *uv1 AND
	const void *uv2
)
{
	update_t *up1, *up2;

	up1= uv1;
	up2= uv2;

	if (up1->u_dest > up2->u_dest)
		return 1;
	else if (up1->u_dest < up2->u_dest)
		return -1;

	if (up1->u_subnetmask > up2->u_subnetmask)
		return 1;
	else if (up1->u_subnetmask < up2->u_subnetmask)
		return -1;

	if (up1->u_ifno > up2->u_ifno)
		return 1;
	else if (up1->u_ifno < up2->u_ifno)
		return -1;

	if (up1->u_gateway > up2->u_gateway)
		return 1;
	else if (up1->u_gateway < up2->u_gateway)
		return -1;

	if (up1->u_dist > up2->u_dist)
		return 1;
	else if (up1->u_dist < up2->u_dist)
		return -1;

	return 0;
}

DEFUN
(int route2update, (route_p, update_p),
	nwio_route_t *route_p AND
	update_t *update_p
)
{
	ipaddr_t ifaddr;
	interface_t *ifp;
	int i;

	ifaddr= ntohl(route_p->nwr_ifaddr);
	for (i= 0, ifp= interface_table; i<interface_no; i++, ifp++)
	{
		if (ifp->if_addr == ifaddr)
			break;
	}
	if (i == interface_no)
	{
		syslog(LOG_WARNING,
			"route2update: interface with address %s not found",
			inet_ntoa(htonl(ifaddr)));
		return -1;
	}
	update_p->u_dest= ntohl(route_p->nwr_dest);
	update_p->u_subnetmask= ntohl(route_p->nwr_netmask);
	update_p->u_ifno= i;
	update_p->u_gateway= ntohl(route_p->nwr_gateway);
	if (route_p->nwr_flags & NWRF_UNREACHABLE)
		update_p->u_dist= RIP_INFINITY;
	else
		update_p->u_dist= route_p->nwr_dist;
	return 0;
}

DEFUN_VOID( void dynr_loadarr)
{
	char *cp1, *cp2, *cp3, *cp4;
	int i, j, ipfd, ent_no;
	nwio_route_t route;
	update_t update;
	update_t *table;

	if (interface_no == 0)
	{
		syslog(LOG_ERR, "dynr_loadarr: no interfaces");
		return;
	}

	ipfd= interface_table->if_ipfd;

	/* Get the maximum number of routing entries */
	route.nwr_ent_no= 0;
	if (ioctl(ipfd, NWIOGIPIROUTE, &route) == -1)
	{
		syslog(LOG_ERR,
			"staticr_load: NWIOGIPIROUTE failed on fd %d: %m",
				ipfd);
		return;
	}
	ent_no= route.nwr_ent_count;

	table= malloc(ent_no * sizeof(update_t));
	if (table == NULL)
	{
		syslog(LOG_ERR, "dynr_loadarr: out of memory");
		return;
	}
	i= 0;
	for (j= 0; j<ent_no; j++)
	{
		route.nwr_ent_no= j;
		if (ioctl(ipfd, NWIOGIPIROUTE, &route) == -1)
		{
			syslog(LOG_ERR,
			"dynr_loadarr: NWIOGIPIROUTE %d failed on fd %d: %m",
					j, ipfd);
			break;
		}
		if ((route.nwr_flags & (NWRF_INUSE|NWRF_STATIC)) != 
			NWRF_INUSE)
		{
			continue;
		}
		if (route2update(&route, &table[i]) == -1)
			continue;
		i++;
	}

	ent_no= i;

	/* Sort the table */
	qsort(table, ent_no, sizeof(update_t), update_compare);

	for (i= 0; i<ent_no; i++)
	{
		cp1= strdup(inet_ntoa(htonl(table[i].u_dest)));
		cp2= strdup(inet_ntoa(htonl(table[i].u_subnetmask)));
		cp3= strdup(inet_ntoa(htonl(table[i].u_gateway)));
			syslog(LOG_DEBUG,
		"dynr_loadarr: dynamic route %d to %s[%s] via %d(%s) dist %d",
					i, cp1, cp2, table[i].u_ifno, 
					cp3, table[i].u_dist);
		free(cp1);
		free(cp2);
		free(cp3);
	}

	itab_update(table, ent_no);
}
