/*
itab.h

Keep track of arrived routing updates.

Created:	Aug 18, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef ITAB_H
#define ITAB_H

typedef struct itab
{
	ipaddr_t it_dest;
	ipaddr_t it_subnetmask;
	int it_ifno;
	ipaddr_t it_gateway;
	int it_dist;
	int it_type;
	time_t it_time;
	struct itab *it_next;
} itab_t;

#define ITT_INVALID	0
#define ITT_DELETED	1
#define ITT_NORMAL	2
#define ITT_SUBNET	3

extern itab_t *i_table;

struct update;
void itab_init ARGS(( void ));
void itab_update ARGS(( struct update *update_p, int undate_no ));
void itab_timeout ARGS(( void ));
void itab_print ARGS(( int logtype, itab_t *ent ));
void itab_print_all ARGS(( int logtype ));

#endif /* ITAB_H */
