/*
interface.h

Keep information about IP interfaces.

Created:	Aug 5, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef INTERFACE_H
#define INTERFACE_H

#define IF_BUF_SIZE	1024	/* Must be at least a udp packet with 512
				 * bytes user data.
				 */
typedef struct interface
{
	ipaddr_t if_addr;
	ipaddr_t if_subnetmask;
	ipaddr_t if_netmask;
	int if_ipfd;
	int if_udpfd;
	int if_inprogress;
	char if_buffer[IF_BUF_SIZE];
} interface_t;

extern int interface_no;
extern interface_t *interface_table;

#define INTERFACE_MAX	16

typedef struct pkt_hdr
{
	size_t ph_datasize;
	struct pkt_hdr *ph_next;
} pkt_hdr_t;

struct asio_fd_set;
void interface_init ARGS(( void ));
void interface_add ARGS(( char *ip_dev, char *udp_dev ));
void interface_send ARGS(( int ifno, char *packet ));
void interface_read ARGS(( struct asio_fd_set *fdset_p ));
void interface_arrived ARGS(( int fd, int operation, int result, int err ));

#endif /* INTERFACE_H */
